/*
 * Decompiled with CFR 0.152.
 */
package util.conpool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import util.ExecutionEnvironment;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.conpool.HttpProxy;
import util.conpool.PooledConnectionInputStream;
import util.conpool.PooledConnectionOutputStream;
import util.conpool.TLSSocketFactory;
import util.http.DOHHttp2Util;

public class Connection
implements TimeoutListener {
    private Socket socket = null;
    private InputStream socketIn;
    private OutputStream socketOut;
    private PooledConnectionInputStream in;
    private PooledConnectionOutputStream out;
    String poolKey;
    TimeoutTime timeout;
    boolean acquired = true;
    boolean valid = true;
    boolean ssl = false;
    boolean doh2 = false;
    private InetSocketAddress sadr;
    private int conTimeout;
    private SSLSocketFactory sslSocketFactory;
    private Proxy proxy;
    private int http2StreamID = 1;
    private boolean isFresh = true;
    private static int maxHttp2StreamID = Integer.MAX_VALUE;
    private static byte[] NO_IP = new byte[4];
    private static HashMap connPooled = new HashMap();
    private static HashSet connAcquired = new HashSet();
    private static Hashtable CUSTOM_HOSTS = Connection.getCustomHosts();
    private static String CUSTOM_HOSTS_FILE_NAME = null;
    private static int POOLTIMEOUT_SECONDS = 300;
    private static TimoutNotificator toNotify = TimoutNotificator.getNewInstance();
    private static SSLSocketFactory defaultSSLSocketFactory = null;

    private Connection(String host, int port, int conTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, Proxy proxy, boolean doh2) throws IOException {
        InetAddress adr = null;
        if (CUSTOM_HOSTS != null) {
            adr = (InetAddress)CUSTOM_HOSTS.get(host);
        }
        if (adr == null) {
            adr = proxy == Proxy.NO_PROXY ? InetAddress.getByName(host) : InetAddress.getByAddress(host, NO_IP);
        }
        InetSocketAddress sadr = new InetSocketAddress(adr, port);
        this.poolKey = Connection.poolKey(host, port, ssl, proxy, doh2);
        this.initConnection(sadr, conTimeout, ssl, sslSocketFactory, proxy, doh2);
        this.timeout = new TimeoutTime(toNotify);
    }

    private Connection(InetSocketAddress sadr, int conTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, Proxy proxy, boolean doh2) throws IOException {
        this.poolKey = Connection.poolKey(sadr.getAddress().getHostAddress(), sadr.getPort(), ssl, proxy, doh2);
        this.initConnection(sadr, conTimeout, ssl, sslSocketFactory, proxy, doh2);
        this.timeout = new TimeoutTime(toNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connect(InetSocketAddress sadr, int conTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, Proxy proxy, boolean doh2) throws IOException {
        Connection con = Connection.poolRemove(Connection.poolKey(sadr.getAddress().getHostAddress(), sadr.getPort(), ssl, proxy, doh2));
        if (con == null) {
            con = new Connection(sadr, conTimeout, ssl, sslSocketFactory, proxy, doh2);
        }
        con.initStreams();
        HashSet hashSet = connAcquired;
        synchronized (hashSet) {
            connAcquired.add(con);
        }
        return con;
    }

    public static Connection connect(InetSocketAddress sadr, int conTimeout) throws IOException {
        return Connection.connect(sadr, conTimeout, false, null, Proxy.NO_PROXY, false);
    }

    public static Connection connect(InetSocketAddress address) throws IOException {
        return Connection.connect(address, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connect(String host, int port, int conTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, Proxy proxy) throws IOException {
        Connection con = Connection.poolRemove(Connection.poolKey(host, port, ssl, proxy, false));
        if (con == null) {
            con = new Connection(host, port, conTimeout, ssl, sslSocketFactory, proxy, false);
        }
        con.initStreams();
        HashSet hashSet = connAcquired;
        synchronized (hashSet) {
            connAcquired.add(con);
        }
        return con;
    }

    public static Connection connect(String host, int port) throws IOException {
        return Connection.connect(host, port, -1, false, null, Proxy.NO_PROXY);
    }

    public static Connection connect(String host, int port, int conTimeout) throws IOException {
        return Connection.connect(host, port, conTimeout, false, null, Proxy.NO_PROXY);
    }

    private static String poolKey(String host, int port, boolean ssl, Proxy proxy, boolean doh2) {
        if (ssl) {
            return String.valueOf(host) + ":" + port + ":" + "ssl:" + proxy.hashCode() + ":" + doh2;
        }
        return String.valueOf(host) + ":" + port + ":" + "plain:" + proxy.hashCode() + ":" + doh2;
    }

    public static synchronized void addCustomHost(InetAddress adr) {
        if (CUSTOM_HOSTS == null) {
            CUSTOM_HOSTS = new Hashtable();
        }
        CUSTOM_HOSTS.put(adr.getHostName(), adr);
    }

    public static void setCustomHostsFile(String filename) {
        CUSTOM_HOSTS_FILE_NAME = filename;
    }

    private static Hashtable getCustomHosts() {
        if (CUSTOM_HOSTS_FILE_NAME == null) {
            return null;
        }
        File hostsFile = new File(String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + CUSTOM_HOSTS_FILE_NAME);
        String entry = null;
        Hashtable<String, InetAddress> custom_hosts = null;
        try {
            if (hostsFile.exists()) {
                custom_hosts = new Hashtable<String, InetAddress>();
                BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(hostsFile)));
                while ((entry = fin.readLine()) != null) {
                    String[] hostEntry = Connection.parseHosts(entry);
                    if (hostEntry == null) continue;
                    custom_hosts.put(hostEntry[1], InetAddress.getByName(hostEntry[0]));
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return custom_hosts;
    }

    private static String[] parseHosts(String line) {
        if (line.startsWith("#") || line.trim().equals("")) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(line);
        if (tokens.countTokens() >= 2) {
            String ip = tokens.nextToken().trim();
            String host = tokens.nextToken().trim();
            return new String[]{ip, host};
        }
        String ip = "127.0.0.1";
        String host = tokens.nextToken().trim();
        return new String[]{ip, host};
    }

    private void initConnection(InetSocketAddress sadr, int conTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, Proxy proxy, boolean doh2) throws IOException {
        this.sadr = sadr;
        this.conTimeout = conTimeout;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.proxy = proxy;
        this.doh2 = doh2;
        this.establishConnection();
    }

    private SSLSocketFactory getDefaultSSLSocketFactory() throws IOException {
        if (defaultSSLSocketFactory != null) {
            return defaultSSLSocketFactory;
        }
        boolean useTLSSocketFactory = ExecutionEnvironment.getEnvironment().getEnvironmentID() == 1 && Integer.parseInt(ExecutionEnvironment.getEnvironment().getEnvironmentVersion()) < 21;
        try {
            defaultSSLSocketFactory = useTLSSocketFactory ? new TLSSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
            return defaultSSLSocketFactory;
        }
        catch (Exception e) {
            throw new IOException("Cannot get TLSSocketFactory", e);
        }
    }

    private void establishConnection() throws IOException {
        if (this.conTimeout < 0) {
            this.conTimeout = 0;
        }
        if (this.doh2) {
            this.socket = this.establishDOH2Connection();
        } else {
            if (this.proxy == Proxy.NO_PROXY) {
                this.socket = SocketChannel.open().socket();
                ExecutionEnvironment.getEnvironment().protectSocket(this.socket, 0);
                this.socket.connect(this.sadr, this.conTimeout);
            } else {
                if (!(this.proxy instanceof HttpProxy)) {
                    throw new IOException("Only " + HttpProxy.class.getName() + " supported for creating connection over tunnel!");
                }
                this.socket = ((HttpProxy)this.proxy).openTunnel(this.sadr, this.conTimeout, true);
            }
            if (this.ssl) {
                this.socket.setSoTimeout(this.conTimeout);
                if (this.sslSocketFactory == null) {
                    this.sslSocketFactory = this.getDefaultSSLSocketFactory();
                }
                this.socket = this.sslSocketFactory.createSocket(this.socket, this.sadr.getHostName(), this.sadr.getPort(), true);
                this.ssl = true;
            }
        }
        this.socketIn = this.socket.getInputStream();
        this.socketOut = this.socket.getOutputStream();
        if (this.ssl) {
            this.socket.setSoTimeout(0);
        }
    }

    private Socket establishDOH2Connection() throws IOException {
        SSLSocket s = DOHHttp2Util.openHttp2Socket(this.sadr, this.conTimeout, this.proxy);
        this.http2StreamID = 1;
        return s;
    }

    public void refreshConnection() throws IOException {
        int sock_timeout = 0;
        if (this.socket != null) {
            sock_timeout = this.socket.getSoTimeout();
        }
        try {
            this.in.invalidate();
            this.out.invalidate();
            if (!this.ssl) {
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.establishConnection();
        this.socket.setSoTimeout(sock_timeout);
        this.initStreams();
        this.isFresh = true;
    }

    public static void setPoolTimeoutSeconds(int secs) {
        POOLTIMEOUT_SECONDS = secs;
    }

    private void initStreams() {
        this.in = new PooledConnectionInputStream(this.socketIn);
        this.out = new PooledConnectionOutputStream(this.socketOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invalidate() {
        Vector<Connection> toBeReleased = new Vector<Connection>();
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            HashSet hashSet = connAcquired;
            synchronized (hashSet) {
                Vector[] destinations = connPooled.values().toArray(new Vector[0]);
                int i = 0;
                while (i < destinations.length) {
                    Connection[] cons = destinations[i].toArray(new Connection[destinations[i].size()]);
                    int ii = 0;
                    while (ii < cons.length) {
                        toBeReleased.add(cons[ii]);
                        cons[ii].valid = false;
                        destinations[i].remove(cons[ii]);
                        ++ii;
                    }
                    connPooled.remove(destinations[i]);
                    ++i;
                }
                Connection[] cons = connAcquired.toArray(new Connection[connAcquired.size()]);
                int i2 = 0;
                while (i2 < cons.length) {
                    toBeReleased.add(cons[i2]);
                    cons[i2].valid = false;
                    connAcquired.remove(cons[i2]);
                    ++i2;
                }
            }
        }
        Connection[] cons = toBeReleased.toArray(new Connection[toBeReleased.size()]);
        int i = 0;
        while (i < cons.length) {
            cons[i].closeConnection();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void poolReuse(Connection con) {
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            if (!con.valid) {
                return;
            }
            if (!con.acquired) {
                throw new IllegalStateException("Inconsistent connection state - Cannot release non acquired connection");
            }
            con.acquired = false;
            Vector<Connection> hostCons = (Vector<Connection>)connPooled.get(con.poolKey);
            if (hostCons == null) {
                hostCons = new Vector<Connection>();
                connPooled.put(con.poolKey, hostCons);
            }
            toNotify.register(con);
            con.timeout.setTimeout(POOLTIMEOUT_SECONDS * 1000);
            hostCons.add(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection poolRemove(String key) {
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            Vector hostCons;
            block7: {
                hostCons = (Vector)connPooled.get(key);
                if (hostCons != null) break block7;
                return null;
            }
            boolean found = false;
            Connection con = null;
            while (!found && !hostCons.isEmpty()) {
                con = (Connection)hostCons.remove(hostCons.size() - 1);
                if (con.acquired) {
                    throw new IllegalStateException("Inconsistent connection state - Cannot take already acquired connection from pool!");
                }
                con.acquired = true;
                toNotify.unregister(con);
                boolean bl = found = con.valid && con.isAlive();
                if (found) continue;
                con.closeConnection();
                con = null;
            }
            if (hostCons.isEmpty()) {
                connPooled.remove(key);
            }
            return con;
        }
    }

    private boolean isAlive() {
        if (this.doh2) {
            return true;
        }
        try {
            this.socket.setSoTimeout(1);
            int r = this.socketIn.read();
            if (r != -1) {
                int avail = this.socketIn.available();
                byte[] buf = new byte[Math.max(avail, 10240)];
                this.socketIn.read(buf);
                String string = String.valueOf((char)r) + new String(buf);
            }
            return false;
        }
        catch (SocketTimeoutException to) {
            try {
                this.socket.setSoTimeout(0);
                return true;
            }
            catch (SocketException e) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean reuse) {
        if (!this.valid) {
            return;
        }
        this.isFresh = false;
        HashSet hashSet = connAcquired;
        synchronized (hashSet) {
            connAcquired.remove(this);
        }
        if (reuse) {
            this.in.invalidate();
            this.out.invalidate();
            if (this.doh2) {
                if (this.http2StreamID >= maxHttp2StreamID) {
                    this.release(false);
                    return;
                }
                this.http2StreamID += 2;
            }
            try {
                this.socket.setSoTimeout(0);
            }
            catch (SocketException e) {
                this.release(false);
                return;
            }
            Connection.poolReuse(this);
        } else {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        try {
            this.valid = false;
            if (!this.ssl) {
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
            }
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSoTimeout(int millis) throws SocketException {
        this.socket.setSoTimeout(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timeoutNotification() {
        boolean found = false;
        HashMap hashMap = connPooled;
        synchronized (hashMap) {
            Vector hostCons = (Vector)connPooled.get(this.poolKey);
            if (hostCons == null) {
                return;
            }
            found = hostCons.remove(this);
            if (hostCons.isEmpty()) {
                connPooled.remove(this.poolKey);
            }
        }
        if (found) {
            this.closeConnection();
        }
    }

    @Override
    public long getTimoutTime() {
        return this.timeout.getTimeout();
    }

    public long[] getTraffic() {
        if (!this.acquired) {
            throw new IllegalStateException("Inconsistent connection state - Connection is not acquired!");
        }
        return new long[]{this.in.getTraffic(), this.out.getTraffic()};
    }

    public String getDestination() {
        return this.poolKey;
    }

    public int getHttp2StreamID() {
        return this.http2StreamID;
    }

    public boolean isFresh() {
        return this.isFresh;
    }
}

