/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.HashSet;
import java.util.Vector;
import util.TimeoutListener;

public class TimoutNotificator
implements Runnable {
    public static TimoutNotificator instance = new TimoutNotificator();
    public HashSet listeners = new HashSet();
    public boolean threadAvailable = false;
    private boolean stopped = false;
    private volatile long curTime = 0L;

    public static TimoutNotificator getInstance() {
        return instance;
    }

    public static TimoutNotificator getNewInstance() {
        return new TimoutNotificator();
    }

    public synchronized void register(TimeoutListener listener) {
        this.listeners.add(listener);
        if (!this.threadAvailable) {
            this.curTime = System.currentTimeMillis();
            this.threadAvailable = true;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Vector<TimeoutListener> toListeners = new Vector<TimeoutListener>();
        boolean exitThread = false;
        while (!exitThread) {
            TimoutNotificator timoutNotificator = this;
            synchronized (timoutNotificator) {
                toListeners.removeAllElements();
                this.curTime = System.currentTimeMillis();
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.curTime += 1000L;
                if (!this.stopped) {
                    TimeoutListener[] allListeners = this.listeners.toArray(new TimeoutListener[0]);
                    int i = 0;
                    while (i < allListeners.length) {
                        long tOut = allListeners[i].getTimoutTime();
                        if (this.curTime > tOut) {
                            this.listeners.remove(allListeners[i]);
                            toListeners.add(allListeners[i]);
                        }
                        ++i;
                    }
                }
                boolean bl = exitThread = this.listeners.isEmpty() || this.stopped;
                if (exitThread) {
                    this.threadAvailable = false;
                }
            }
            TimeoutListener[] allToListeners = toListeners.toArray(new TimeoutListener[0]);
            int i = 0;
            while (i < allToListeners.length) {
                allToListeners[i].timeoutNotification();
                ++i;
            }
        }
    }

    public synchronized void shutdown() {
        this.stopped = true;
        this.notifyAll();
    }

    public long getCurrentTime() {
        if (this.threadAvailable) {
            return this.curTime;
        }
        return System.currentTimeMillis();
    }

    public synchronized void unregister(TimeoutListener l) {
        this.listeners.remove(l);
    }
}

