/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Vector;
import util.LRUCache;

public class PatternSequence {
    private static Object NULL = new Object();
    Vector<Pattern> patternList = new Vector();
    LRUCache matchedPatternCache = new LRUCache(1000);

    public boolean addPattern(String pattern, Object value) {
        this.matchedPatternCache.clear();
        return this.patternList.add(new Pattern(pattern, value));
    }

    public boolean removePattern(String pattern, Object value) {
        this.matchedPatternCache.clear();
        return this.patternList.remove(new Pattern(pattern, value));
    }

    public Object match(String s) {
        Object value = this.matchedPatternCache.get(s);
        if (value == NULL) {
            return null;
        }
        if (value != null) {
            return value;
        }
        for (Pattern pattern : this.patternList) {
            value = pattern.match(s);
            if (value == null) continue;
            this.matchedPatternCache.put(s, value);
            return value;
        }
        this.matchedPatternCache.put(s, NULL);
        return null;
    }

    public void clear() {
        this.patternList.clear();
    }

    private class Pattern {
        private String[] pattern;
        private Object value;
        private int hashcode;

        private Pattern(String patternString, Object value) {
            this.pattern = patternString.split("\\*", -1);
            this.value = value;
            this.hashcode = patternString.hashCode() + value.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj != null && this.hashcode == obj.hashCode() && obj instanceof Pattern) {
                return this.patternEqual((Pattern)obj);
            }
            return false;
        }

        private boolean patternEqual(Pattern overrulePattern) {
            if (this.pattern.length == overrulePattern.pattern.length && overrulePattern.value.equals(this.value)) {
                int i = 0;
                while (i < this.pattern.length) {
                    if (!this.pattern[i].equals(overrulePattern.pattern[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }

        public Object match(String s) {
            int i = 0;
            while (i < this.pattern.length) {
                String part = this.pattern[i];
                int idx = -1;
                idx = i < this.pattern.length - 1 ? s.indexOf(part) : s.lastIndexOf(part);
                if (i == 0 && !part.equals("") && idx != 0) {
                    return null;
                }
                if (i == this.pattern.length - 1 && !part.equals("") && idx + part.length() != s.length()) {
                    return null;
                }
                if (idx == -1) {
                    return null;
                }
                s = s.substring(idx + part.length());
                ++i;
            }
            return this.value;
        }
    }
}

