/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import util.ObjectPackagingManager;

public class PackedSortedList
implements List,
RandomAccess {
    private boolean keepInMemory;
    private boolean persistentOutdated;
    private boolean loaded = false;
    private int object_size;
    private byte[] datapack = null;
    private int count = 0;
    private File persistedPackFile;
    private RandomAccessFile persistedPackData = null;
    private ObjectPackagingManager objMgr;
    private int persistedPackDataRefs = 0;

    public PackedSortedList(int size, ObjectPackagingManager objMgr) {
        this.objMgr = objMgr;
        this.object_size = objMgr.objectSize();
        this.datapack = new byte[size * this.object_size];
        this.keepInMemory = true;
        this.loaded = true;
    }

    private PackedSortedList(byte[] datapack, int count, boolean inMemory, File persistedPackFile, ObjectPackagingManager objMgr) throws IOException {
        this.objMgr = objMgr;
        this.object_size = objMgr.objectSize();
        this.datapack = datapack;
        this.count = count;
        this.keepInMemory = inMemory;
        this.persistedPackFile = persistedPackFile;
        this.persistentOutdated = false;
        if (inMemory) {
            this.loadinMemory();
        }
    }

    private int binarySearch(Object key) {
        return Collections.binarySearch(this, key);
    }

    @Override
    public boolean add(Object key) {
        int pos = -(this.binarySearch(key) + 1);
        if (pos < 0) {
            return false;
        }
        this.addInternal(pos, key);
        return true;
    }

    private void addInternal(int pos, Object key) {
        if (!this.loaded) {
            this.loadinMemory();
        }
        byte[] destination = this.datapack;
        if (this.count >= this.datapack.length / this.object_size) {
            destination = new byte[this.datapack.length + 1000 * this.object_size];
            System.arraycopy(this.datapack, 0, destination, 0, pos * this.object_size);
        }
        if (pos != this.count) {
            System.arraycopy(this.datapack, pos * this.object_size, destination, pos * this.object_size + this.object_size, (this.count - pos) * this.object_size);
        }
        this.datapack = destination;
        this.objMgr.objectToBytes(key, this.datapack, pos * this.object_size);
        this.persistentOutdated = true;
        ++this.count;
    }

    public void add(int arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    public boolean addAll(int arg0, Collection arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private synchronized void releaseDataPack() {
        try {
            --this.persistedPackDataRefs;
            if (this.persistedPackDataRefs < 0) {
                throw new IllegalStateException("Inconsistent state! persistedPackDataRefs = " + this.persistedPackDataRefs);
            }
            if (this.persistedPackDataRefs == 0) {
                this.persistedPackData.close();
                this.persistedPackData = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void acquireDataPack() throws FileNotFoundException {
        if (this.persistedPackData == null) {
            if (this.persistedPackDataRefs > 0) {
                throw new IllegalStateException("Inconsistent state! persistedPackData is null but there are " + this.persistedPackDataRefs + " references!");
            }
            this.persistedPackData = new RandomAccessFile(this.persistedPackFile, "r");
        }
        ++this.persistedPackDataRefs;
    }

    @Override
    public boolean contains(Object key) {
        int pos;
        block6: {
            pos = -1;
            if (!this.loaded) {
                try {
                    try {
                        this.acquireDataPack();
                        pos = this.binarySearch(key);
                        break block6;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                finally {
                    this.releaseDataPack();
                }
            }
            pos = this.binarySearch(key);
        }
        return pos > -1;
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int pos) {
        if (pos >= this.count) {
            return null;
        }
        int offs = pos * this.object_size;
        if (this.loaded) {
            return this.objMgr.bytesToObject(this.datapack, offs);
        }
        try {
            this.acquireDataPack();
            byte[] obj = new byte[this.object_size];
            RandomAccessFile randomAccessFile = this.persistedPackData;
            synchronized (randomAccessFile) {
                this.persistedPackData.seek(offs);
                this.persistedPackData.readFully(obj);
            }
            Object object = this.objMgr.bytesToObject(obj, 0);
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.releaseDataPack();
        }
    }

    @Override
    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException();
    }

    public Object set(int arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.count;
    }

    public List subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        throw new UnsupportedOperationException();
    }

    public void persist(String path) throws IOException {
        if (this.persistentOutdated) {
            if (!this.loaded) {
                throw new IOException("PackedSortedList can not be persisted when not in memory!");
            }
            this.persistedPackFile = new File(path);
            try (FileOutputStream out = new FileOutputStream(this.persistedPackFile);){
                out.write(this.datapack, 0, this.count * this.object_size);
                out.flush();
            }
            this.persistentOutdated = false;
        }
        if (!this.keepInMemory) {
            this.datapack = null;
            this.loaded = false;
        }
    }

    private void loadinMemory() {
        try {
            FileInputStream in = new FileInputStream(this.persistedPackFile);
            int size = this.count * this.objMgr.objectSize();
            this.datapack = new byte[size];
            int r = 0;
            int offs = 0;
            while ((r = in.read(this.datapack, offs, size - offs)) != -1 && offs != size) {
                offs += r;
            }
            in.close();
            this.loaded = true;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public static PackedSortedList load(String path, boolean inMemory, ObjectPackagingManager objMgr) throws IOException {
        File f = new File(path);
        int size = (int)f.length();
        if (!f.exists() || !f.canRead()) {
            throw new IOException("Cannot read " + path);
        }
        return new PackedSortedList(null, size / objMgr.objectSize(), inMemory, f, objMgr);
    }

    public void clearAndReleaseAllMemory() {
        this.count = 0;
        this.datapack = new byte[0];
    }
}

