/*
 * Decompiled with CFR 0.152.
 */
package ip;

import ip.CheckSum;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class IPPacket {
    static short curID = (short)(Math.random() * 32767.0);
    static Object ID_SYNC = new Object();
    protected IntBuffer ipHeader;
    protected int version = 0;
    protected int len;
    protected int ipHdrlen;
    protected int offset;
    protected byte[] data;

    public IPPacket(byte[] packet, int offs, int len) {
        this.version = packet[offs] >> 4;
        this.data = packet;
        this.offset = offs;
        this.len = len;
        if (this.version == 4) {
            this.ipHeader = ByteBuffer.wrap(packet, offs, 20).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            this.ipHdrlen = 20;
        } else if (this.version == 6) {
            this.ipHeader = ByteBuffer.wrap(packet, offs, 40).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
            this.ipHdrlen = 40;
        } else {
            throw new IllegalArgumentException("Invalid version:" + this.version);
        }
    }

    protected void initIPHeader(int TTL, int prot, int[] sourceIP, int[] destIP) {
        if (this.version == 4) {
            int[] hdrPacket = new int[]{0x45000000 + this.len, IPPacket.generateId(), (TTL << 24) + (prot << 16), sourceIP[0], destIP[0]};
            this.ipHeader.position(0);
            this.ipHeader.put(hdrPacket);
            hdrPacket[2] = hdrPacket[2] + this.calculateCheckSum();
            this.ipHeader.put(2, hdrPacket[2]);
        } else if (this.version == 6) {
            int[] hdrPacket = new int[]{this.version << 28, (this.len - 40 << 16) + (prot << 8) + TTL};
            this.ipHeader.position(0);
            this.ipHeader.put(hdrPacket);
            this.ipHeader.put(sourceIP);
            this.ipHeader.put(destIP);
        } else {
            throw new IllegalStateException("Illegal version:" + this.version);
        }
    }

    protected void initInitialIPHeader() {
        if (this.version == 4) {
            int[] hdrPacket = new int[]{0x45000000 + this.len, IPPacket.generateId(), 0, 0, 0};
            this.ipHeader.position(0);
            this.ipHeader.put(hdrPacket);
        } else if (this.version == 6) {
            int[] hdrPacket = new int[]{this.version << 28, this.len - 40 << 16};
            this.ipHeader.position(0);
            this.ipHeader.put(hdrPacket);
        } else {
            throw new IllegalStateException("Illegal version:" + this.version);
        }
    }

    public static IPPacket createInitialIPPacket(byte[] packet, int offs, int len, int version) {
        packet[offs] = (byte)(version << 4 & 0xFF);
        IPPacket ip = new IPPacket(packet, offs, len);
        ip.initInitialIPHeader();
        return ip;
    }

    public static IPPacket createIPPacket(byte[] packet, int offs, int len, int version, int TTL, int prot, int[] sourceIP, int[] destIP) {
        packet[offs] = (byte)(version << 4 & 0xFF);
        IPPacket ip = new IPPacket(packet, offs, len);
        ip.initIPHeader(TTL, prot, sourceIP, destIP);
        return ip;
    }

    public static int[] ip2int(InetAddress ip) {
        byte[] b = ip.getAddress();
        if (b.length == 4) {
            return new int[]{b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24};
        }
        return new int[]{b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24, b[7] & 0xFF | (b[6] & 0xFF) << 8 | (b[5] & 0xFF) << 16 | (b[4] & 0xFF) << 24, b[11] & 0xFF | (b[10] & 0xFF) << 8 | (b[9] & 0xFF) << 16 | (b[8] & 0xFF) << 24, b[15] & 0xFF | (b[14] & 0xFF) << 8 | (b[13] & 0xFF) << 16 | (b[12] & 0xFF) << 24};
    }

    public static InetAddress int2ip(int[] ip) throws UnknownHostException {
        byte[] b;
        if (ip.length == 1) {
            b = new byte[]{(byte)(ip[0] >> 24 & 0xFF), (byte)(ip[0] >> 16 & 0xFF), (byte)(ip[0] >> 8 & 0xFF), (byte)(ip[0] & 0xFF)};
        } else if (ip.length == 4) {
            b = new byte[]{(byte)(ip[0] >> 24 & 0xFF), (byte)(ip[0] >> 16 & 0xFF), (byte)(ip[0] >> 8 & 0xFF), (byte)(ip[0] & 0xFF), (byte)(ip[1] >> 24 & 0xFF), (byte)(ip[1] >> 16 & 0xFF), (byte)(ip[1] >> 8 & 0xFF), (byte)(ip[1] & 0xFF), (byte)(ip[2] >> 24 & 0xFF), (byte)(ip[2] >> 16 & 0xFF), (byte)(ip[2] >> 8 & 0xFF), (byte)(ip[2] & 0xFF), (byte)(ip[3] >> 24 & 0xFF), (byte)(ip[3] >> 16 & 0xFF), (byte)(ip[3] >> 8 & 0xFF), (byte)(ip[3] & 0xFF)};
        } else {
            throw new IllegalArgumentException("Invalid array length:" + ip.length);
        }
        return InetAddress.getByAddress(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateId() {
        Object object = ID_SYNC;
        synchronized (object) {
            curID = (short)(curID + 1);
            return curID << 16;
        }
    }

    private int calculateCheckSum() {
        if (this.version == 4) {
            return CheckSum.chkSum(this.data, this.offset, 20);
        }
        return 0;
    }

    public int checkCheckSum() {
        return this.calculateCheckSum();
    }

    public void updateHeader(int TTL, int prot, int[] sourceIP, int[] destIP) {
        if (this.version == 4) {
            int[] hdrPacket = new int[3];
            this.ipHeader.position(2);
            this.ipHeader.get(hdrPacket);
            hdrPacket[0] = (TTL << 24) + (prot << 16);
            hdrPacket[1] = sourceIP[0];
            hdrPacket[2] = destIP[0];
            this.ipHeader.position(2);
            this.ipHeader.put(hdrPacket);
            hdrPacket[0] = hdrPacket[0] + this.calculateCheckSum();
            this.ipHeader.put(2, hdrPacket[0]);
        } else if (this.version == 6) {
            int hdr = this.ipHeader.get(1);
            hdr = (hdr & 0xFFFF0000) + (prot << 8) + TTL;
            this.ipHeader.position(1);
            this.ipHeader.put(hdr);
            this.ipHeader.put(sourceIP);
            this.ipHeader.put(destIP);
        } else {
            throw new IllegalStateException("Illegal version:" + this.version);
        }
    }

    public int getVersion() {
        return this.version;
    }

    private int[] copyFromHeader(int pos, int count) {
        this.ipHeader.position(pos);
        int[] result = new int[count];
        this.ipHeader.get(result, 0, count);
        return result;
    }

    public int[] getSourceIP() {
        if (this.version == 4) {
            return this.copyFromHeader(3, 1);
        }
        if (this.version == 6) {
            return this.copyFromHeader(2, 4);
        }
        throw new IllegalStateException("Illegal version:" + this.version);
    }

    public int[] getDestIP() {
        if (this.version == 4) {
            return this.copyFromHeader(4, 1);
        }
        if (this.version == 6) {
            return this.copyFromHeader(6, 4);
        }
        throw new IllegalStateException("Illegal version:" + this.version);
    }

    public int getTTL() {
        if (this.version == 4) {
            return this.ipHeader.get(2) >>> 24;
        }
        if (this.version == 6) {
            return this.ipHeader.get(1) & 0xFF;
        }
        throw new IllegalStateException("Illegal version:" + this.version);
    }

    public int getProt() {
        if (this.version == 4) {
            return this.ipHeader.get(2) >>> 16 & 0xFF;
        }
        if (this.version == 6) {
            return this.ipHeader.get(1) >>> 8 & 0xFF;
        }
        throw new IllegalStateException("Illegal version:" + this.version);
    }

    public int getLength() {
        if (this.version == 4) {
            return this.ipHeader.get(0) & 0xFFFF;
        }
        if (this.version == 6) {
            return 40 + (this.ipHeader.get(1) >>> 16);
        }
        throw new IllegalStateException("Illegal version:" + this.version);
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getHeaderLength() {
        return this.ipHdrlen;
    }
}

