/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter.remote;

import dnsfilter.ConfigurationAccess;
import dnsfilter.DNSFilterManager;
import dnsfilter.remote.RemoteAccessClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Properties;
import util.AsyncLogger;
import util.Encryption;
import util.GroupedLogger;
import util.Logger;
import util.LoggerInterface;
import util.SuppressRepeatingsLogger;
import util.TimeoutListener;
import util.TimoutNotificator;
import util.Utils;

public class RemoteAccessServer
implements Runnable {
    private static int sessionId = 0;
    boolean stopped = false;
    private ServerSocket server;
    private HashMap sessions = new HashMap();

    public RemoteAccessServer(int port, String keyphrase) throws IOException {
        Encryption.init_AES(keyphrase);
        this.server = new ServerSocket(port);
        new Thread(this).start();
        Logger.getLogger().logLine("Started RemoteAccess Server on port " + port);
    }

    private String readStringFromStream(InputStream in, byte[] buf) throws IOException {
        int r = Utils.readLineBytesFromStream(in, buf, true, false);
        if (r == -1) {
            throw new EOFException("Stream is closed!");
        }
        return new String(buf, 0, r).trim();
    }

    public void invalidate() {
        RemoteSession[] sessionarray = this.sessions.values().toArray(new RemoteSession[this.sessions.size()]);
        int i = 0;
        while (i < sessionarray.length) {
            sessionarray[i].invalidate();
            ++i;
        }
    }

    @Override
    public void run() {
        while (!this.stopped) {
            try {
                Socket con = this.server.accept();
                InputStream in = Encryption.getDecryptedStream(con.getInputStream());
                OutputStream out = Encryption.getEncryptedOutputStream(con.getOutputStream(), 1024);
                try {
                    byte[] buf = new byte[1024];
                    String version = this.readStringFromStream(in, buf);
                    String option = this.readStringFromStream(in, buf);
                    if (option.equals("new_session")) {
                        out.write("OK\n".getBytes());
                        out.write((String.valueOf(++sessionId) + "\n").getBytes());
                        out.write((String.valueOf(ConfigurationAccess.getLocal().getVersion()) + "\n").getBytes());
                        out.write((String.valueOf(ConfigurationAccess.getLocal().getLastDNSAddress()) + "\n").getBytes());
                        out.write((String.valueOf(ConfigurationAccess.getLocal().openConnectionsCount()) + "\n").getBytes());
                        out.flush();
                        new RemoteSession(con, in, out, sessionId);
                        continue;
                    }
                    if (option.equals("reconnect_session")) {
                        int id;
                        try {
                            id = Integer.parseInt(this.readStringFromStream(in, buf));
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        RemoteSession session = (RemoteSession)this.sessions.get(id);
                        if (session == null) {
                            throw new IOException("Reconnect session not found:" + id);
                        }
                        session.reconnectSession(con, in, out);
                        out.write("OK\n".getBytes());
                        out.flush();
                        continue;
                    }
                    throw new IOException("Invalid option: " + option);
                }
                catch (IOException e) {
                    out.write(e.toString().getBytes());
                    out.flush();
                    Utils.closeSocket(con);
                    throw e;
                }
            }
            catch (IOException e) {
                Logger.getLogger().logLine("RemoteServerException: " + e.toString());
            }
        }
    }

    public void stop() {
        this.stopped = true;
        RemoteSession[] remoteSessions = this.sessions.values().toArray(new RemoteSession[0]);
        int i = 0;
        while (i < remoteSessions.length) {
            remoteSessions[i].killSession();
            ++i;
        }
        try {
            this.server.close();
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    private class RemoteSession
    implements Runnable,
    TimeoutListener {
        int id;
        int connectedSessionId = -1;
        Socket socket;
        SuppressRepeatingsLogger remoteLogger;
        boolean killed = false;
        boolean doReconnect = false;
        DataOutputStream out;
        DataInputStream in;
        boolean remoteStreamSession = false;
        long timeout = Long.MAX_VALUE;
        long lastHeartBeatConfirm = System.currentTimeMillis();

        private RemoteSession(Socket con, InputStream in, OutputStream out, int id) throws IOException {
            this.id = id;
            this.socket = con;
            this.out = new DataOutputStream(out);
            this.in = new DataInputStream(in);
            RemoteAccessServer.this.sessions.put(id, this);
            Logger.getLogger().logLine("New Remote Session " + id + " from :" + con);
            new Thread(this).start();
        }

        public void killSession() {
            RemoteSession connectedSession;
            if (this.killed) {
                return;
            }
            this.killed = true;
            TimoutNotificator.getInstance().unregister(this);
            if (this.remoteLogger != null) {
                this.remoteLogger.closeLogger();
                ((GroupedLogger)Logger.getLogger()).detachLogger(this.remoteLogger);
            }
            Utils.closeSocket(this.socket);
            RemoteAccessServer.this.sessions.remove(this.id);
            if (this.connectedSessionId != -1 && (connectedSession = (RemoteSession)RemoteAccessServer.this.sessions.get(this.connectedSessionId)) != null) {
                connectedSession.killSession();
            }
        }

        public void reconnectSession(Socket con, InputStream in, OutputStream out) throws IOException {
            this.doReconnect = true;
            Socket old = this.socket;
            this.socket = con;
            this.out = new DataOutputStream(con.getOutputStream());
            this.in = new DataInputStream(con.getInputStream());
            Utils.closeSocket(old);
        }

        @Override
        public void run() {
            byte[] buf = new byte[1024];
            String action = "";
            while (!this.killed) {
                try {
                    action = RemoteAccessServer.this.readStringFromStream(this.in, buf);
                    if (action.equals("attach")) {
                        this.attachStream();
                        continue;
                    }
                    if (action.equals("releaseConfiguration()")) {
                        this.killSession();
                        continue;
                    }
                    if (action.equals("confirmHeartBeat()")) {
                        this.heartBeatConfirmed();
                        continue;
                    }
                    this.executeAction(action);
                }
                catch (ConfigurationAccess.ConfigurationAccessException e) {
                    Logger.getLogger().logLine("RemoteServer Exception processing " + action + "! " + e.toString());
                }
                catch (IOException e) {
                    if (!this.doReconnect) {
                        if (this.killed) continue;
                        Logger.getLogger().logLine("Exception during RemoteServer Session read! " + e.toString());
                        this.killSession();
                        break;
                    }
                    Logger.getLogger().logLine("Reconnected Remote!");
                    this.doReconnect = false;
                }
            }
            Logger.getLogger().logLine("Remote Session " + this.id + " closed! " + this.socket);
        }

        private void executeAction(String action) throws IOException {
            block19: {
                try {
                    if (action.equals("getConfig()")) {
                        Properties config = ConfigurationAccess.getLocal().getConfig();
                        this.out.write("OK\n".getBytes());
                        ObjectOutputStream objout = new ObjectOutputStream(this.out);
                        objout.writeObject(config);
                        objout.flush();
                        break block19;
                    }
                    if (action.equals("getDefaultConfig()")) {
                        Properties config = ConfigurationAccess.getLocal().getDefaultConfig();
                        this.out.write("OK\n".getBytes());
                        ObjectOutputStream objout = new ObjectOutputStream(this.out);
                        objout.writeObject(config);
                        objout.flush();
                        break block19;
                    }
                    if (action.equals("readConfig()")) {
                        byte[] result = ConfigurationAccess.getLocal().readConfig();
                        this.out.write("OK\n".getBytes());
                        this.out.writeInt(result.length);
                        this.out.write(result);
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("updateConfig()")) {
                        byte[] cfg = new byte[this.in.readInt()];
                        this.in.readFully(cfg);
                        ConfigurationAccess.getLocal().updateConfig(cfg);
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("updateConfigMergeDefaults()")) {
                        byte[] cfg = new byte[this.in.readInt()];
                        this.in.readFully(cfg);
                        ConfigurationAccess.getLocal().updateConfigMergeDefaults(cfg);
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("getAdditionalHosts()")) {
                        int limit = this.in.readInt();
                        byte[] result = ConfigurationAccess.getLocal().getAdditionalHosts(limit);
                        this.out.write("OK\n".getBytes());
                        this.out.writeInt(result.length);
                        this.out.write(result);
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("updateAdditionalHosts()")) {
                        byte[] cfg = new byte[this.in.readInt()];
                        this.in.readFully(cfg);
                        ConfigurationAccess.getLocal().updateAdditionalHosts(cfg);
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("updateFilter()")) {
                        String entries = Utils.readLineFromStream(this.in).replace(";", "\n");
                        boolean filter = Boolean.parseBoolean(Utils.readLineFromStream(this.in));
                        ConfigurationAccess.getLocal().updateFilter(entries, filter);
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("restart()")) {
                        ConfigurationAccess.getLocal().restart();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("stop()")) {
                        ConfigurationAccess.getLocal().stop();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("getFilterStatistics()")) {
                        long[] result = ConfigurationAccess.getLocal().getFilterStatistics();
                        this.out.write("OK\n".getBytes());
                        this.out.writeLong(result[0]);
                        this.out.writeLong(result[1]);
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("triggerUpdateFilter()")) {
                        ConfigurationAccess.getLocal().triggerUpdateFilter();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("doBackup()")) {
                        ByteArrayOutputStream backupout = new ByteArrayOutputStream();
                        ConfigurationAccess.getLocal().doBackup(backupout);
                        this.out.write("OK\n".getBytes());
                        byte[] backup = backupout.toByteArray();
                        this.out.writeInt(backup.length);
                        this.out.write(backup);
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("doRestore()")) {
                        byte[] input = new byte[this.in.readInt()];
                        this.in.readFully(input);
                        ConfigurationAccess.getLocal().doRestore(new ByteArrayInputStream(input));
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("doRestoreDefaults()")) {
                        ConfigurationAccess.getLocal().doRestoreDefaults();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("wakeLock()")) {
                        ConfigurationAccess.getLocal().wakeLock();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    if (action.equals("releaseWakeLock()")) {
                        ConfigurationAccess.getLocal().releaseWakeLock();
                        this.out.write("OK\n".getBytes());
                        this.out.flush();
                        break block19;
                    }
                    throw new ConfigurationAccess.ConfigurationAccessException("Unknown action: " + action);
                }
                catch (ConfigurationAccess.ConfigurationAccessException e) {
                    this.out.write((String.valueOf(e.getMessage().replace("\n", "\t")) + "\n").getBytes());
                    this.out.flush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attachStream() throws IOException {
            try {
                this.connectedSessionId = Integer.parseInt(Utils.readLineFromStream(this.in));
                this.remoteStreamSession = true;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.remoteLogger = new SuppressRepeatingsLogger(new AsyncLogger(new LoggerInterface(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void sendLog(int type, String txt) {
                    DataOutputStream dataOutputStream = RemoteSession.this.out;
                    synchronized (dataOutputStream) {
                        try {
                            RemoteSession.this.out.writeShort(5);
                            byte[] msg = String.valueOf(ConfigurationAccess.getLocal().openConnectionsCount()).getBytes();
                            RemoteSession.this.out.writeShort(msg.length);
                            RemoteSession.this.out.write(msg);
                            RemoteSession.this.out.writeShort(4);
                            msg = ConfigurationAccess.getLocal().getLastDNSAddress().getBytes();
                            RemoteSession.this.out.writeShort(msg.length);
                            RemoteSession.this.out.write(msg);
                            msg = txt.getBytes();
                            RemoteSession.this.out.writeShort(type);
                            RemoteSession.this.out.writeShort(msg.length);
                            RemoteSession.this.out.write(msg);
                            RemoteSession.this.out.flush();
                        }
                        catch (IOException e) {
                            RemoteSession.this.killSession();
                            Logger.getLogger().logLine("Exception during remote logging! " + e.toString());
                        }
                    }
                }

                @Override
                public void logLine(String txt) {
                    this.sendLog(2, txt);
                }

                @Override
                public void logException(Exception e) {
                    StringWriter str = new StringWriter();
                    e.printStackTrace(new PrintWriter(str));
                    this.log(String.valueOf(str.toString()) + "\n");
                }

                @Override
                public void log(String txt) {
                    this.sendLog(1, txt);
                }

                @Override
                public void message(String txt) {
                    this.sendLog(3, txt);
                }

                @Override
                public void closeLogger() {
                }
            }));
            try {
                long repeatingLogSuppressTime = Long.parseLong(DNSFilterManager.getInstance().getConfig().getProperty("repeatingLogSuppressTime", "1000"));
                this.remoteLogger.setSuppressTime(repeatingLogSuppressTime);
                boolean liveLogTimestampEnabled = Boolean.parseBoolean(DNSFilterManager.getInstance().getConfig().getProperty("addLiveLogTimestamp", "false"));
                this.remoteLogger.setTimestampFormat(null);
                if (liveLogTimestampEnabled) {
                    String timeStampPattern = DNSFilterManager.getInstance().getConfig().getProperty("liveLogTimeStampFormat", "hh:mm:ss");
                    this.remoteLogger.setTimestampFormat(timeStampPattern);
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            DataOutputStream dataOutputStream = this.out;
            synchronized (dataOutputStream) {
                try {
                    ((GroupedLogger)Logger.getLogger()).attachLogger(this.remoteLogger);
                }
                catch (ClassCastException cce) {
                    GroupedLogger logger = new GroupedLogger(new LoggerInterface[]{Logger.getLogger(), this.remoteLogger});
                    Logger.setLogger(logger);
                }
                this.out.write("OK\n".getBytes());
                this.doHeartBeat(RemoteAccessClient.READ_TIMEOUT);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doHeartBeat(int timeout) {
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeShort(6);
                    this.out.writeShort(0);
                    this.out.flush();
                }
                this.timeout = System.currentTimeMillis() + (long)timeout;
                TimoutNotificator.getInstance().register(this);
            }
            catch (IOException e) {
                Logger.getLogger().logLine("Heartbeat failed! " + e);
                this.killSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invalidate() {
            if (!this.remoteStreamSession) {
                return;
            }
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeShort(7);
                    this.out.writeShort(0);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                Logger.getLogger().logLine("Invalidation failed! " + e);
            }
        }

        private void heartBeatConfirmed() {
            this.lastHeartBeatConfirm = System.currentTimeMillis();
        }

        private boolean checkLastConfirmedHeartBeat() {
            long delta = System.currentTimeMillis() - this.lastHeartBeatConfirm;
            if (delta > (long)(2 * RemoteAccessClient.READ_TIMEOUT)) {
                Logger.getLogger().logLine("Heartbeat Confirmation not received - Dead Session!");
                this.killSession();
                return false;
            }
            return true;
        }

        @Override
        public void timeoutNotification() {
            if (this.checkLastConfirmedHeartBeat()) {
                this.doHeartBeat(RemoteAccessClient.READ_TIMEOUT);
            }
        }

        @Override
        public long getTimoutTime() {
            return this.timeout;
        }
    }
}

