/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSServer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import util.conpool.Connection;

class TCP
extends DNSServer {
    boolean ssl;

    protected TCP(InetAddress address, int port, int timeout, boolean ssl, String hostName) throws IOException {
        super(address, port, timeout);
        this.ssl = ssl;
        if (hostName != null) {
            if (hostName.indexOf("://") != -1) {
                throw new IOException("Invalid hostname specified for " + this.getProtocolName() + ": " + hostName);
            }
            this.address = new InetSocketAddress(InetAddress.getByAddress(hostName, address.getAddress()), port);
        }
    }

    @Override
    public String getProtocolName() {
        if (this.ssl) {
            return "DOT";
        }
        return "TCP";
    }

    @Override
    public void resolve(DatagramPacket request, DatagramPacket response) throws IOException {
        Connection con = Connection.connect(this.address, this.timeout, this.ssl, null, proxy, false);
        int i = 0;
        while (i < 2) {
            con.setSoTimeout(this.timeout);
            try {
                DataInputStream in = new DataInputStream(con.getInputStream());
                DataOutputStream out = new DataOutputStream(con.getOutputStream());
                out.writeShort(request.getLength());
                out.write(request.getData(), request.getOffset(), request.getLength());
                out.flush();
                short size = in.readShort();
                this.readResponseFromStream(in, size, response);
                response.setSocketAddress(this.address);
                con.release(true);
                return;
            }
            catch (EOFException eof) {
                if (i == 0) {
                    con.refreshConnection();
                }
                con.release(false);
                throw new IOException("EOF when reading from " + this.toString(), eof);
            }
            catch (IOException eio) {
                con.release(false);
                throw eio;
            }
            ++i;
        }
    }
}

