/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import util.ExecutionEnvironment;
import util.HugePackedSet;
import util.LRUCache;
import util.Logger;
import util.ObjectPackagingManager;
import util.PatternSequence;
import util.Utils;

public class BlockedHosts
implements Set {
    private static ObjectPackagingManager PACK_MGR = new MyPackagingManager();
    private static Object NOT_NULL = new Object();
    private LRUCache okCache;
    private LRUCache filterListCache;
    private int sharedLocks = 0;
    private boolean exclusiveLock = false;
    private Hashtable<String, Boolean> hostsFilterOverRule = new Hashtable();
    private HugePackedSet blockedHostsHashes;
    private PatternSequence overrulePatterns = new PatternSequence();

    public BlockedHosts(int maxCountEstimate, int okCacheSize, int filterListCacheSize) {
        int slots;
        this.okCache = new LRUCache(okCacheSize);
        this.filterListCache = new LRUCache(filterListCacheSize);
        if (ExecutionEnvironment.getEnvironment().debug()) {
            Logger.getLogger().logLine("CACHE SIZE:" + okCacheSize + ", " + filterListCacheSize);
        }
        if ((slots = maxCountEstimate / 6000) % 2 == 0) {
            ++slots;
        }
        this.blockedHostsHashes = new HugePackedSet(slots, PACK_MGR);
    }

    private BlockedHosts(HugePackedSet blockedHostsHashes, int okCacheSize, int filterListCacheSize) {
        this.blockedHostsHashes = blockedHostsHashes;
        this.okCache = new LRUCache(okCacheSize);
        this.filterListCache = new LRUCache(filterListCacheSize);
        if (ExecutionEnvironment.getEnvironment().debug()) {
            Logger.getLogger().logLine("CACHE SIZE:" + okCacheSize + ", " + filterListCacheSize);
        }
    }

    public void addOverrule(String host, boolean filter) {
        if ((host = host.toLowerCase()).indexOf("*") != -1) {
            this.overrulePatterns.addPattern(host, filter);
            this.clearCache(!filter);
        } else {
            this.hostsFilterOverRule.put(host, new Boolean(filter));
            this.clearCache(host, !filter);
        }
    }

    public void removeOverrule(String host, boolean filter) {
        if ((host = host.toLowerCase()).indexOf("*") != -1) {
            this.overrulePatterns.removePattern(host, filter);
            this.clearCache(filter);
        } else {
            Boolean val = this.hostsFilterOverRule.get(host);
            if (val != null && val == filter) {
                this.hostsFilterOverRule.remove(host);
                this.clearCache(host, filter);
            }
        }
    }

    private void clearCache(String host, boolean filter) {
        long hostHash = Utils.getLongStringHash(host);
        if (filter) {
            this.filterListCache.remove(hostHash);
        } else {
            this.okCache.remove(hostHash);
        }
    }

    private void clearCache(boolean filter) {
        if (filter) {
            this.filterListCache.clear();
        } else {
            this.okCache.clear();
        }
    }

    public synchronized void lock(int type) {
        if (type == 0) {
            while (this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.sharedLocks;
        } else if (type == 1) {
            while (this.sharedLocks != 0 || this.exclusiveLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.exclusiveLock = true;
        }
    }

    public synchronized void unLock(int type) {
        if (type == 0) {
            if (this.sharedLocks > 0) {
                --this.sharedLocks;
                if (this.sharedLocks == 0) {
                    this.notifyAll();
                }
            }
        } else if (type == 1 && this.exclusiveLock) {
            this.exclusiveLock = false;
            this.notifyAll();
        }
    }

    public static boolean checkIndexVersion(String path) throws IOException {
        return HugePackedSet.checkIndexVersion(path);
    }

    public static BlockedHosts loadPersistedIndex(String path, boolean inMemory, int okCacheSize, int filterListCacheSize) throws IOException {
        return new BlockedHosts(HugePackedSet.load(path, inMemory, PACK_MGR), okCacheSize, filterListCacheSize);
    }

    public void persist(String path) throws IOException {
        try {
            this.lock(1);
            this.blockedHostsHashes.persist(path);
        }
        finally {
            this.unLock(1);
        }
    }

    public void updatePersist() throws IOException {
        try {
            this.lock(1);
            this.blockedHostsHashes.updatePersist();
        }
        finally {
            this.unLock(1);
        }
    }

    public void prepareInsert(String host) {
        if (host.indexOf("*") == -1) {
            this.blockedHostsHashes.prepareInsert(Utils.getLongStringHash(host.toLowerCase()));
        }
    }

    public void finalPrepare() {
        this.blockedHostsHashes.finalPrepare();
    }

    public void finalPrepare(int maxCountEstimate) {
        this.blockedHostsHashes.finalPrepare(maxCountEstimate);
    }

    public boolean update(Object host) throws IOException {
        try {
            this.lock(1);
            if (((String)host).indexOf("*") != -1) {
                throw new IOException("Wildcard not supported for update:" + host);
            }
            long hostHash = Utils.getLongStringHash(((String)host).toLowerCase());
            this.okCache.remove(hostHash);
            this.filterListCache.remove(hostHash);
            boolean bl = this.blockedHostsHashes.add((Object)hostHash);
            return bl;
        }
        finally {
            this.unLock(1);
        }
    }

    @Override
    public boolean add(Object host) {
        return this.blockedHostsHashes.add((Object)Utils.getLongStringHash(((String)host).toLowerCase()));
    }

    @Override
    public boolean contains(Object object) {
        try {
            long hosthash;
            this.lock(0);
            boolean ip = false;
            String hostName = ((String)object).toLowerCase();
            if (hostName.startsWith("%ip%")) {
                ip = true;
                hostName = hostName.substring(4);
            }
            if (this.okCache.get(hosthash = Utils.getLongStringHash(hostName)) != null) {
                return false;
            }
            if (this.filterListCache.get(hosthash) != null) {
                return true;
            }
            if (this.contains(hostName, hosthash, !ip, !ip)) {
                this.filterListCache.put((Object)hosthash, NOT_NULL);
                return true;
            }
            this.okCache.put((Object)hosthash, NOT_NULL);
            return false;
        }
        finally {
            this.unLock(0);
        }
    }

    private boolean contains(String hostName, long hosthash, boolean checkParent, boolean checkPattern) {
        int idx = 0;
        while (idx != -1) {
            Boolean patternMatch;
            Boolean filter = this.hostsFilterOverRule.get(hostName);
            if (filter != null) {
                return filter;
            }
            if (checkPattern && (patternMatch = (Boolean)this.overrulePatterns.match(hostName)) != null) {
                return patternMatch;
            }
            if (this.blockedHostsHashes.contains(hosthash)) {
                return true;
            }
            if (checkParent) {
                idx = hostName.indexOf(46);
                if (idx == -1) continue;
                hostName = hostName.substring(idx + 1);
                hosthash = Utils.getLongStringHash(hostName);
                continue;
            }
            idx = -1;
        }
        return false;
    }

    @Override
    public void clear() {
        this.blockedHostsHashes.clear();
        this.filterListCache.clear();
        this.okCache.clear();
        this.hostsFilterOverRule = null;
        this.overrulePatterns = null;
    }

    protected void migrateTo(BlockedHosts hostFilter) {
        this.okCache.clear();
        this.okCache = hostFilter.okCache;
        this.filterListCache.clear();
        this.filterListCache = hostFilter.filterListCache;
        this.hostsFilterOverRule = hostFilter.hostsFilterOverRule;
        this.overrulePatterns = hostFilter.overrulePatterns;
        this.blockedHostsHashes = hostFilter.blockedHostsHashes;
    }

    @Override
    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean isEmpty() {
        return this.blockedHostsHashes.isEmpty();
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public int size() {
        return this.blockedHostsHashes.size();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Object[] toArray(Object[] array) {
        throw new UnsupportedOperationException("Not supported!");
    }

    private static class MyPackagingManager
    implements ObjectPackagingManager {
        private MyPackagingManager() {
        }

        @Override
        public int objectSize() {
            return 8;
        }

        @Override
        public Object bytesToObject(byte[] data, int offs) {
            return Utils.byteArrayToLong(data, offs);
        }

        @Override
        public void objectToBytes(Object object, byte[] data, int offs) {
            Utils.writeLongToByteArray((Long)object, data, offs);
        }
    }
}

