/*
 * Decompiled with CFR 0.152.
 */
package util.conpool;

import java.io.IOException;
import java.io.InputStream;

public class PooledConnectionInputStream
extends InputStream {
    private InputStream in = null;
    private boolean valid = true;
    private long traffic = 0L;

    public PooledConnectionInputStream(InputStream in) {
        this.in = in;
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
        if (r != -1) {
            ++this.traffic;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offs, int len) throws IOException {
        int r = this.in.read(b, offs, len);
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
        this.traffic += (long)r;
        return r;
    }

    @Override
    public void close() throws IOException {
    }

    public long getTraffic() {
        return this.traffic;
    }
}

