/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSCommunicator;
import dnsfilter.DNSFilterManager;
import dnsfilter.DNSResolver;
import dnsfilter.DNSServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import util.ExecutionEnvironment;
import util.GroupedLogger;
import util.Logger;
import util.LoggerInterface;
import util.SuppressRepeatingsLogger;

public class DNSFilterProxy
implements Runnable {
    DatagramSocket receiver;
    boolean stopped = false;
    int port = 53;
    private static InetAddress openVPN4pDNSf_Adr;

    public DNSFilterProxy(int port) {
        try {
            openVPN4pDNSf_Adr = InetAddress.getByName("10.10.10.10");
        }
        catch (UnknownHostException e) {
            Logger.getLogger().logException(e);
        }
        this.port = port;
    }

    private static void initDNS(DNSFilterManager dnsFilterMgr) {
        try {
            boolean detect = Boolean.parseBoolean(dnsFilterMgr.getConfig().getProperty("detectDNS", "true"));
            if (detect) {
                Logger.getLogger().logLine("DNS detection not supported for this device");
                Logger.getLogger().message("DNS detection not supported - Using fallback!");
            }
            int timeout = Integer.parseInt(dnsFilterMgr.getConfig().getProperty("dnsRequestTimeout", "15000"));
            String specList = dnsFilterMgr.getConfig().getProperty("fallbackDNS", "");
            DNSServer[] dnsServers = DNSServer.getInstance().createDNSServers(specList, timeout, false);
            DNSCommunicator.getInstance().setDNSServers(dnsServers);
        }
        catch (IOException e) {
            Logger.getLogger().logLine("!!!DNS server initialization failed!!!");
            Logger.getLogger().logLine(e.toString());
            Logger.getLogger().message(e.getMessage());
        }
        catch (Exception e) {
            Logger.getLogger().logException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        class StandaloneLogger
        implements LoggerInterface {
            StandaloneLogger() {
            }

            @Override
            public void logLine(String txt) {
                System.out.println(txt);
            }

            @Override
            public void logException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void log(String txt) {
                System.out.print(txt);
            }

            @Override
            public void message(String txt) {
                this.logLine(txt);
            }

            @Override
            public void closeLogger() {
            }
        }
        SuppressRepeatingsLogger myLogger = new SuppressRepeatingsLogger(new StandaloneLogger());
        Logger.setLogger(new GroupedLogger(new LoggerInterface[]{myLogger}));
        class StandaloneEnvironment
        extends ExecutionEnvironment {
            boolean debug = false;
            boolean debugInit = false;

            StandaloneEnvironment() {
            }

            @Override
            public boolean debug() {
                if (!this.debugInit) {
                    try {
                        this.debug = Boolean.parseBoolean(DNSFilterManager.getInstance().getConfig().getProperty("debug", "false"));
                    }
                    catch (IOException e) {
                        Logger.getLogger().logException(e);
                    }
                    this.debugInit = true;
                }
                return this.debug;
            }

            @Override
            public void onReload() {
                DNSFilterProxy.initDNS(DNSFilterManager.getInstance());
            }

            @Override
            public InputStream getAsset(String path) throws IOException {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
        }
        ExecutionEnvironment.setEnvironment(new StandaloneEnvironment());
        DNSFilterManager filtermgr = DNSFilterManager.getInstance();
        filtermgr.init();
        long repeatingLogSuppressTime = Long.parseLong(DNSFilterManager.getInstance().getConfig().getProperty("repeatingLogSuppressTime", "1000"));
        myLogger.setSuppressTime(repeatingLogSuppressTime);
        boolean liveLogTimestampEnabled = Boolean.parseBoolean(DNSFilterManager.getInstance().getConfig().getProperty("addLiveLogTimestamp", "false"));
        myLogger.setTimestampFormat(null);
        if (liveLogTimestampEnabled) {
            String timeStampPattern = DNSFilterManager.getInstance().getConfig().getProperty("liveLogTimeStampFormat", "hh:mm:ss");
            myLogger.setTimestampFormat(timeStampPattern);
        }
        DNSFilterProxy.initDNS(filtermgr);
        int port = Integer.parseInt(DNSFilterManager.getInstance().getConfig().getProperty("dnsProxyPortNonAndroid", "53"));
        DNSFilterProxy runner = new DNSFilterProxy(port);
        runner.run();
    }

    public static boolean isAlocalAddress(InetAddress addr) throws IOException {
        if (addr.equals(openVPN4pDNSf_Adr) || addr.isLoopbackAddress() || addr.isAnyLocalAddress()) {
            return true;
        }
        return NetworkInterface.getByInetAddress(addr) != null;
    }

    @Override
    public void run() {
        boolean androidRootMode;
        boolean onlyLocal;
        int max_resolvers;
        try {
            max_resolvers = Integer.parseInt(DNSFilterManager.getInstance().getConfig().getProperty("maxResolverCount", "100"));
            onlyLocal = Boolean.parseBoolean(DNSFilterManager.getInstance().getConfig().getProperty("dnsProxyOnlyLocalRequests", "true"));
            androidRootMode = Boolean.parseBoolean(DNSFilterManager.getInstance().getConfig().getProperty("rootModeOnAndroid", "false"));
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Exception:Cannot get configuration!");
            Logger.getLogger().logException(e);
            return;
        }
        try {
            this.receiver = onlyLocal && (ExecutionEnvironment.getEnvironment().getEnvironmentID() == 0 || androidRootMode) ? new DatagramSocket(this.port, InetAddress.getByName("127.0.0.1")) : new DatagramSocket(this.port);
            ExecutionEnvironment.getEnvironment().protectSocket(this.receiver, 1);
        }
        catch (IOException eio) {
            Logger.getLogger().logLine("Exception:Cannot open DNS port " + this.port + "!" + eio.getMessage());
            return;
        }
        Logger.getLogger().logLine("DNSFilterProxy running on port " + this.port + "!");
        while (!this.stopped) {
            try {
                byte[] data = new byte[DNSServer.getBufSize()];
                DatagramPacket request = new DatagramPacket(data, 0, DNSServer.getBufSize());
                this.receiver.receive(request);
                boolean permitted = true;
                if (onlyLocal && ExecutionEnvironment.getEnvironment().getEnvironmentID() == 1 && !androidRootMode) {
                    permitted = DNSFilterProxy.isAlocalAddress(request.getAddress());
                }
                if (!permitted) {
                    Logger.getLogger().logLine(request.getAddress() + " not permitted! Only local access!");
                }
                if (DNSResolver.getResolverCount() > max_resolvers) {
                    Logger.getLogger().message("Max resolver count reached: " + max_resolvers);
                    continue;
                }
                if (!permitted) continue;
                new Thread(new DNSResolver(request, this.receiver)).start();
            }
            catch (IOException e) {
                if (this.stopped) continue;
                Logger.getLogger().logLine("Exception:" + e.getMessage());
            }
        }
        Logger.getLogger().logLine("DNSFilterProxy stopped!");
    }

    public synchronized void stop() {
        this.stopped = true;
        if (this.receiver == null) {
            return;
        }
        this.receiver.close();
    }
}

