/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.ConfigurationAccess;
import dnsfilter.DNSServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.Date;
import util.ExecutionEnvironment;
import util.Logger;
import util.Utils;

public class DNSCommunicator {
    private static DNSCommunicator INSTANCE = new DNSCommunicator();
    private static int TIMEOUT = 12000;
    DNSServer[] dnsServers = new DNSServer[0];
    DNSServer[] currentCheckingDNServers;
    int curDNS = -1;
    String lastDNS = "";
    Boolean dumpDNSPerf = null;

    public static DNSCommunicator getInstance() {
        return INSTANCE;
    }

    public synchronized void setDNSServers(DNSServer[] newDNSServers) throws IOException {
        if (newDNSServers.length > 20) {
            throw new IOException("Too many DNS servers configured - Add max 20!");
        }
        this.dnsServers = newDNSServers;
        if (this.dnsServers.length > 0) {
            this.curDNS = 0;
            this.lastDNS = this.dnsServers[this.curDNS].toString();
            this.setFastestDNSFromServers(true);
        } else {
            this.lastDNS = "";
            this.curDNS = -1;
        }
        if (ExecutionEnvironment.getEnvironment().debug()) {
            Logger.getLogger().logLine("Using updated DNS servers!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFastestDNSFromServers(final boolean acceptCurrent) {
        DNSServer[] dnsServersCopy;
        final int[] curDNSCopy = new int[1];
        final FileOutputStream[] dnsPerfOut = new FileOutputStream[1];
        final File dnsPerfFile = new File(String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + "/dnsperf.info");
        DNSCommunicator dNSCommunicator = INSTANCE;
        synchronized (dNSCommunicator) {
            block9: {
                if (this.dnsServers.length == 1) {
                    this.curDNS = 0;
                    return;
                }
                try {
                    if (this.currentCheckingDNServers != null && Utils.arrayEqual(this.currentCheckingDNServers, this.dnsServers)) {
                        return;
                    }
                    if (!dnsPerfFile.exists() || dnsPerfFile.delete()) {
                        dnsPerfOut[0] = new FileOutputStream(dnsPerfFile);
                        dnsPerfOut[0].write(("#DNS Response Times\r\n#Started: " + new Date() + "\r\n\r\n").getBytes());
                        break block9;
                    }
                    throw new IOException("Current file cannot be overwritten!");
                }
                catch (IOException eio) {
                    Logger.getLogger().logLine("Can't create dnsperf.info file!\n" + eio);
                }
            }
            curDNSCopy[0] = this.curDNS;
            dnsServersCopy = new DNSServer[this.dnsServers.length];
            int i = 0;
            while (i < this.dnsServers.length) {
                dnsServersCopy[i] = this.dnsServers[i];
                ++i;
            }
            this.currentCheckingDNServers = dnsServersCopy;
        }
        new Thread(new Runnable(){
            boolean fastestFound = false;
            boolean allReady = false;
            boolean go = false;
            Object monitor = new Object();
            int cnt = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void terminated(boolean first) {
                Object object = this.monitor;
                synchronized (object) {
                    ++this.cnt;
                    if (this.cnt == dnsServersCopy.length) {
                        this.allReady = true;
                    }
                    if (first || this.allReady) {
                        this.fastestFound = true;
                        this.monitor.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                i = 0;
                while (i < dnsServersCopy.length) {
                    finalI = i++;
                    new Thread(new Runnable(dnsServersCopy, finalI){
                        DNSServer dnsServer;
                        int dnsIdx;
                        {
                            this.dnsServer = dNSServerArray[n];
                            this.dnsIdx = n;
                        }

                        public void writeDNSPerfInfo(String txt) {
                            try {
                                if (dnsPerfOut[0] != null) {
                                    dnsPerfOut[0].write(txt.getBytes());
                                }
                            }
                            catch (IOException eio) {
                                Logger.getLogger().logLine("Can't write dnsperf.info file!\n" + eio);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            Object object = monitor;
                            synchronized (object) {
                                while (!go) {
                                    try {
                                        monitor.wait();
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            try {
                                long result = this.dnsServer.testDNS(5);
                                Object object2 = monitor;
                                synchronized (object2) {
                                    this.writeDNSPerfInfo(this.dnsServer + ": " + result + "ms\r\n");
                                    if (!fastestFound) {
                                        if (acceptCurrent || this.dnsIdx != curDNSCopy[0]) {
                                            curDNSCopy[0] = this.dnsIdx;
                                            this.terminated(true);
                                        } else {
                                            Logger.getLogger().logLine(this.dnsServer + " already set! Preferring different one!");
                                            this.terminated(false);
                                        }
                                    } else {
                                        this.terminated(false);
                                    }
                                    return;
                                }
                            }
                            catch (IOException eio) {
                                this.writeDNSPerfInfo(this.dnsServer + "; " + eio.toString() + "\r\n");
                                this.terminated(false);
                            }
                        }
                    }).start();
                }
                var1_2 = this.monitor;
                synchronized (var1_2) {
                    this.go = true;
                    this.monitor.notifyAll();
                    while (!this.fastestFound) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    e = DNSCommunicator.access$0();
                    synchronized (e) {
                        if (Utils.arrayEqual(dnsServersCopy, DNSCommunicator.this.dnsServers)) {
                            DNSCommunicator.this.currentCheckingDNServers = null;
                            DNSCommunicator.this.curDNS = curDNSCopy[0];
                            if (DNSCommunicator.this.curDNS != -1) {
                                Logger.getLogger().logLine("Selected DNS: (" + dnsServersCopy[DNSCommunicator.this.curDNS].lastPerformance + "ms) " + dnsServersCopy[DNSCommunicator.this.curDNS]);
                                DNSCommunicator.this.lastDNS = DNSCommunicator.this.dnsServers[DNSCommunicator.this.curDNS].toString();
                            }
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 6, 7] lbl27 : MonitorExitStatement: MONITOREXIT : e
                        if (true) ** GOTO lbl37
                    }
                    do {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
lbl37:
                        // 3 sources

                    } while (!this.allReady);
                    if (dnsPerfOut[0] != null) {
                        try {
                            dnsPerfOut[0].write(("\r\n#Terminated: " + new Date() + "\r\n\r\n").getBytes());
                            dnsPerfOut[0].flush();
                            dnsPerfOut[0].close();
                            if (DNSCommunicator.this.dumpDNSPerf == null) {
                                try {
                                    DNSCommunicator.this.dumpDNSPerf = Boolean.parseBoolean(ConfigurationAccess.getLocal().getConfig().getProperty("dumpDNSPerfInfo", "false"));
                                }
                                catch (Exception eio) {
                                    Logger.getLogger().logException(eio);
                                }
                            }
                            if (DNSCommunicator.this.dumpDNSPerf.booleanValue()) {
                                in = new FileInputStream(dnsPerfFile);
                                Logger.getLogger().logLine(new String(Utils.readFully(in, 1024)));
                                in.close();
                            }
                        }
                        catch (IOException eio) {
                            Logger.getLogger().logLine("Can't close dnsperf.info file!\n" + eio);
                        }
                    }
                }
            }
        }).start();
    }

    private synchronized void switchDNSServer(DNSServer current) throws IOException {
        if (current == this.getCurrentDNS()) {
            this.setFastestDNSFromServers(false);
            if (ExecutionEnvironment.getEnvironment().debug()) {
                Logger.getLogger().logLine("Switched DNS server to:" + this.getCurrentDNS().getAddress().getHostAddress());
            }
        }
    }

    public synchronized DNSServer getCurrentDNS() throws IOException {
        if (this.dnsServers.length == 0) {
            throw new IOException("No DNS server initialized!");
        }
        this.lastDNS = this.dnsServers[this.curDNS].toString();
        return this.dnsServers[this.curDNS];
    }

    public String getLastDNSAddress() {
        return this.lastDNS;
    }

    public void requestDNS(DatagramPacket request, DatagramPacket response) throws IOException {
        DNSServer dns = this.getCurrentDNS();
        try {
            dns.resolve(request, response);
        }
        catch (IOException eio) {
            if (ExecutionEnvironment.getEnvironment().hasNetwork()) {
                this.switchDNSServer(dns);
            }
            throw eio;
        }
    }

    static /* synthetic */ DNSCommunicator access$0() {
        return INSTANCE;
    }
}

