/*
 * Decompiled with CFR 0.152.
 */
package util.conpool;

import java.io.IOException;
import java.io.OutputStream;

public class PooledConnectionOutputStream
extends OutputStream {
    private OutputStream out;
    private boolean valid = true;
    private long traffic = 0L;

    public PooledConnectionOutputStream(OutputStream out) {
        this.out = out;
    }

    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.traffic;
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.traffic += (long)b.length;
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
    }

    @Override
    public void write(byte[] b, int offs, int len) throws IOException {
        this.out.write(b, offs, len);
        this.traffic += (long)len;
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        if (!this.valid) {
            throw new IllegalStateException("Invalid:" + this);
        }
    }

    public long getTraffic() {
        return this.traffic;
    }
}

