/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import util.LoggerInterface;

public class SuppressRepeatingsLogger
implements LoggerInterface {
    LoggerInterface nestedLogger;
    private HashMap<String, Long> lastLogs = new HashMap();
    private long timeRepeat = 0L;
    private long lastCleanup = 0L;
    DateFormat dateFormatter = null;
    String lastTS = "";

    public SuppressRepeatingsLogger(LoggerInterface nestedLogger) {
        this.nestedLogger = nestedLogger;
    }

    private void addTimeStamp() {
        if (this.dateFormatter == null) {
            return;
        }
        String ts = this.dateFormatter.format(new Date());
        if (!ts.equals(this.lastTS)) {
            this.nestedLogger.logLine(this.dateFormatter.format(new Date()));
            this.lastTS = ts;
        }
    }

    public void setNestedLogger(LoggerInterface nestedLogger) {
        this.nestedLogger = nestedLogger;
    }

    public LoggerInterface getNestedLogger() {
        return this.nestedLogger;
    }

    public void setSuppressTime(long suppressTime) {
        this.timeRepeat = suppressTime;
    }

    public void setTimestampFormat(String timeStampPattern) {
        this.dateFormatter = timeStampPattern != null ? new SimpleDateFormat(timeStampPattern) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean repeatingLog(String logStr) {
        long lastLogged = 0L;
        HashMap<String, Long> hashMap = this.lastLogs;
        synchronized (hashMap) {
            long current = System.currentTimeMillis();
            Long entry = this.lastLogs.get(logStr);
            if (entry != null) {
                lastLogged = entry;
            }
            this.lastLogs.put(logStr, current);
            if (current - this.lastCleanup > this.timeRepeat) {
                Map.Entry[] entries = this.lastLogs.entrySet().toArray(new Map.Entry[this.lastLogs.size()]);
                int i = 0;
                while (i < entries.length) {
                    if (current - (Long)entries[i].getValue() > this.timeRepeat) {
                        this.lastLogs.remove(entries[i].getKey());
                    }
                    ++i;
                }
                this.lastCleanup = current;
            }
            return current - lastLogged <= this.timeRepeat;
        }
    }

    @Override
    public void logLine(String txt) {
        if (!this.repeatingLog(txt)) {
            this.addTimeStamp();
            this.nestedLogger.logLine(txt);
        }
    }

    @Override
    public void logException(Exception e) {
        this.addTimeStamp();
        this.nestedLogger.logException(e);
    }

    @Override
    public void log(String txt) {
        if (!this.repeatingLog(txt)) {
            this.nestedLogger.log(txt);
        }
    }

    @Override
    public void message(String txt) {
        this.nestedLogger.message(txt);
    }

    @Override
    public void closeLogger() {
        this.lastLogs.clear();
        this.nestedLogger.closeLogger();
    }
}

