/*
 * Decompiled with CFR 0.152.
 */
package ip;

import ip.CheckSum;
import ip.IPPacket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class UDPPacket
extends IPPacket {
    private IntBuffer udpHeader;

    public UDPPacket(byte[] packet, int offs, int len) {
        super(packet, offs, len);
        this.udpHeader = ByteBuffer.wrap(packet, offs + this.ipHdrlen, 8).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
    }

    public static UDPPacket createUDPPacket(byte[] packet, int offs, int len, int version) {
        packet[offs] = (byte)(version << 4 & 0xFF);
        UDPPacket udp = new UDPPacket(packet, offs, len);
        udp.initInitialIPHeader();
        return udp;
    }

    public void updateHeader(int sourcePort, int destPort) {
        int[] hdrPacket = new int[]{(sourcePort << 16) + destPort, this.len - this.ipHdrlen << 16};
        this.udpHeader.position(0);
        this.udpHeader.put(hdrPacket);
        hdrPacket[1] = hdrPacket[1] + this.calculateCheckSum(true);
        this.udpHeader.put(1, hdrPacket[1]);
    }

    @Override
    public int checkCheckSum() {
        return this.calculateCheckSum(false);
    }

    private int calculateCheckSum(boolean internal) {
        int checkSum = 0;
        if (this.version == 4) {
            int saved = this.ipHeader.get(2);
            this.ipHeader.put(2, 0x110000 + this.len - this.ipHdrlen);
            checkSum = CheckSum.chkSum(this.data, this.offset + 8, this.len - 8);
            this.ipHeader.put(2, saved);
        } else if (this.version == 6) {
            int[] saved = new int[]{this.ipHeader.get(0), this.ipHeader.get(1)};
            this.ipHeader.put(0, this.len - this.ipHdrlen);
            this.ipHeader.put(1, 17);
            checkSum = CheckSum.chkSum(this.data, this.offset, this.len);
            this.ipHeader.position(0);
            this.ipHeader.put(saved);
        } else {
            throw new IllegalStateException("Illegal version:" + this.version);
        }
        if (internal && checkSum == 0) {
            checkSum = 65535;
        }
        return checkSum;
    }

    public int getSourcePort() {
        return this.udpHeader.get(0) >>> 16;
    }

    public int getDestPort() {
        return this.udpHeader.get(0) & 0xFFFF;
    }

    @Override
    public int getLength() {
        return this.udpHeader.get(1) >>> 16;
    }

    public int getIPPacketLength() {
        return super.getLength();
    }

    @Override
    public int getHeaderLength() {
        return this.ipHdrlen + 8;
    }

    @Override
    public int getOffset() {
        return super.getOffset() + this.ipHdrlen;
    }

    public int getIPPacketOffset() {
        return super.getOffset();
    }
}

