/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSResponsePatcher;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class SimpleDNSMessage {
    byte[] data;
    int offs;
    int length;
    int rqFlgs;
    int resFlgs;
    String qHost;
    short qType;
    short qClass;

    public SimpleDNSMessage(byte[] data, int offs, int length) throws IOException {
        this.data = data;
        this.offs = offs;
        this.length = length;
        if (length < 12) {
            return;
        }
        this.rqFlgs = data[offs + 2] & 0xFF;
        this.resFlgs = data[offs + 3] & 0xFF;
        if (this.isStandardQuery()) {
            ByteBuffer buf = ByteBuffer.wrap(data, offs, length);
            buf.position(offs + 12);
            this.qHost = DNSResponsePatcher.readDomainName(buf, buf.arrayOffset());
            this.qType = buf.getShort();
            this.qClass = buf.getShort();
        }
    }

    public boolean isStandardQuery() {
        return this.length >= 12 && this.rqFlgs >> 3 == 0;
    }

    public Object[] getQueryData() {
        return new Object[]{this.qHost, this.qType, this.qClass};
    }

    public int produceResponse(byte[] response, int offset, byte[] ip, int ttl) {
        System.arraycopy(this.data, this.offs, response, offset, this.length);
        response[offset + 2] = (byte)(128 + (response[offset + 2] & 0x7F));
        response[offset + 3] = -128;
        ByteBuffer buf = ByteBuffer.wrap(response, offset, response.length - offset);
        buf.position(offset + 4);
        buf.putShort((short)1);
        buf.putShort((short)1);
        buf.putShort((short)0);
        buf.putShort((short)0);
        StringTokenizer chainElements = new StringTokenizer(this.qHost, ".");
        int count = chainElements.countTokens();
        int i = 0;
        while (i < count) {
            String element = chainElements.nextToken();
            buf.put((byte)(element.length() & 0xFF));
            buf.put(element.getBytes());
            ++i;
        }
        buf.put((byte)0);
        buf.putShort(this.qType);
        buf.putShort(this.qClass);
        short ptr = -16372;
        buf.putShort(ptr);
        buf.putShort(this.qType);
        buf.putShort(this.qClass);
        buf.putInt(ttl);
        buf.putShort((short)ip.length);
        buf.put(ip);
        return buf.position() - offset;
    }

    public int get_NonTyp_1_28_FilterResponse(byte[] response, int offset) {
        System.arraycopy(this.data, this.offs, response, offset, this.length);
        response[offset + 2] = (byte)(128 + (response[offset + 2] & 0x7F));
        response[offset + 3] = -123;
        ByteBuffer buf = ByteBuffer.wrap(response, offset, response.length - offset);
        buf.position(offset + 4);
        buf.putShort((short)1);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.putShort((short)0);
        StringTokenizer chainElements = new StringTokenizer(this.qHost, ".");
        int count = chainElements.countTokens();
        int i = 0;
        while (i < count) {
            String element = chainElements.nextToken();
            buf.put((byte)(element.length() & 0xFF));
            buf.put(element.getBytes());
            ++i;
        }
        buf.put((byte)0);
        buf.putShort(this.qType);
        buf.putShort(this.qClass);
        return buf.position() - offset;
    }
}

