/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.ConfigurationAccess;
import dnsfilter.DoH;
import dnsfilter.TCP;
import dnsfilter.UDP;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import java.util.Vector;
import util.ExecutionEnvironment;
import util.Logger;
import util.conpool.Connection;
import util.conpool.HttpProxy;

public class DNSServer {
    protected InetSocketAddress address;
    protected int timeout;
    protected long lastPerformance = -1L;
    protected static int bufSize = 1024;
    protected static int maxBufSize = -1;
    public static final int UDP = 0;
    public static final int TCP = 1;
    public static final int DOT = 2;
    public static final int DOH = 3;
    private static DNSServer INSTANCE = new DNSServer(null, 0, 0);
    protected static Proxy proxy = Proxy.NO_PROXY;

    static void init() {
        Connection.setPoolTimeoutSeconds(30);
        try {
            boolean useProxy = Boolean.parseBoolean(ConfigurationAccess.getLocal().getConfig().getProperty("resolveOverHttpProxy", "false"));
            if (useProxy) {
                String proxyIP = ConfigurationAccess.getLocal().getConfig().getProperty("httpProxyIP", "").trim();
                String proxyPort = ConfigurationAccess.getLocal().getConfig().getProperty("httpProxyPort", "").trim();
                if (!proxyIP.equals("") && !proxyPort.equals("")) {
                    InetAddress proxyAddr = InetAddress.getByName(proxyIP);
                    String proxyHost = ConfigurationAccess.getLocal().getConfig().getProperty("httpProxyHost", "").trim();
                    if (!proxyHost.equals("")) {
                        proxyAddr = InetAddress.getByAddress(proxyHost, proxyAddr.getAddress());
                    }
                    proxy = new HttpProxy(new InetSocketAddress(proxyAddr, Integer.parseInt(proxyPort)));
                    String proxyAuthStr = ConfigurationAccess.getLocal().getConfig().getProperty("httpProxyBasicAuthStr", "").trim();
                    if (!proxyAuthStr.equals("")) {
                        ((HttpProxy)proxy).setProxyAuth(proxyAuthStr);
                    }
                    Logger.getLogger().logLine("Using Proxy:" + proxy);
                } else {
                    Logger.getLogger().logLine("WARNING! Ignoring incomplete proxy configuration!");
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Exception during proxy creation!");
            Logger.getLogger().logException(e);
        }
        try {
            maxBufSize = Integer.parseInt(ConfigurationAccess.getLocal().getConfig().getProperty("MTU", "3000"));
        }
        catch (Exception e) {
            maxBufSize = 3000;
            Logger.getLogger().logLine("Exception during MTU config access - using default 3000!");
            Logger.getLogger().logException(e);
        }
    }

    public static void invalidateOpenConnections() {
        Connection.invalidate();
        dnsfilter.UDP.invalidateAllUDPSessions();
    }

    public static int getProtoFromString(String s) throws IOException {
        if ((s = s.toUpperCase()).equals("UDP")) {
            return 0;
        }
        if (s.equals("TCP")) {
            return 1;
        }
        if (s.equals("DOT")) {
            return 2;
        }
        if (s.equals("DOH")) {
            return 3;
        }
        throw new IOException("Invalid protocol: " + s);
    }

    public static String getStringFromProto(int proto) {
        if (proto == 0) {
            return "UDP";
        }
        if (proto == 1) {
            return "TCP";
        }
        if (proto == 2) {
            return "DOT";
        }
        if (proto == 3) {
            return "DOH";
        }
        return "Unknown";
    }

    protected DNSServer(InetAddress address, int port, int timeout) {
        this.address = new InetSocketAddress(address, port);
        this.timeout = timeout;
    }

    public static DNSServer getInstance() {
        return INSTANCE;
    }

    public static int getBufSize() {
        return bufSize;
    }

    public DNSServer createDNSServer(int protocol, InetAddress address, int port, int timeout, String endPoint) throws IOException {
        switch (protocol) {
            case 0: {
                return new UDP(address, port, timeout);
            }
            case 1: {
                return new TCP(address, port, timeout, false, endPoint);
            }
            case 2: {
                return new TCP(address, port, timeout, true, endPoint);
            }
            case 3: {
                return new DoH(address, port, timeout, endPoint);
            }
        }
        throw new IllegalArgumentException("Invalid protocol:" + protocol);
    }

    public DNSServer createDNSServer(String spec, int timeout) throws IOException {
        DNSServerConfig dnsServerConfig = new DNSServerConfig(spec);
        return dnsServerConfig.createDNSServer(timeout);
    }

    public boolean dnsServersEqual(String specList1, String specList2) {
        if (specList1 == null || specList2 == null) {
            return specList1 == specList2;
        }
        Vector<DNSServerConfig> spec1 = this.getDNSServerConfigsFromSpecList(specList1);
        Vector<DNSServerConfig> spec2 = this.getDNSServerConfigsFromSpecList(specList2);
        if (spec1 == null || spec2 == null) {
            return spec1 == spec2;
        }
        if (spec1.size() != spec2.size()) {
            return false;
        }
        int i = 0;
        while (i < spec1.size()) {
            if (!spec2.contains(spec1.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Vector<DNSServerConfig> getDNSServerConfigsFromSpecList(String specList) {
        StringTokenizer fallbackDNS = new StringTokenizer(specList, ";");
        int cnt = fallbackDNS.countTokens();
        Vector<DNSServerConfig> dnsServers = new Vector<DNSServerConfig>();
        int i = 0;
        while (i < cnt) {
            String dnsEntry = fallbackDNS.nextToken().trim();
            if (!dnsEntry.startsWith("#") && !dnsEntry.trim().equals("")) {
                try {
                    DNSServerConfig dnsServerCfg = new DNSServerConfig(dnsEntry);
                    dnsServers.add(dnsServerCfg);
                }
                catch (Exception e) {
                    Logger.getLogger().logLine("Error parsing DNS Server from " + dnsEntry + ": " + e.toString());
                    Logger.getLogger().message("Error parsing DNS Server from " + dnsEntry);
                }
            }
            ++i;
        }
        return dnsServers;
    }

    public DNSServer[] createDNSServers(String specList, int timeout, boolean rootMode) throws IOException {
        Vector<DNSServerConfig> dnsServerCfgs = this.getDNSServerConfigsFromSpecList(specList);
        int cnt = dnsServerCfgs.size();
        Vector<DNSServer> dnsServers = new Vector<DNSServer>();
        int i = 0;
        while (i < cnt) {
            DNSServerConfig dnsServerCfg = dnsServerCfgs.elementAt(i);
            if (dnsServerCfg.active) {
                if (rootMode && dnsServerCfg.port == 53) {
                    Logger.getLogger().logLine("invalid DNS entry " + dnsServerCfg + "! port 53 not allowed when running in root mode! Use DoT or DoH!");
                    Logger.getLogger().message("Skipping invalid DNS entry " + dnsServerCfg + "!");
                } else if (dnsServerCfg.active) {
                    dnsServers.add(dnsServerCfg.createDNSServer(timeout));
                    if (ExecutionEnvironment.getEnvironment().debug()) {
                        Logger.getLogger().logLine("Added DNS Server " + dnsServerCfg + "!");
                    }
                }
            }
            ++i;
        }
        return dnsServers.toArray(new DNSServer[dnsServers.size()]);
    }

    public InetAddress getAddress() {
        return this.address.getAddress();
    }

    public int getPort() {
        return this.address.getPort();
    }

    public String getProtocolName() {
        return "";
    }

    public String toString() {
        return "[" + this.address.getAddress().getHostAddress() + "]::" + this.address.getPort() + "::" + this.getProtocolName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.address.equals(((DNSServer)obj).address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void readResponseFromStream(DataInputStream in, int size, DatagramPacket response) throws IOException {
        if (size + response.getOffset() > response.getData().length) {
            Class<DNSServer> clazz = DNSServer.class;
            // MONITORENTER : dnsfilter.DNSServer.class
            if (size + response.getOffset() < maxBufSize && bufSize < size + response.getOffset()) {
                bufSize = Math.min(1024 * ((size + response.getOffset()) / 1024 + 1), maxBufSize);
                Logger.getLogger().logLine("BUFFER RESIZE:" + bufSize);
            } else if (size + response.getOffset() >= maxBufSize) {
                throw new IOException("Max response buffer to small for response of length " + size);
            }
            response.setData(new byte[bufSize], response.getOffset(), bufSize - response.getOffset());
            // MONITOREXIT : clazz
        }
        try {
            in.readFully(response.getData(), response.getOffset(), size);
        }
        catch (IOException eio) {
            throw new IOException("Read failed: " + response.getData().length + ", " + response.getOffset() + ", " + size, eio);
        }
        response.setLength(size);
    }

    public void resolve(DatagramPacket request, DatagramPacket response) throws IOException {
    }

    public int getLastPerformance() {
        return (int)this.lastPerformance;
    }

    public long testDNS(int noOfTimes) throws IOException {
        long perf;
        DatagramPacket response = new DatagramPacket(new byte[bufSize], 0, bufSize);
        DatagramPacket[] requests = new DatagramPacket[noOfTimes];
        int i = 0;
        while (i < noOfTimes) {
            requests[i] = DNSServer.getRandomRequest();
            ++i;
        }
        long millis = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < noOfTimes) {
            this.resolve(requests[i2], response);
            ++i2;
        }
        this.lastPerformance = perf = (System.currentTimeMillis() - millis) / (long)noOfTimes;
        return perf;
    }

    private static DatagramPacket getRandomRequest() {
        int random = (int)Math.abs(Math.random() * 2.147483647E9);
        byte[] request = DNSServer.buildDNSRequest(new String[]{"www", "t" + random, "org"});
        return new DatagramPacket(request, request.length);
    }

    private static byte[] buildDNSRequest(String[] domainChain) {
        int bufLen = 17;
        int i = 0;
        while (i < domainChain.length) {
            bufLen = bufLen + domainChain[i].length() + 1;
            ++i;
        }
        byte[] buf = new byte[bufLen];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buf);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)256);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)0);
        int i2 = 0;
        while (i2 < domainChain.length) {
            byteBuffer.put((byte)(domainChain[i2].length() & 0xFF));
            byteBuffer.put(domainChain[i2].getBytes());
            ++i2;
        }
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)1);
        byteBuffer.putShort((short)1);
        return buf;
    }

    private class DNSServerConfig {
        int protocol;
        String ip = null;
        int port;
        String endPoint;
        boolean active;

        protected DNSServerConfig(String spec) throws IOException {
            if (spec.startsWith("~")) {
                this.active = false;
                spec = spec.substring(1);
            } else {
                this.active = true;
            }
            if (spec.startsWith("[")) {
                int idx = spec.indexOf("]");
                if (idx != -1) {
                    this.ip = spec.substring(1, idx);
                    spec = spec.substring(idx);
                }
            } else {
                String specUpper = spec.toUpperCase();
                if (specUpper.indexOf("::UDP") == -1 && specUpper.indexOf("::DOT") == -1 && specUpper.indexOf("::DOH") == -1) {
                    this.ip = spec;
                    spec = "";
                }
            }
            String[] entryTokens = spec.split("::");
            if (this.ip == null) {
                this.ip = entryTokens[0];
            }
            this.port = 53;
            if (entryTokens.length > 1) {
                try {
                    this.port = Integer.parseInt(entryTokens[1]);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Invalid port!", nfe);
                }
            }
            this.protocol = 0;
            if (entryTokens.length > 2) {
                this.protocol = DNSServer.getProtoFromString(entryTokens[2]);
            }
            this.endPoint = null;
            if (entryTokens.length > 3) {
                this.endPoint = entryTokens[3];
            }
            if (entryTokens.length > 4) {
                this.endPoint = String.valueOf(this.endPoint) + "::" + entryTokens[4];
            }
        }

        protected DNSServer createDNSServer(int timeout) throws IOException {
            return DNSServer.getInstance().createDNSServer(this.protocol, InetAddress.getByName(this.ip), this.port, timeout, this.endPoint);
        }

        public String toString() {
            String result = "[" + this.ip + "]::" + this.port + "::" + DNSServer.getStringFromProto(this.protocol);
            if (this.endPoint != null) {
                result = String.valueOf(result) + "::" + this.endPoint;
            }
            return result;
        }

        public boolean equals(Object cfg2) {
            if (cfg2 == null) {
                return false;
            }
            if (!this.getClass().equals(cfg2.getClass())) {
                return false;
            }
            DNSServerConfig cfg = (DNSServerConfig)cfg2;
            String endPoint1 = this.endPoint;
            String endPoint2 = cfg.endPoint;
            if (endPoint1 == null) {
                endPoint1 = "";
            }
            if (endPoint2 == null) {
                endPoint2 = "";
            }
            return this.protocol == cfg.protocol && this.ip.equals(cfg.ip) && this.port == cfg.port && endPoint1.equals(endPoint2) && this.active == cfg.active;
        }
    }
}

