/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import util.Logger;

public class ConfigUtil {
    private Properties config = new Properties();
    private byte[] configBytes;
    boolean changed = false;

    protected ConfigUtil(byte[] configBytes) throws IOException {
        this.configBytes = configBytes;
        this.config.load(new ByteArrayInputStream(configBytes));
    }

    public boolean isChanged() {
        return this.changed;
    }

    public byte[] getConfigBytes() throws IOException {
        if (this.changed) {
            this.updateConfigBytes();
        }
        return this.configBytes;
    }

    private void updateConfigBytes() throws IOException {
        String ln;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.configBytes)));
        while ((ln = reader.readLine()) != null) {
            String trimLN = ln.trim();
            if (!trimLN.equals("") && !trimLN.startsWith("#")) {
                int idx = trimLN.indexOf(" =");
                if (idx == -1) {
                    throw new IOException("broken config! " + trimLN);
                }
                String key = trimLN.substring(0, idx).trim();
                String value = this.config.getProperty(key);
                if (value == null) {
                    value = "";
                }
                ln = String.valueOf(key) + " = " + value;
            }
            out.write((String.valueOf(ln) + "\r\n").getBytes());
        }
        reader.close();
        out.flush();
        out.close();
        this.configBytes = out.toByteArray();
    }

    public void updateConfigValue(String key, String value) {
        String current = this.config.getProperty(key);
        this.config.setProperty(key, value);
        this.changed = this.changed || value != null && !value.equals(current) || value == null && current != null;
    }

    public Properties getProperties() {
        return this.config;
    }

    public String getConfigValue(String key, String defaultValue) {
        return this.config.getProperty(key, defaultValue);
    }

    public HostFilterList[] getConfiguredFilterLists() {
        return ConfigUtil.getConfiguredFilterLists(this.config);
    }

    public static Vector<HostFilterList> getConfiguredFilterListsAsVector(Properties config) {
        HostFilterList[] result = ConfigUtil.getConfiguredFilterLists(config);
        Vector<HostFilterList> resultVector = new Vector<HostFilterList>(result.length);
        int i = 0;
        while (i < result.length) {
            resultVector.addElement(result[i]);
            ++i;
        }
        return resultVector;
    }

    public static HostFilterList[] getConfiguredFilterLists(Properties config) {
        String urls = config.getProperty("filterAutoUpdateURL", "");
        String url_IDs = config.getProperty("filterAutoUpdateURL_IDs", "");
        String url_switchs = config.getProperty("filterAutoUpdateURL_switchs", "");
        String url_categories = config.getProperty("filterAutoUpdateURL_categories", "");
        StringTokenizer urlTokens = new StringTokenizer(urls, ";");
        StringTokenizer urlIDTokens = new StringTokenizer(url_IDs, ";");
        StringTokenizer urlSwitchTokens = new StringTokenizer(url_switchs, ";");
        StringTokenizer categoryTokens = new StringTokenizer(url_categories, ";");
        int count = urlTokens.countTokens();
        HostFilterList[] result = new HostFilterList[count];
        TreeMap<StringWrapper, HostFilterList> resultSorted = new TreeMap<StringWrapper, HostFilterList>();
        int i = 0;
        while (i < count) {
            String urlHost = null;
            String urlStr = urlTokens.nextToken().trim();
            String url_id = "";
            if (urlIDTokens.hasMoreTokens()) {
                url_id = urlIDTokens.nextToken().trim();
            } else {
                URL url = null;
                try {
                    url = new URL(urlStr);
                    url_id = urlHost = url.getHost();
                }
                catch (MalformedURLException e) {
                    Logger.getLogger().logException(e);
                    url_id = "-";
                }
            }
            String url_category = "";
            if (categoryTokens.hasMoreTokens()) {
                url_category = categoryTokens.nextToken().trim();
            } else if (urlHost != null) {
                url_category = urlHost;
            } else {
                URL url = null;
                try {
                    url = new URL(urlStr);
                    url_category = url.getHost();
                }
                catch (MalformedURLException e) {
                    Logger.getLogger().logException(e);
                    url_category = "-";
                }
            }
            boolean active = true;
            if (urlSwitchTokens.hasMoreTokens()) {
                active = Boolean.parseBoolean(urlSwitchTokens.nextToken().trim());
            }
            resultSorted.put(new StringWrapper(String.valueOf(url_id) + url_category + urlStr + active), new HostFilterList(active, url_category, url_id, urlStr));
            ++i;
        }
        return resultSorted.values().toArray(result);
    }

    private String[] getFilterCfgStrings(HostFilterList[] filterEntries) {
        String[] result = new String[]{"", "", "", ""};
        String dim = "";
        int i = 0;
        while (i < filterEntries.length) {
            result[0] = String.valueOf(result[0]) + dim + filterEntries[i].active;
            result[1] = String.valueOf(result[1]) + dim + filterEntries[i].id;
            result[2] = String.valueOf(result[2]) + dim + filterEntries[i].url;
            result[3] = String.valueOf(result[3]) + dim + filterEntries[i].category;
            dim = "; ";
            ++i;
        }
        return result;
    }

    public void setConfiguredFilterLists(HostFilterList[] filterLists) {
        String[] filterCfgStrings = this.getFilterCfgStrings(filterLists);
        this.updateConfigValue("filterAutoUpdateURL_switchs", filterCfgStrings[0]);
        this.updateConfigValue("filterAutoUpdateURL_IDs", filterCfgStrings[1]);
        this.updateConfigValue("filterAutoUpdateURL", filterCfgStrings[2]);
        this.updateConfigValue("filterAutoUpdateURL_categories", filterCfgStrings[3]);
    }

    public static class HostFilterList {
        public boolean active;
        public String category;
        public String id;
        public String url;

        public HostFilterList(boolean active, String category, String id, String url) {
            this.active = active;
            this.category = category;
            this.id = id;
            this.url = url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            HostFilterList hfl = (HostFilterList)obj;
            return this.active == hfl.active && this.category.equals(hfl.category) && this.id.equals(hfl.id) && this.url.equals(hfl.url);
        }
    }

    private static class StringWrapper
    implements Comparable {
        String wrapped;

        private StringWrapper(String s) {
            this.wrapped = s.toUpperCase(Locale.ROOT);
        }

        public int compareTo(Object o) {
            StringWrapper arg = (StringWrapper)o;
            if (arg.wrapped.equals(this.wrapped)) {
                return -1;
            }
            return this.wrapped.compareTo(arg.wrapped);
        }
    }
}

