/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Utils {
    public static int byteArrayToInt(byte[] b) {
        return b[3] & 0xFF | (b[2] & 0xFF) << 8 | (b[1] & 0xFF) << 16 | (b[0] & 0xFF) << 24;
    }

    public static byte[] intToByteArray(int a) {
        return new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
    }

    public static byte[] longToByteArray(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static void writeLongToByteArray(long value, byte[] b, int offs) {
        b[offs + 0] = (byte)(value >> 56);
        b[offs + 1] = (byte)(value >> 48);
        b[offs + 2] = (byte)(value >> 40);
        b[offs + 3] = (byte)(value >> 32);
        b[offs + 4] = (byte)(value >> 24);
        b[offs + 5] = (byte)(value >> 16);
        b[offs + 6] = (byte)(value >> 8);
        b[offs + 7] = (byte)value;
    }

    public static long byteArrayToLong(byte[] b, int offs) {
        return (long)(b[7 + offs] & 0xFF) | (long)(b[6 + offs] & 0xFF) << 8 | (long)(b[5 + offs] & 0xFF) << 16 | (long)(b[4 + offs] & 0xFF) << 24 | (long)(b[3 + offs] & 0xFF) << 32 | (long)(b[2 + offs] & 0xFF) << 40 | (long)(b[1 + offs] & 0xFF) << 48 | (long)(b[0 + offs] & 0xFF) << 56;
    }

    public static long getLongStringHash(String str) {
        int a = 0;
        int b = 0;
        int len = str.length();
        byte[] bytes = str.getBytes();
        int i = 0;
        while (i < len) {
            a = 31 * a + (bytes[i] & 0xFF);
            b = 31 * b + (bytes[len - i - 1] & 0xFF);
            ++i;
        }
        return (long)a << 32 | (long)b & 0xFFFFFFFFL;
    }

    public static boolean arrayEqual(Object[] a1, Object[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        int i = 0;
        while (i < a1.length) {
            if (!a1[i].equals(a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long millis) {
        Object obj;
        Object object = obj = new Object();
        synchronized (object) {
            try {
                obj.wait(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeSocket(Socket s) {
        try {
            s.shutdownOutput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            s.shutdownInput();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String readLineFromStream(InputStream in, boolean crlf) throws IOException {
        int i = 0;
        StringBuffer str = new StringBuffer();
        boolean exit = false;
        int r = -1;
        int last = 0;
        while (!exit) {
            r = in.read();
            byte b = (byte)r;
            boolean bl = exit = r == -1 || b == 10 && (!crlf || last == 13);
            if (exit) continue;
            str.append((char)b);
            ++i;
            last = b;
        }
        if (r == -1 && i == 0) {
            throw new EOFException("Stream is closed!");
        }
        if (i > 0 && last == 13) {
            --i;
        }
        return str.substring(0, i);
    }

    /*
     * Exception decompiling
     */
    public static int readLineBytesFromStream(InputStream in, byte[] buf, boolean printableOnly, boolean ignoreComment) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int skipLine(InputStream in) throws IOException {
        int r = 0;
        while (r != -1 && r != 10) {
            r = in.read();
        }
        return r;
    }

    public static int skipWhitespace(InputStream in, int r) throws IOException {
        while (r != -1 && r != 10 && (r == 9 || r == 32 || r == 13)) {
            r = in.read();
        }
        return r;
    }

    public static String readLineFromStreamRN(InputStream in) throws IOException {
        return Utils.readLineFromStream(in, true);
    }

    public static String readLineFromStream(InputStream in) throws IOException {
        return Utils.readLineFromStream(in, false);
    }

    public static byte[] readFully(InputStream in, int bufSize) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        int r = 0;
        byte[] buf = new byte[bufSize];
        while ((r = in.read(buf, 0, bufSize)) != -1) {
            bytesOut.write(buf, 0, r);
        }
        return bytesOut.toByteArray();
    }

    public static byte[] serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream objOut = new ByteArrayOutputStream();
        ObjectOutputStream dataOut = new ObjectOutputStream(objOut);
        dataOut.writeObject(obj);
        dataOut.flush();
        dataOut.close();
        return objOut.toByteArray();
    }

    public static Object deserializeObject(byte[] bytes) throws IOException {
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream objIn = new ObjectInputStream(bytesIn);
        try {
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static String getServerTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(calendar.getTime());
    }

    public static String[] parseURI(String uri) throws IOException {
        try {
            String url = uri;
            url = url.substring(7);
            int idx = url.indexOf(47);
            if (idx == -1) {
                idx = url.length();
            }
            String hostEntry = url.substring(0, idx);
            url = idx == url.length() ? "/" : url.substring(idx);
            return new String[]{hostEntry, url};
        }
        catch (Exception e) {
            throw new IOException("Cannot parse URI '" + uri + "'! - " + e.toString());
        }
    }

    public static void deleteFolder(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Utils.deleteFolder(files[i].getAbsolutePath());
                } else {
                    files[i].delete();
                }
                ++i;
            }
            dir.delete();
        }
    }

    public static void copyFully(InputStream in, OutputStream out, boolean close) throws IOException {
        byte[] buf = new byte[1024];
        int r = 0;
        while ((r = in.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
        out.flush();
        if (close) {
            out.close();
            in.close();
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        File dir = to.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(to));
        Utils.copyFully(in, out, true);
    }

    public static void moveFileTree(File sourceFile, File destFile) throws IOException {
        if (sourceFile.isDirectory()) {
            File[] files = sourceFile.listFiles();
            if (files == null) {
                throw new IOException("IOError occured while trying to move " + sourceFile);
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Utils.moveFileTree(file, new File(file.getPath().replace(sourceFile.getPath(), destFile.getPath())));
                sourceFile.delete();
                ++n2;
            }
        } else {
            Utils.copyFile(sourceFile, destFile);
            sourceFile.delete();
        }
    }

    public static void zipFile(ZipOutputStream zos, File fileToZip, String parrentDirectoryName) throws Exception {
        if (fileToZip == null || !fileToZip.exists()) {
            return;
        }
        String zipEntryName = fileToZip.getName();
        if (parrentDirectoryName != null && !parrentDirectoryName.isEmpty()) {
            zipEntryName = String.valueOf(parrentDirectoryName) + "/" + fileToZip.getName();
        }
        if (fileToZip.isDirectory()) {
            System.out.println("+" + zipEntryName);
            File[] fileArray = fileToZip.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                Utils.zipFile(zos, file, zipEntryName);
                ++n2;
            }
        } else {
            int length;
            System.out.println("   " + zipEntryName);
            byte[] buffer = new byte[1024];
            FileInputStream fis = new FileInputStream(fileToZip);
            zos.putNextEntry(new ZipEntry(zipEntryName));
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
            zos.closeEntry();
            fis.close();
        }
    }

    public static void unzipFile(ZipInputStream zis, String outputDir) throws IOException {
        byte[] buffer = new byte[1024];
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            File newFile = new File(String.valueOf(outputDir) + File.separator, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (!newFile.isDirectory() && !newFile.mkdirs()) {
                    throw new IOException("Failed to create directory " + newFile);
                }
            } else {
                File parent = newFile.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("Failed to create directory " + parent);
                }
                FileOutputStream fos = new FileOutputStream(newFile);
                int len = 0;
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            zipEntry = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }
}

