/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import util.LoggerInterface;
import util.Utils;

public class AsyncLogger
implements LoggerInterface,
Runnable {
    static final int LOG = 1;
    static final int LOG_LN = 2;
    static final int LOG_MSG = 3;
    static final int LOG_EXC = 4;
    private LoggerInterface out = null;
    private DataOutputStream pout;
    private PipedInputStream pin;
    private boolean closed = false;

    public AsyncLogger(LoggerInterface out) throws IOException {
        this.out = out;
        this.logOpen();
    }

    private void logOpen() throws IOException {
        this.pin = new PipedInputStream(10240);
        this.pout = new DataOutputStream(new PipedOutputStream(this.pin));
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLogger() {
        PipedInputStream pipedInputStream = this.pin;
        synchronized (pipedInputStream) {
            try {
                this.closed = true;
                this.pout.close();
                this.pin.notifyAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeLog(int type, byte[] bytes) {
        try {
            this.pout.writeShort(type);
            this.pout.writeInt(bytes.length);
            this.pout.write(bytes);
            this.pout.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logLine(String txt) {
        DataOutputStream dataOutputStream = this.pout;
        synchronized (dataOutputStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                this.writeLog(2, txt.getBytes());
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(Exception e) {
        byte[] bytes = null;
        try {
            bytes = Utils.serializeObject(e);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        DataOutputStream dataOutputStream = this.pout;
        synchronized (dataOutputStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                this.writeLog(4, bytes);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String txt) {
        DataOutputStream dataOutputStream = this.pout;
        synchronized (dataOutputStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                this.writeLog(1, txt.getBytes());
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(String txt) {
        DataOutputStream dataOutputStream = this.pout;
        synchronized (dataOutputStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                this.writeLog(3, txt.getBytes());
                this.pin.notifyAll();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

