/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import util.DateRetriever;
import util.LoggerInterface;

public class AsyncBulkLogger
implements LoggerInterface,
Runnable {
    private LoggerInterface out = null;
    private PipedOutputStream pout;
    private PrintStream psout;
    private PipedInputStream pin;
    private boolean closed = false;
    private boolean timeStampEnabled = false;

    public AsyncBulkLogger(LoggerInterface out) throws IOException {
        this.out = out;
        this.logOpen();
    }

    public void enableTimestamp(boolean enable) {
        this.timeStampEnabled = enable;
    }

    private void logOpen() throws IOException {
        this.pin = new PipedInputStream(10240);
        this.pout = new PipedOutputStream(this.pin);
        this.psout = new PrintStream(this.pout, true);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLogger() {
        PipedInputStream pipedInputStream = this.pin;
        synchronized (pipedInputStream) {
            try {
                this.closed = true;
                this.pout.close();
                this.pin.notifyAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logLine(String txt) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                this.psout.println(txt);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(Exception e) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                e.printStackTrace(this.psout);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String txt) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                this.psout.print(txt);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(String txt) {
        PipedInputStream pipedInputStream = this.pin;
        synchronized (pipedInputStream) {
            this.out.message(txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buf = new byte[4096];
        int r = 0;
        while (!this.closed) {
            try {
                block12: {
                    PipedInputStream pipedInputStream = this.pin;
                    synchronized (pipedInputStream) {
                        while (true) {
                            while (true) {
                                if (this.pin.available() > 0 || this.closed) {
                                    if (!this.closed) {
                                        r = this.pin.read(buf);
                                    }
                                    break block12;
                                }
                                try {
                                    this.pin.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (this.closed) continue;
                this.out.log(new String(buf, 0, r));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

