/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.BlockedHosts;
import dnsfilter.ConfigUtil;
import dnsfilter.ConfigurationAccess;
import dnsfilter.DNSCommunicator;
import dnsfilter.DNSResolver;
import dnsfilter.DNSResponsePatcher;
import dnsfilter.DNSServer;
import dnsfilter.remote.RemoteAccessServer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import util.ExecutionEnvironment;
import util.FileLogger;
import util.Logger;
import util.LoggerInterface;
import util.PatternSequence;
import util.Utils;
import util.conpool.TLSSocketFactory;

public class DNSFilterManager
extends ConfigurationAccess {
    public static final String VERSION = "1505800";
    private static DNSFilterManager INSTANCE = new DNSFilterManager();
    public static boolean debug;
    private static String filterReloadURL;
    private static boolean filterHostsFileRemoveDuplicates;
    private static String filterhostfile;
    private static long filterReloadIntervalDays;
    private static long nextReload;
    private static int okCacheSize;
    private static int filterListCacheSize;
    private static boolean reloadUrlChanged;
    private static boolean validIndex;
    private static boolean aborted;
    private static LoggerInterface TRAFFIC_LOG;
    private static BlockedHosts hostFilter;
    private static PatternSequence customIPMappings;
    private boolean serverStopped = true;
    private boolean reloading_filter = false;
    private AutoFilterUpdater autoFilterUpdater;
    private static RemoteAccessServer remoteAccessManager;
    private static String DOWNLOADED_FF_PREFIX;
    protected Properties config = null;
    private int filterCfgEqual = 0;
    private static boolean updatingFilter;

    static {
        okCacheSize = 500;
        filterListCacheSize = 500;
        aborted = false;
        hostFilter = null;
        customIPMappings = null;
        DOWNLOADED_FF_PREFIX = "# Downloaded by personalDNSFilter at: ";
        updatingFilter = false;
    }

    public static DNSFilterManager getInstance() {
        return INSTANCE;
    }

    private DNSFilterManager() {
    }

    private String getPath() {
        return String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + File.separator;
    }

    @Override
    public void releaseConfiguration() {
    }

    @Override
    public Properties getConfig() throws IOException {
        if (this.config == null) {
            byte[] configBytes = this.readConfig();
            this.config = new Properties();
            this.config.load(new ByteArrayInputStream(configBytes));
        }
        return this.config;
    }

    @Override
    public Properties getDefaultConfig() throws IOException {
        Properties defaults = new Properties();
        defaults.load(ExecutionEnvironment.getEnvironment().getAsset("dnsfilter.conf"));
        return defaults;
    }

    @Override
    public byte[] readConfig() throws ConfigurationAccess.ConfigurationAccessException {
        File propsFile = new File(String.valueOf(this.getPath()) + "dnsfilter.conf");
        if (!propsFile.exists()) {
            try {
                ExecutionEnvironment.getEnvironment().migrateConfig();
            }
            catch (IOException e) {
                Logger.getLogger().logLine(e.toString());
            }
        }
        if (!propsFile.exists()) {
            Logger.getLogger().logLine(propsFile + " not found! - Creating default config!");
            this.createDefaultConfiguration();
        }
        return this.getConfigMergedIfNeeded();
    }

    private byte[] getConfigMergedIfNeeded() throws ConfigurationAccess.ConfigurationAccessException {
        try {
            File propsFile = new File(String.valueOf(this.getPath()) + "dnsfilter.conf");
            FileInputStream in = new FileInputStream(propsFile);
            byte[] config = Utils.readFully(in, 1024);
            ((InputStream)in).close();
            File versionFile = new File(String.valueOf(this.getPath()) + "VERSION.TXT");
            String vStr = "";
            if (versionFile.exists()) {
                FileInputStream vin = new FileInputStream(versionFile);
                vStr = new String(Utils.readFully(vin, 100));
                ((InputStream)vin).close();
            }
            if (!vStr.equals(VERSION)) {
                Logger.getLogger().logLine("Updated version! Previous version:" + vStr + ", current version:" + VERSION);
                byte[] config_Previous_Defaults = this.getPreviousDefaultConfig(vStr);
                this.createDefaultConfiguration();
                config = this.mergeAndPersistConfig(config, config_Previous_Defaults);
            }
            return config;
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    private byte[] getPreviousDefaultConfig(String previousVersion) throws IOException {
        int version = 0;
        if (!previousVersion.equals("")) {
            try {
                version = Integer.parseInt(previousVersion.substring(0, 7));
            }
            catch (Exception e) {
                Logger.getLogger().logLine("Can not parse version from " + previousVersion + "!");
            }
        }
        File defaultConfFile = new File(String.valueOf(this.getPath()) + "dnsfilter-default.conf");
        if (version <= 1505402 || !defaultConfFile.exists()) {
            this.copyFromAssets("dnsfilter-1505401.conf", "dnsfilter-default.conf");
        }
        FileInputStream in = new FileInputStream(defaultConfFile);
        byte[] config = Utils.readFully(in, 1024);
        ((InputStream)in).close();
        return config;
    }

    private byte[] mergeAndPersistConfig(byte[] currentConfigBytes, byte[] config_Previous_Defaults) throws IOException {
        boolean filterDisabledV15045;
        this.filterCfgEqual = 0;
        String currentCfgStr = new String(currentConfigBytes);
        boolean bl = filterDisabledV15045 = currentCfgStr.indexOf("\n#!!!filterHostsFile =") != -1;
        if (filterDisabledV15045) {
            currentCfgStr = currentCfgStr.replace("\n#!!!filterHostsFile =", "\nfilterHostsFile =");
        }
        Properties currentConfig = new Properties();
        currentConfig.load(new ByteArrayInputStream(currentCfgStr.getBytes()));
        Properties previousDefaults = null;
        if (config_Previous_Defaults != null) {
            previousDefaults = new Properties();
            previousDefaults.load(new ByteArrayInputStream(config_Previous_Defaults));
        }
        String[] currentKeys = currentConfig.keySet().toArray(new String[0]);
        BufferedReader defCfgReader = new BufferedReader(new InputStreamReader(ExecutionEnvironment.getEnvironment().getAsset("dnsfilter.conf")));
        File mergedConfig = new File(String.valueOf(this.getPath()) + "dnsfilter.conf");
        FileOutputStream mergedout = new FileOutputStream(mergedConfig);
        String ln = "";
        boolean useNewDefaultFilters = currentConfig.getProperty("previousAutoUpdateURL", "").trim().equals("https://adaway.org/hosts.txt; https://hosts-file.net/ad_servers.txt; https://hosts-file.net/emd.txt");
        while ((ln = defCfgReader.readLine()) != null) {
            if (!useNewDefaultFilters || !ln.startsWith("filterAutoUpdateURL")) {
                int i = 0;
                while (i < currentKeys.length) {
                    if (ln.startsWith(String.valueOf(currentKeys[i]) + " =")) {
                        if (currentKeys[i].equals("filterActive") && filterDisabledV15045) {
                            ln = "filterActive = false";
                        } else if (!this.useDefaultConfig(currentKeys[i], currentConfig, previousDefaults)) {
                            ln = String.valueOf(currentKeys[i]) + " = " + currentConfig.getProperty(currentKeys[i], "").replace("\n", "\\n");
                        }
                    }
                    ++i;
                }
            } else {
                Logger.getLogger().logLine("Taking over default configuration: " + ln);
            }
            mergedout.write((String.valueOf(ln) + "\r\n").getBytes());
        }
        defCfgReader.close();
        Properties defProps = new Properties();
        defProps.load(ExecutionEnvironment.getEnvironment().getAsset("dnsfilter.conf"));
        boolean first = true;
        int i = 0;
        while (i < currentKeys.length) {
            if (!defProps.containsKey(currentKeys[i])) {
                if (first) {
                    mergedout.write("\r\n# Merged custom config from previous config file:\r\n".getBytes());
                }
                first = false;
                ln = String.valueOf(currentKeys[i]) + " = " + currentConfig.getProperty(currentKeys[i], "");
                mergedout.write((String.valueOf(ln) + "\r\n").getBytes());
            }
            ++i;
        }
        mergedout.flush();
        mergedout.close();
        Logger.getLogger().logLine("Merged configuration 'dnsfilter.conf' with defaults of current version 1505800!");
        FileInputStream in = new FileInputStream(mergedConfig);
        byte[] configBytes = Utils.readFully(in, 1024);
        ((InputStream)in).close();
        return configBytes;
    }

    private boolean useDefaultConfig(String currentKey, Properties currentConfig, Properties previousDefaults) {
        boolean forceKeyDefault = currentKey.equals("initialInfoPopUpText") || currentKey.equals("initialInfoPopUpTitle") || currentKey.equals("footerLink") || currentKey.equals("showInitialInfoPopUp");
        boolean useNewDefault = this.useNewDefault(currentKey, currentConfig, previousDefaults);
        return forceKeyDefault || useNewDefault;
    }

    private boolean useNewDefault(String currentKey, Properties currentConfig, Properties previousDefaults) {
        if (previousDefaults == null) {
            return false;
        }
        if (currentKey.equals("fallbackDNS")) {
            return this.dnsConfigEqual(currentConfig.getProperty(currentKey, ""), previousDefaults.getProperty(currentKey, ""));
        }
        if (currentKey.equals("filterAutoUpdateURL") || currentKey.equals("filterAutoUpdateURL_IDs") || currentKey.equals("filterAutoUpdateURL_categories") || currentKey.equals("filterAutoUpdateURL_switchs")) {
            return this.useFilterDefaults(currentConfig, previousDefaults);
        }
        return currentConfig.getProperty(currentKey, "").equals(previousDefaults.getProperty(currentKey, ""));
    }

    private boolean dnsConfigEqual(String dnsCfg1, String dnsCfg2) {
        return DNSServer.getInstance().dnsServersEqual(dnsCfg1, dnsCfg2);
    }

    private boolean useFilterDefaults(Properties currentConfig, Properties previousDefaults) {
        if (this.filterCfgEqual != 0) {
            return this.filterCfgEqual == 1;
        }
        Vector<ConfigUtil.HostFilterList> current = ConfigUtil.getConfiguredFilterListsAsVector(currentConfig);
        Vector<ConfigUtil.HostFilterList> previous = ConfigUtil.getConfiguredFilterListsAsVector(previousDefaults);
        if (current.size() != previous.size()) {
            this.filterCfgEqual = -1;
            return false;
        }
        int i = 0;
        while (i < current.size()) {
            if (!previous.contains(current.elementAt(i))) {
                this.filterCfgEqual = -1;
                return false;
            }
            ++i;
        }
        this.filterCfgEqual = 1;
        return true;
    }

    private void createDefaultConfiguration() {
        try {
            File f = new File(String.valueOf(this.getPath()) + ".");
            f.mkdir();
            this.copyFromAssets("dnsfilter.conf", "dnsfilter.conf");
            this.copyFromAssets("dnsfilter.conf", "dnsfilter-default.conf");
            if (!new File(String.valueOf(this.getPath()) + "additionalHosts.txt").exists()) {
                this.copyFromAssets("additionalHosts.txt", "additionalHosts.txt");
            }
            f = new File(String.valueOf(this.getPath()) + "VERSION.TXT");
            f.createNewFile();
            FileOutputStream fout = new FileOutputStream(f);
            ((OutputStream)fout).write(VERSION.getBytes());
            fout.flush();
            ((OutputStream)fout).close();
            Logger.getLogger().logLine("Default configuration created successfully!");
        }
        catch (IOException e) {
            Logger.getLogger().logLine("Failed creating default configuration!");
            Logger.getLogger().logException(e);
        }
    }

    @Override
    public void updateConfig(byte[] config) throws IOException {
        try {
            this.invalidate();
            FileOutputStream out = new FileOutputStream(String.valueOf(this.getPath()) + "dnsfilter.conf");
            out.write(config);
            out.flush();
            out.close();
            this.config.load(new ByteArrayInputStream(config));
            Logger.getLogger().message("Config changed!\nRestart might be required!");
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    @Override
    public void updateConfigMergeDefaults(byte[] config) throws IOException {
        try {
            this.invalidate();
            config = this.mergeAndPersistConfig(config, null);
            this.config.load(new ByteArrayInputStream(config));
            Logger.getLogger().message("Config changed!\nRestart might be required!");
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] getAdditionalHosts(int limit) throws IOException {
        File additionalHosts;
        block3: {
            try {
                additionalHosts = new File(String.valueOf(this.getPath()) + "additionalHosts.txt");
                if (additionalHosts.length() <= (long)limit) break block3;
                return null;
            }
            catch (IOException e) {
                throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
            }
        }
        FileInputStream in = new FileInputStream(additionalHosts);
        byte[] result = Utils.readFully(in, 1024);
        ((InputStream)in).close();
        return result;
    }

    @Override
    public void updateAdditionalHosts(byte[] bytes) throws IOException {
        try {
            FileOutputStream out = new FileOutputStream(String.valueOf(this.getPath()) + "additionalHosts.txt");
            out.write(bytes);
            out.flush();
            out.close();
            Logger.getLogger().message("Config changed!\nRestart might be required!");
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerUpdateFilter() {
        if (this.reloading_filter) {
            Logger.getLogger().logLine("Filter reload currently running!");
            return;
        }
        if (filterReloadURL != null) {
            DNSFilterManager dNSFilterManager = this;
            synchronized (dNSFilterManager) {
                nextReload = 0L;
                this.notifyAll();
            }
        } else {
            Logger.getLogger().logLine("DNS filter: Setting 'filterAutoUpdateURL' not configured - Cannot update filter!");
        }
    }

    private void copyLocalFile(String from, String to) throws IOException {
        File fromFile = new File(String.valueOf(this.getPath()) + from);
        File toFile = new File(String.valueOf(this.getPath()) + to);
        Utils.copyFile(fromFile, toFile);
    }

    private void zipFile(ZipOutputStream zipOut, File f) throws IOException {
        String name = f.getName();
        Logger.getLogger().logLine("zipping: " + name);
        ZipEntry entry = new ZipEntry(name);
        zipOut.putNextEntry(entry);
        FileInputStream fin = new FileInputStream(f);
        Utils.copyFully(fin, zipOut, false);
        zipOut.closeEntry();
        zipOut.flush();
        fin.close();
    }

    @Override
    public void doBackup(OutputStream out) throws IOException {
        try {
            ZipOutputStream zip = new ZipOutputStream(out);
            this.zipFile(zip, new File(String.valueOf(this.getPath()) + "dnsfilter.conf"));
            this.zipFile(zip, new File(String.valueOf(this.getPath()) + "dnsfilter-default.conf"));
            this.zipFile(zip, new File(String.valueOf(this.getPath()) + "additionalHosts.txt"));
            this.zipFile(zip, new File(String.valueOf(this.getPath()) + "VERSION.TXT"));
            zip.finish();
            zip.close();
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    private void copyFromAssets(String from, String to) throws IOException {
        InputStream defIn = ExecutionEnvironment.getEnvironment().getAsset(from);
        File toFile = new File(String.valueOf(this.getPath()) + to);
        toFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(toFile);
        Utils.copyFully(defIn, out, true);
    }

    @Override
    public void doRestoreDefaults() throws IOException {
        try {
            if (!this.canStop()) {
                throw new IOException("Cannot stop! Pending operation!");
            }
            this.stop();
            this.invalidate();
            this.copyFromAssets("dnsfilter.conf", "dnsfilter.conf");
            this.copyFromAssets("dnsfilter.conf", "dnsfilter-default.conf");
            this.copyFromAssets("additionalHosts.txt", "additionalHosts.txt");
            String filterHostFile = null;
            if (this.config != null && (filterHostFile = this.config.getProperty("filterHostsFile")) != null) {
                new File(String.valueOf(this.getPath()) + filterHostFile).delete();
            }
            this.init();
            ExecutionEnvironment.getEnvironment().onReload();
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    private void restoreZipEntry(ZipEntry entry, ZipInputStream in) throws IOException {
        Logger.getLogger().logLine("Restoring: " + entry.getName());
        FileOutputStream out = new FileOutputStream(String.valueOf(this.getPath()) + entry.getName());
        byte[] buf = new byte[1024];
        Utils.copyFully(in, out, false);
        out.flush();
        out.close();
    }

    @Override
    public void doRestore(InputStream in) throws IOException {
        try {
            if (!this.canStop()) {
                throw new IOException("Cannot stop! Pending operation!");
            }
            this.stop();
            this.invalidate();
            ZipInputStream zip = new ZipInputStream(in);
            ZipEntry entry = zip.getNextEntry();
            try {
                while (entry != null) {
                    this.restoreZipEntry(entry, zip);
                    entry = zip.getNextEntry();
                }
                zip.close();
            }
            catch (Exception e) {
                Logger.getLogger().logException(e);
                throw e;
            }
            this.getConfigMergedIfNeeded();
            String filterHostFile = null;
            if (this.config != null && (filterHostFile = this.config.getProperty("filterHostsFile")) != null) {
                new File(String.valueOf(this.getPath()) + filterHostFile).delete();
            }
            this.init();
            ExecutionEnvironment.getEnvironment().onReload();
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    @Override
    public void wakeLock() {
        ExecutionEnvironment.getEnvironment().wakeLock();
    }

    @Override
    public void releaseWakeLock() {
        ExecutionEnvironment.getEnvironment().releaseWakeLock();
    }

    public void switchBlockingActive() throws IOException {
        String ln;
        Properties config = this.getConfig();
        boolean active = !Boolean.parseBoolean(config.getProperty("filterActive", "true"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.readConfig())));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((ln = reader.readLine()) != null) {
            if (ln.startsWith("filterActive")) {
                ln = "filterActive = " + active;
            }
            out.write((String.valueOf(ln) + "\r\n").getBytes());
        }
        out.flush();
        out.close();
        this.updateConfig(out.toByteArray());
        this.restart();
    }

    private void writeDownloadInfoFile(int count, long lastModified) throws IOException {
        FileOutputStream entryCountOut = new FileOutputStream(String.valueOf(this.getPath()) + filterhostfile + ".DLD_CNT");
        entryCountOut.write((String.valueOf(count) + "\n").getBytes());
        entryCountOut.write((String.valueOf(lastModified) + "\n").getBytes());
        entryCountOut.flush();
        entryCountOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateFilter() throws IOException {
        DNSFilterManager dNSFilterManager = INSTANCE;
        synchronized (dNSFilterManager) {
            try {
                updatingFilter = true;
                ExecutionEnvironment.getEnvironment().wakeLock();
                FileOutputStream out = new FileOutputStream(String.valueOf(this.getPath()) + filterhostfile + ".tmp");
                ((OutputStream)out).write((String.valueOf(DOWNLOADED_FF_PREFIX) + new Date() + "from URLs: " + filterReloadURL + "\n").getBytes());
                boolean useTLSSocketFactory = ExecutionEnvironment.getEnvironment().getEnvironmentID() == 1 && Integer.parseInt(ExecutionEnvironment.getEnvironment().getEnvironmentVersion()) < 21;
                StringTokenizer urlTokens = new StringTokenizer(filterReloadURL, ";");
                int urlCnt = urlTokens.countTokens();
                int count = 0;
                int i = 0;
                while (i < urlCnt) {
                    block27: {
                        int skippedWildcard;
                        String urlStr;
                        block30: {
                            urlStr = urlTokens.nextToken().trim();
                            skippedWildcard = 0;
                            try {
                                int[] r;
                                BufferedInputStream in;
                                block28: {
                                    block32: {
                                        if (urlStr.equals("")) break block27;
                                        Logger.getLogger().message("Connecting: " + urlStr);
                                        if (urlStr.startsWith("file://")) break block32;
                                        URL url = new URL(urlStr);
                                        URLConnection con = url.openConnection();
                                        if (useTLSSocketFactory && con instanceof HttpsURLConnection) {
                                            try {
                                                ((HttpsURLConnection)con).setSSLSocketFactory(new TLSSocketFactory());
                                            }
                                            catch (Exception e) {
                                                Logger.getLogger().message(e.getMessage());
                                            }
                                        }
                                        con.setConnectTimeout(120000);
                                        con.setReadTimeout(120000);
                                        con.setRequestProperty("Accept-Encoding", "gzip, deflate, identity");
                                        con.setRequestProperty("User-Agent", "Mozilla/5.0 (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + ")");
                                        String contentencoding = con.getContentEncoding();
                                        if ("gzip".equals(contentencoding)) {
                                            in = new BufferedInputStream(new GZIPInputStream(con.getInputStream()), 2048);
                                            break block28;
                                        } else if ("deflate".equals(contentencoding)) {
                                            in = new BufferedInputStream(new InflaterInputStream(con.getInputStream()), 2048);
                                            break block28;
                                        } else {
                                            if (contentencoding != null) {
                                                if (!"identity".equals(contentencoding)) throw new IOException("ContentEncoding not supported:" + contentencoding);
                                            }
                                            in = new BufferedInputStream(con.getInputStream(), 2048);
                                        }
                                        break block28;
                                    }
                                    in = new BufferedInputStream(new FileInputStream(urlStr.substring(7)), 2048);
                                }
                                byte[] buf = new byte[2048];
                                int received = 0;
                                int delta = 100000;
                                while ((r = this.readHostFileEntry(in, buf))[1] != -1 && !aborted) {
                                    if (r[1] == 0) continue;
                                    String hostEntry = new String(buf, 0, r[1]);
                                    if (hostEntry != null && !hostEntry.equals("localhost")) {
                                        String host = hostEntry;
                                        if (r[0] == 1) {
                                            if (host.startsWith("*.") & host.lastIndexOf("*") == 0) {
                                                host = host.substring(2);
                                                ((OutputStream)out).write((String.valueOf(host) + "\n").getBytes());
                                                ++count;
                                            } else {
                                                ++skippedWildcard;
                                            }
                                        } else {
                                            ((OutputStream)out).write((String.valueOf(host) + "\n").getBytes());
                                            ++count;
                                        }
                                    }
                                    if ((received += r[1]) <= delta) continue;
                                    Logger.getLogger().message("Loading Filter - Bytes received:" + received);
                                    delta += 100000;
                                }
                                ((InputStream)in).close();
                                if (!aborted) break block30;
                                Logger.getLogger().logLine("Aborting filter update!");
                                Logger.getLogger().message("Filter update aborted!");
                                out.flush();
                                ((OutputStream)out).close();
                            }
                            catch (IOException eio) {
                                String msg = "ERROR loading filter: " + urlStr;
                                Logger.getLogger().message(msg);
                                Logger.getLogger().logLine(msg);
                                ((OutputStream)out).close();
                                throw eio;
                            }
                            return false;
                        }
                        if (skippedWildcard != 0) {
                            Logger.getLogger().logLine("WARNING! - " + skippedWildcard + " skipped entrie(s) for " + urlStr + "! Wildcards are only supported in additionalHosts.txt!");
                        }
                    }
                    ++i;
                }
                this.setIndexOutdated(true);
                this.updateIndexReloadInfoConfFile(filterReloadURL);
                reloadUrlChanged = false;
                Logger.getLogger().logLine("Updating filter completed!");
                out.flush();
                ((OutputStream)out).close();
                File ffile = new File(String.valueOf(this.getPath()) + filterhostfile);
                if (ffile.exists()) {
                    if (!ffile.delete()) throw new IOException("Renaming downloaded .tmp file to filter file failed!");
                }
                new File(String.valueOf(this.getPath()) + filterhostfile + ".tmp").renameTo(new File(String.valueOf(this.getPath()) + filterhostfile));
                this.writeDownloadInfoFile(count, new File(String.valueOf(this.getPath()) + filterhostfile).lastModified());
            }
            finally {
                ExecutionEnvironment.getEnvironment().releaseWakeLock();
                updatingFilter = false;
                INSTANCE.notifyAll();
            }
            return true;
        }
    }

    private void setIndexOutdated(boolean outdated) throws IOException {
        File f = new File(String.valueOf(this.getPath()) + "IDX_OUTDATED");
        if (outdated) {
            f.createNewFile();
        } else if (!f.delete()) {
            throw new IOException("Cannot delete 'IDX_OUTDATED' file!");
        }
    }

    private boolean isIndexOutdated() {
        return new File(String.valueOf(this.getPath()) + "IDX_OUTDATED").exists();
    }

    /*
     * Exception decompiling
     */
    public int[] readHostFileEntry(InputStream in, byte[] buf) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String[] parseHosts(String line) throws IOException {
        String[] result;
        if (line.startsWith("#") || line.startsWith("!") || line.startsWith(">") || line.trim().equals("")) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(line);
        if (tokens.countTokens() >= 2) {
            String ip = tokens.nextToken().trim();
            String host = tokens.nextToken().trim();
            result = new String[]{ip, host};
        } else {
            String ip = "127.0.0.1";
            String host = tokens.nextToken().trim();
            result = new String[]{ip, host};
        }
        this.checkHostName(result[1]);
        return result;
    }

    private void checkHostName(String host) throws IOException {
        if (host.length() > 253) {
            throw new IOException("Invalid hostname: " + host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void abortFilterUpdate() {
        aborted = true;
        DNSFilterManager dNSFilterManager = INSTANCE;
        synchronized (dNSFilterManager) {
            while (true) {
                if (!updatingFilter) {
                    aborted = false;
                    return;
                }
                try {
                    INSTANCE.wait();
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildIndex() throws IOException {
        DNSFilterManager dNSFilterManager = INSTANCE;
        synchronized (dNSFilterManager) {
            try {
                int estimatedIdxCount;
                updatingFilter = true;
                Logger.getLogger().logLine("Reading filter file and building index...!");
                File filterfile = new File(String.valueOf(this.getPath()) + filterhostfile);
                File indexFile = new File(String.valueOf(this.getPath()) + filterhostfile + ".idx");
                BufferedReader fin = new BufferedReader(new InputStreamReader(new FileInputStream(filterfile)));
                int size = 0;
                int ffileCount = -1;
                String firstffLine = fin.readLine();
                boolean ffDownloaded = false;
                if (firstffLine.startsWith(DOWNLOADED_FF_PREFIX)) {
                    ffDownloaded = true;
                    try {
                        File downloadInfoFile = new File(String.valueOf(this.getPath()) + filterhostfile + ".DLD_CNT");
                        if (downloadInfoFile.exists()) {
                            BufferedInputStream in = new BufferedInputStream(new FileInputStream(downloadInfoFile));
                            byte[] info = new byte[1024];
                            int r = Utils.readLineBytesFromStream(in, info, true, true);
                            ffileCount = Integer.parseInt(new String(info, 0, r).trim());
                            r = Utils.readLineBytesFromStream(in, info, true, true);
                            if (r == -1 || Long.parseLong(new String(info, 0, r).trim()) != filterfile.lastModified()) {
                                ffileCount = -1;
                            }
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger().logLine("Error retrieving number of downloaded hosts\n" + e.getMessage());
                        ffileCount = -1;
                    }
                }
                if ((estimatedIdxCount = ffileCount) == -1) {
                    estimatedIdxCount = Math.max(1, (int)(filterfile.length() / 30L));
                }
                BlockedHosts hostFilterSet = new BlockedHosts(estimatedIdxCount, okCacheSize, filterListCacheSize);
                String entry = firstffLine;
                boolean skipFFprep = false;
                if (ffDownloaded && ffileCount != -1) {
                    entry = null;
                    size = ffileCount;
                    skipFFprep = true;
                }
                while (true) {
                    if (aborted || entry == null) {
                        fin.close();
                        if (!aborted) break;
                        Logger.getLogger().logLine("Aborting indexing!");
                        Logger.getLogger().message("Indexing aborted!");
                        return;
                    }
                    String[] hostEntry = this.parseHosts(entry);
                    if (hostEntry != null && !hostEntry[1].equals("localhost")) {
                        hostFilterSet.prepareInsert(hostEntry[1]);
                        ++size;
                    }
                    entry = fin.readLine();
                }
                if (!skipFFprep) {
                    hostFilterSet.finalPrepare();
                } else {
                    hostFilterSet.finalPrepare(estimatedIdxCount);
                }
                Logger.getLogger().logLine("Building index for " + size + " entries...!");
                fin = new BufferedReader(new InputStreamReader(new FileInputStream(filterfile)));
                File uniqueEntriyFile = new File(String.valueOf(this.getPath()) + "uniqueentries.tmp");
                BufferedOutputStream fout = null;
                if (filterHostsFileRemoveDuplicates) {
                    fout = new BufferedOutputStream(new FileOutputStream(uniqueEntriyFile));
                    fout.write((String.valueOf(firstffLine) + "\n").getBytes());
                }
                int processed = 0;
                int uniqueEntries = 0;
                if (ffDownloaded) {
                    fin.readLine();
                }
                while (true) {
                    if (aborted || (entry = fin.readLine()) == null) {
                        ffileCount = uniqueEntries;
                        Logger.getLogger().message("Building index for " + processed + "/" + size + " entries completed!");
                        fin.close();
                        if (aborted) {
                            Logger.getLogger().logLine("Indexing aborted!");
                            if (!filterHostsFileRemoveDuplicates) return;
                            fout.close();
                            return;
                        }
                        break;
                    }
                    String[] hostEntry = !ffDownloaded ? this.parseHosts(entry) : new String[]{"", entry};
                    if (hostEntry == null || hostEntry[1].equals("localhost")) continue;
                    if (hostFilterSet.add(hostEntry[1])) {
                        ++uniqueEntries;
                        if (filterHostsFileRemoveDuplicates) {
                            fout.write((String.valueOf(hostEntry[1]) + "\n").getBytes());
                        }
                    }
                    if (++processed % 10000 != 0) continue;
                    Logger.getLogger().message("Building index for " + processed + "/" + size + " entries completed!");
                }
                if (filterHostsFileRemoveDuplicates) {
                    fout.flush();
                    fout.close();
                    filterfile.delete();
                    uniqueEntriyFile.renameTo(filterfile);
                    if (skipFFprep) {
                        this.writeDownloadInfoFile(ffileCount, new File(String.valueOf(this.getPath()) + filterhostfile).lastModified());
                    }
                }
                boolean lock = hostFilter != null;
                try {
                    if (lock) {
                        hostFilter.lock(1);
                    }
                    Logger.getLogger().logLine("Persisting index for " + size + " entries...!");
                    Logger.getLogger().logLine("Index contains " + uniqueEntries + " unique entries!");
                    hostFilterSet.persist(String.valueOf(this.getPath()) + filterhostfile + ".idx");
                    hostFilterSet.clear();
                    hostFilterSet = BlockedHosts.loadPersistedIndex(indexFile.getAbsolutePath(), false, okCacheSize, filterListCacheSize);
                    if (hostFilter != null) {
                        hostFilter.migrateTo(hostFilterSet);
                    } else {
                        hostFilter = hostFilterSet;
                        DNSResponsePatcher.init(hostFilter, TRAFFIC_LOG);
                    }
                    this.applyOverrules();
                }
                finally {
                    if (lock) {
                        hostFilter.unLock(1);
                    }
                }
                this.setIndexOutdated(false);
                validIndex = true;
                Logger.getLogger().logLine("Processing new filter file completed!");
            }
            finally {
                updatingFilter = false;
                INSTANCE.notifyAll();
            }
            return;
        }
    }

    private void applyOverrules() throws IOException {
        File additionalHosts = new File(String.valueOf(this.getPath()) + "additionalHosts.txt");
        BufferedReader addHostIn = new BufferedReader(new InputStreamReader(new FileInputStream(additionalHosts)));
        customIPMappings.clear();
        String entry = null;
        while ((entry = addHostIn.readLine()) != null) {
            if ((entry = entry.trim().toLowerCase()).equals("") || entry.startsWith("#")) continue;
            if (entry.startsWith(">")) {
                this.applyCustomIpMapping(entry.substring(1).trim());
            }
            if (entry.startsWith("!")) {
                hostFilter.addOverrule(entry.substring(1).trim(), false);
                continue;
            }
            hostFilter.addOverrule(entry, true);
        }
        addHostIn.close();
    }

    private void applyCustomIpMapping(String entry) {
        StringTokenizer tokens = new StringTokenizer(entry);
        try {
            String host = tokens.nextToken().trim().toLowerCase();
            String ip = tokens.nextToken().trim();
            InetAddress address = InetAddress.getByName(ip);
            byte[] addressBytes = address.getAddress();
            if (addressBytes.length == 4) {
                customIPMappings.addPattern(">4" + host, addressBytes);
            } else {
                customIPMappings.addPattern(">6" + host, addressBytes);
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Cannot apply custom mapping " + entry);
            Logger.getLogger().logLine(e.toString());
        }
    }

    private void reloadFilter(boolean async) throws IOException {
        try {
            ExecutionEnvironment.getEnvironment().wakeLock();
            File filterfile = new File(String.valueOf(this.getPath()) + filterhostfile);
            File downloadInfoFile = new File(String.valueOf(this.getPath()) + filterhostfile + ".DLD_CNT");
            File additionalHosts = new File(String.valueOf(this.getPath()) + "additionalHosts.txt");
            boolean bl = validIndex = !this.isIndexOutdated();
            if (!additionalHosts.exists()) {
                additionalHosts.createNewFile();
            }
            nextReload = filterfile.exists() && downloadInfoFile.exists() && !reloadUrlChanged ? filterReloadIntervalDays * 24L * 60L * 60L * 1000L + downloadInfoFile.lastModified() : 0L;
            File indexFile = new File(String.valueOf(this.getPath()) + filterhostfile + ".idx");
            if (indexFile.exists() && validIndex && BlockedHosts.checkIndexVersion(indexFile.getAbsolutePath())) {
                hostFilter = BlockedHosts.loadPersistedIndex(indexFile.getAbsolutePath(), false, okCacheSize, filterListCacheSize);
                this.applyOverrules();
            } else if (filterfile.exists() && nextReload != 0L) {
                if (!async) {
                    this.rebuildIndex();
                } else {
                    new Thread(new AsyncIndexBuilder()).start();
                }
            }
        }
        finally {
            ExecutionEnvironment.getEnvironment().releaseWakeLock();
        }
    }

    private void updateIndexReloadInfoConfFile(String url) {
        try {
            String ln;
            this.invalidate();
            if (remoteAccessManager != null) {
                remoteAccessManager.invalidate();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(this.getPath()) + "dnsfilter.conf")));
            boolean found = false;
            while ((ln = reader.readLine()) != null) {
                if (url != null && ln.startsWith("previousAutoUpdateURL")) {
                    found = true;
                    ln = "previousAutoUpdateURL = " + url;
                }
                out.write((String.valueOf(ln) + "\r\n").getBytes());
            }
            if (!found) {
                out.write(("previousAutoUpdateURL = " + url + "\r\n").getBytes());
            }
            out.flush();
            reader.close();
            FileOutputStream fout = new FileOutputStream(String.valueOf(this.getPath()) + "dnsfilter.conf");
            ((OutputStream)fout).write(out.toByteArray());
            fout.flush();
            ((OutputStream)fout).close();
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFilter(String entries, boolean filter) throws IOException {
        try {
            boolean indexingAborted = false;
            if (updatingFilter) {
                this.abortFilterUpdate();
                indexingAborted = true;
            }
            DNSFilterManager dNSFilterManager = INSTANCE;
            synchronized (dNSFilterManager) {
                String copyPasteStartSection = "##### AUTOMATIC ENTRIES BELOW! #####";
                String whitelistSection = "## Whitelisted Entries! ##";
                String blacklistSection = "## Blacklisted Entries! ##";
                if (entries.trim().equals("") || hostFilter == null) {
                    return;
                }
                StringTokenizer entryTokens = new StringTokenizer(entries, "\n");
                HashSet<String> entriestoChange = new HashSet<String>();
                while (entryTokens.hasMoreTokens()) {
                    String entry = entryTokens.nextToken().trim();
                    entriestoChange.add(entry);
                }
                File additionalHosts = new File(String.valueOf(this.getPath()) + "additionalHosts.txt");
                File additionalHostsNew = new File(String.valueOf(this.getPath()) + "additionalHosts.txt.tmp");
                BufferedReader addHostIn = new BufferedReader(new InputStreamReader(new FileInputStream(additionalHosts)));
                BufferedWriter addHostOut = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(additionalHostsNew)));
                String entry = null;
                boolean copyPasteSection = false;
                boolean listSection = false;
                while ((entry = addHostIn.readLine()) != null) {
                    boolean hostEntry;
                    String host = entry.toLowerCase();
                    boolean bl = hostEntry = !entry.trim().equals("") || entry.startsWith("#") || entry.startsWith(">");
                    if (entry.startsWith("!")) {
                        host = entry.trim().substring(1);
                    }
                    if (!hostEntry || !entriestoChange.contains(host)) {
                        addHostOut.write(String.valueOf(entry) + "\n");
                    }
                    if (!copyPasteSection) {
                        copyPasteSection = entry.startsWith(copyPasteStartSection);
                    }
                    if (listSection) continue;
                    boolean bl2 = listSection = filter && entry.startsWith(blacklistSection) || !filter && entry.startsWith(whitelistSection);
                    if (!listSection) continue;
                    this.writeNewEntries(filter, entriestoChange, addHostOut);
                }
                addHostIn.close();
                if (!copyPasteSection) {
                    addHostOut.write("\n" + copyPasteStartSection + "\n");
                }
                if (!listSection) {
                    if (filter) {
                        addHostOut.write("\n" + blacklistSection + "\n");
                    } else {
                        addHostOut.write("\n" + whitelistSection + "\n");
                    }
                    this.writeNewEntries(filter, entriestoChange, addHostOut);
                }
                addHostOut.flush();
                addHostOut.close();
                additionalHosts.delete();
                additionalHostsNew.renameTo(additionalHosts);
                Logger.getLogger().message("Updated " + entriestoChange.size() + " host(s)!");
                if (indexingAborted) {
                    new Thread(new AsyncIndexBuilder()).start();
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int openConnectionsCount() {
        return DNSResolver.getResolverCount();
    }

    @Override
    public String getLastDNSAddress() {
        return DNSCommunicator.getInstance().getLastDNSAddress();
    }

    @Override
    public void restart() throws IOException {
        try {
            this.stop();
            this.init();
            ExecutionEnvironment.getEnvironment().onReload();
        }
        catch (IOException e) {
            throw new ConfigurationAccess.ConfigurationAccessException(e.getMessage(), e);
        }
    }

    @Override
    public long[] getFilterStatistics() {
        return new long[]{DNSResponsePatcher.getOkCount(), DNSResponsePatcher.getFilterCount()};
    }

    private void writeNewEntries(boolean filter, HashSet<String> entriestoChange, BufferedWriter addHostOut) throws IOException {
        String excludePref = "";
        if (!filter) {
            excludePref = "!";
        }
        for (String entry : entriestoChange) {
            hostFilter.removeOverrule(entry.toLowerCase(), !filter);
            addHostOut.write("\n" + excludePref + entry);
            hostFilter.addOverrule(entry.toLowerCase(), filter);
        }
    }

    private void initEnv() {
        debug = false;
        filterReloadURL = null;
        filterhostfile = null;
        filterReloadIntervalDays = 4L;
        nextReload = 0L;
        reloadUrlChanged = false;
        filterHostsFileRemoveDuplicates = false;
        validIndex = true;
        hostFilter = null;
        if (customIPMappings != null) {
            customIPMappings.clear();
            customIPMappings = null;
            DNSResolver.initLocalResolver(null, false, 0);
        }
        this.reloading_filter = false;
    }

    private String getFilterReloadURL(Properties config) {
        String urls = config.getProperty("filterAutoUpdateURL", "");
        String url_switchs = config.getProperty("filterAutoUpdateURL_switchs", "");
        StringTokenizer urlTokens = new StringTokenizer(urls, ";");
        StringTokenizer urlSwitchTokens = new StringTokenizer(url_switchs, ";");
        int count = urlTokens.countTokens();
        String result = "";
        String seperator = "";
        int i = 0;
        while (i < count) {
            String urlStr = urlTokens.nextToken().trim();
            boolean active = true;
            if (urlSwitchTokens.hasMoreTokens()) {
                active = Boolean.parseBoolean(urlSwitchTokens.nextToken().trim());
            }
            if (active) {
                result = String.valueOf(result) + seperator + urlStr;
                seperator = "; ";
            }
            ++i;
        }
        return result;
    }

    public void init() throws IOException {
        if (!this.serverStopped) {
            throw new IllegalStateException("Cannot start! Already running!");
        }
        this.initEnv();
        Logger.getLogger().logLine("***Initializing personalDNSfilter Version 1505800!***");
        Logger.getLogger().logLine("Using directory: " + this.getPath());
        byte[] configBytes = this.readConfig();
        this.config = new Properties();
        this.config.load(new ByteArrayInputStream(configBytes));
        DNSServer.init();
        this.serverStopped = false;
        if (remoteAccessManager == null) {
            try {
                int port = Integer.parseInt(this.config.getProperty("server_remote_ctrl_port", "-1"));
                String keyphrase = this.config.getProperty("server_remote_ctrl_keyphrase", "");
                if (port != -1) {
                    remoteAccessManager = new RemoteAccessServer(port, keyphrase);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logException(e);
            }
        }
        try {
            okCacheSize = Integer.parseInt(this.config.getProperty("allowedHostsCacheSize", "1000").trim());
            filterListCacheSize = Integer.parseInt(this.config.getProperty("filterHostsCacheSize", "1000").trim());
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger().logLine("Cannot parse cache size configuration!");
            throw new IOException(nfe);
        }
        if (this.config.getProperty("androidKeepAwake", "true").equalsIgnoreCase("true")) {
            ExecutionEnvironment.getEnvironment().wakeLock();
        }
        try {
            if (this.config.getProperty("enableTrafficLog", "true").equalsIgnoreCase("true")) {
                TRAFFIC_LOG = new FileLogger(String.valueOf(this.getPath()) + "log", this.config.getProperty("trafficLogName", "trafficlog"), Integer.parseInt(this.config.getProperty("trafficLogSize", "1048576").trim()), Integer.parseInt(this.config.getProperty("trafficLogSlotCount", "2").trim()), "timestamp, client:port, class, type, domain name, answer");
                ((FileLogger)TRAFFIC_LOG).enableTimestamp(true);
                Logger.setLogger(TRAFFIC_LOG, "TrafficLogger");
            } else {
                TRAFFIC_LOG = null;
            }
        }
        catch (NumberFormatException nfe) {
            Logger.getLogger().logLine("Cannot parse log configuration!");
            throw new IOException(nfe);
        }
        debug = Boolean.parseBoolean(this.config.getProperty("debug", "false"));
        filterHostsFileRemoveDuplicates = true;
        filterhostfile = this.config.getProperty("filterHostsFile");
        boolean filterActive = Boolean.parseBoolean(this.config.getProperty("filterActive", "true"));
        if (filterhostfile != null && filterActive) {
            for (Map.Entry<Object, Object> entry : this.config.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("filter.")) continue;
                Logger.getLogger().logLine("WARNING! '" + key + "' not supported anymore! Use additionalHosts.txt!");
            }
            boolean enableLocalResolver = Boolean.parseBoolean(this.config.getProperty("enableLocalResolver", "false"));
            int localTTL = Integer.parseInt(this.config.getProperty("localResolverTTL", "60"));
            customIPMappings = new PatternSequence();
            DNSResolver.initLocalResolver(customIPMappings, enableLocalResolver, localTTL);
            filterReloadURL = this.getFilterReloadURL(this.config);
            filterReloadIntervalDays = Integer.parseInt(this.config.getProperty("reloadIntervalDays", "4"));
            String previousReloadURL = this.config.getProperty("previousAutoUpdateURL");
            if (filterReloadURL != null) {
                reloadUrlChanged = !filterReloadURL.equals(previousReloadURL);
            }
            this.reloadFilter(true);
            if (filterReloadURL != null) {
                this.autoFilterUpdater = new AutoFilterUpdater();
                Thread t = new Thread(this.autoFilterUpdater);
                t.setDaemon(true);
                t.start();
            }
            DNSResponsePatcher.init(hostFilter, TRAFFIC_LOG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        if (this.serverStopped) {
            return;
        }
        this.abortFilterUpdate();
        DNSFilterManager dNSFilterManager = this;
        synchronized (dNSFilterManager) {
            if (this.autoFilterUpdater != null) {
                this.autoFilterUpdater.stop();
                this.autoFilterUpdater = null;
            }
            this.notifyAll();
            if (hostFilter != null) {
                hostFilter.clear();
            }
            DNSResponsePatcher.init(null, null);
            if (TRAFFIC_LOG != null) {
                TRAFFIC_LOG.closeLogger();
                Logger.removeLogger("TrafficLogger");
            }
            this.serverStopped = true;
            ExecutionEnvironment.getEnvironment().releaseAllWakeLocks();
        }
    }

    public boolean canStop() {
        return !this.reloading_filter;
    }

    static /* synthetic */ DNSFilterManager access$2() {
        return INSTANCE;
    }

    private class AsyncIndexBuilder
    implements Runnable {
        private AsyncIndexBuilder() {
        }

        @Override
        public void run() {
            DNSFilterManager.this.reloading_filter = true;
            try {
                try {
                    DNSFilterManager.this.rebuildIndex();
                }
                catch (IOException e) {
                    Logger.getLogger().logException(e);
                    DNSFilterManager.this.reloading_filter = false;
                }
            }
            finally {
                DNSFilterManager.this.reloading_filter = false;
            }
        }
    }

    private class AutoFilterUpdater
    implements Runnable {
        private Object monitor = DNSFilterManager.access$2();
        boolean stopRequest = false;
        boolean running = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilNextFilterReload() throws InterruptedException {
            Object object = this.monitor;
            synchronized (object) {
                while (nextReload > System.currentTimeMillis() && !this.stopRequest) {
                    this.monitor.wait(10000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.stopRequest = true;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
                while (this.running) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        Logger.getLogger().logException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.monitor;
            synchronized (object) {
                this.running = true;
                try {
                    this.monitor.wait(1000L);
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logException(e);
                }
                try {
                    int retry = 0;
                    while (!this.stopRequest) {
                        Logger.getLogger().logLine("DNS filter: Next filter reload:" + new Date(nextReload));
                        try {
                            this.waitUntilNextFilterReload();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.stopRequest) break;
                        try {
                            long waitTime;
                            try {
                                DNSFilterManager.this.reloading_filter = true;
                                Logger.getLogger().logLine("DNS filter: Reloading hosts filter ...");
                                if (DNSFilterManager.this.updateFilter()) {
                                    validIndex = false;
                                    DNSFilterManager.this.reloadFilter(false);
                                    Logger.getLogger().logLine("Reloading hosts filter ... completed!");
                                }
                                waitTime = filterReloadIntervalDays * 24L * 60L * 60L * 1000L;
                                nextReload = System.currentTimeMillis() + waitTime;
                                retry = 0;
                            }
                            catch (Exception e) {
                                Logger.getLogger().logLine("Cannot update hosts filter file!");
                                Logger.getLogger().logLine(e.toString());
                                if (retry < 10) {
                                    waitTime = retry < 5 ? 60000L : 3600000L;
                                    nextReload = System.currentTimeMillis() + waitTime;
                                    Logger.getLogger().logLine("Retry at: " + new Date(nextReload));
                                    ++retry;
                                } else {
                                    Logger.getLogger().logLine("Giving up! Reload skipped!");
                                    waitTime = filterReloadIntervalDays * 24L * 60L * 60L * 1000L;
                                    nextReload = System.currentTimeMillis() + waitTime;
                                    retry = 0;
                                }
                                DNSFilterManager.this.reloading_filter = false;
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            DNSFilterManager.this.reloading_filter = false;
                            throw throwable;
                        }
                        DNSFilterManager.this.reloading_filter = false;
                    }
                    Logger.getLogger().logLine("DNS filter: AutoFilterUpdater stopped!");
                }
                finally {
                    this.running = false;
                    this.monitor.notifyAll();
                }
            }
        }
    }
}

