/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.ConfigUtil;
import dnsfilter.DNSFilterManager;
import dnsfilter.remote.RemoteAccessClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import util.LoggerInterface;

public abstract class ConfigurationAccess {
    protected ConfigUtil config_util = null;
    protected static ConfigurationAccess REMOTE;

    public static ConfigurationAccess getLocal() {
        return DNSFilterManager.getInstance();
    }

    public static ConfigurationAccess getRemote(LoggerInterface logger, String host, int port, String keyphrase) throws IOException {
        REMOTE = new RemoteAccessClient(logger, host, port, keyphrase);
        return REMOTE;
    }

    public static ConfigurationAccess getCurrent() {
        if (REMOTE == null) {
            return ConfigurationAccess.getLocal();
        }
        return REMOTE;
    }

    protected void invalidate() {
        this.config_util = null;
    }

    public String toString() {
        return "LOCAL";
    }

    public boolean isLocal() {
        return true;
    }

    public ConfigUtil getConfigUtil() throws IOException {
        if (this.config_util == null) {
            this.config_util = new ConfigUtil(this.readConfig());
        }
        return this.config_util;
    }

    public abstract void releaseConfiguration();

    public abstract Properties getConfig() throws IOException;

    public abstract Properties getDefaultConfig() throws IOException;

    public abstract byte[] readConfig() throws IOException;

    public abstract void updateConfig(byte[] var1) throws IOException;

    public abstract void updateConfigMergeDefaults(byte[] var1) throws IOException;

    public abstract byte[] getAdditionalHosts(int var1) throws IOException;

    public abstract void updateAdditionalHosts(byte[] var1) throws IOException;

    public abstract void updateFilter(String var1, boolean var2) throws IOException;

    public abstract String getVersion() throws IOException;

    public abstract int openConnectionsCount() throws IOException;

    public abstract String getLastDNSAddress() throws IOException;

    public abstract void restart() throws IOException;

    public abstract void stop() throws IOException;

    public abstract long[] getFilterStatistics() throws IOException;

    public abstract void triggerUpdateFilter() throws IOException;

    public abstract void doBackup(OutputStream var1) throws IOException;

    public abstract void doRestoreDefaults() throws IOException;

    public abstract void doRestore(InputStream var1) throws IOException;

    public abstract void wakeLock() throws IOException;

    public abstract void releaseWakeLock() throws IOException;

    public static class ConfigurationAccessException
    extends IOException {
        public ConfigurationAccessException(String msg, IOException cause) {
            super(msg, cause);
        }

        public ConfigurationAccessException(String msg) {
            super(msg);
        }
    }
}

