/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import util.Utils;

public class HttpChunkedInputStream
extends InputStream {
    private DataInputStream underlying = null;
    private ByteArrayInputStream bytesBuf = null;
    private boolean eof = false;

    public HttpChunkedInputStream(InputStream lowerIn) {
        this.underlying = new DataInputStream(lowerIn);
    }

    @Override
    public int read() throws IOException {
        if (this.available() != 0) {
            return this.bytesBuf.read();
        }
        if (this.eof) {
            return -1;
        }
        this.readNextChunk();
        if (this.eof) {
            return -1;
        }
        return this.bytesBuf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() != 0) {
            return this.bytesBuf.read(b, off, len);
        }
        if (this.eof) {
            return -1;
        }
        this.readNextChunk();
        if (this.eof) {
            return -1;
        }
        return this.bytesBuf.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        if (this.bytesBuf != null) {
            return this.bytesBuf.available();
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    private void readNextChunk() throws IOException {
        String hexStr = Utils.readLineFromStreamRN(this.underlying);
        if (hexStr == null) {
            throw new EOFException("Invalid end of ChunkedInputStream!");
        }
        if (hexStr.equals("")) {
            this.eof = true;
            return;
        }
        int length = -1;
        try {
            length = Integer.parseInt(hexStr, 16);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        if (length != 0) {
            byte[] buf = new byte[length];
            this.underlying.readFully(buf);
            this.bytesBuf = new ByteArrayInputStream(buf);
        } else {
            this.eof = true;
        }
        Utils.readLineFromStreamRN(this.underlying);
    }
}

