/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.ConfigurationAccess;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import util.Logger;
import util.LoggerInterface;

public class DNSResponsePatcher {
    private static Set FILTER = null;
    private static LoggerInterface TRAFFIC_LOG = null;
    protected static byte[] ipv4_blocked;
    protected static byte[] ipv6_blocked;
    private static long okCnt;
    private static long filterCnt;
    private static boolean checkIP;
    private static boolean checkCNAME;

    static {
        okCnt = 0L;
        filterCnt = 0L;
        checkIP = false;
        checkCNAME = true;
        try {
            ipv4_blocked = InetAddress.getByName(ConfigurationAccess.getLocal().getConfig().getProperty("ipV4BlockedHost", "127.0.0.1")).getAddress();
            ipv6_blocked = InetAddress.getByName(ConfigurationAccess.getLocal().getConfig().getProperty("ipV6BlockedHost", "::1")).getAddress();
        }
        catch (Exception e) {
            Logger.getLogger().logException(e);
        }
    }

    public static void init(Set filter, LoggerInterface trafficLogger) {
        FILTER = filter;
        TRAFFIC_LOG = trafficLogger;
        try {
            checkIP = Boolean.parseBoolean(ConfigurationAccess.getLocal().getConfig().getProperty("checkResolvedIP", "false"));
            checkCNAME = Boolean.parseBoolean(ConfigurationAccess.getLocal().getConfig().getProperty("checkCNAME", "false"));
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    public static long getFilterCount() {
        return filterCnt;
    }

    public static long getOkCount() {
        return okCnt;
    }

    public static byte[] patchResponse(String client, byte[] response, int offs) throws IOException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(response, offs, response.length - offs);
            String queryHost = "";
            buf.getShort();
            buf.getShort();
            int questCount = buf.getShort();
            short answerCount = buf.getShort();
            buf.getShort();
            buf.getShort();
            boolean filter = false;
            int i = 0;
            while (i < questCount) {
                queryHost = DNSResponsePatcher.readDomainName(buf, offs);
                short type = buf.getShort();
                if (type == 1 || type == 28) {
                    filter = filter || DNSResponsePatcher.filter(queryHost, true);
                }
                short clss = buf.getShort();
                DNSResponsePatcher.trafficLog(client, clss, type, queryHost, null, 0);
                ++i;
            }
            i = 0;
            while (i < answerCount) {
                byte[] answer;
                String host = DNSResponsePatcher.readDomainName(buf, offs);
                short type = buf.getShort();
                short clss = buf.getShort();
                buf.getInt();
                short len = buf.getShort();
                boolean filtered = false;
                if (type == 1 || type == 28) {
                    if (!filter && checkCNAME && !host.equals(queryHost)) {
                        filter = filter || DNSResponsePatcher.filter(host, true);
                        queryHost = host;
                    }
                    if (filter) {
                        filtered = true;
                        if (type == 1) {
                            buf.put(ipv4_blocked);
                        } else if (type == 28) {
                            buf.put(ipv6_blocked);
                        }
                    } else if (checkIP) {
                        answer = new byte[len];
                        buf.get(answer);
                        buf.position(buf.position() - len);
                        String ip = InetAddress.getByAddress(answer).getHostAddress();
                        if (DNSResponsePatcher.filterIP(ip)) {
                            filtered = true;
                            if (type == 1) {
                                buf.put(ipv4_blocked);
                            } else if (type == 28) {
                                buf.put(ipv6_blocked);
                            }
                        }
                    }
                }
                if (!filtered) {
                    buf.position(buf.position() + len);
                }
                if (TRAFFIC_LOG != null) {
                    answer = new byte[len];
                    String answerStr = null;
                    buf.position(buf.position() - len);
                    if (type == 5) {
                        answerStr = DNSResponsePatcher.readDomainName(buf, offs);
                    } else {
                        buf.get(answer);
                        answerStr = type == 1 || type == 28 ? InetAddress.getByAddress(answer).getHostAddress() : DNSResponsePatcher.getReadableStringFromBinary(answer, 0, answer.length);
                    }
                    DNSResponsePatcher.trafficLog(client, clss, type, host, answerStr, len);
                }
                ++i;
            }
            return buf.array();
        }
        catch (IOException eio) {
            throw eio;
        }
        catch (Exception e) {
            throw new IOException("Invalid DNS response message structure", e);
        }
    }

    protected static boolean filter(String host, boolean log) {
        boolean result = FILTER == null ? false : FILTER.contains(host);
        if (log) {
            DNSResponsePatcher.logNstats(result, host);
        }
        return result;
    }

    protected static void trafficLog(String client, short clss, short type, String host, String answer, int length) {
        if (TRAFFIC_LOG == null) {
            return;
        }
        if (answer != null) {
            TRAFFIC_LOG.logLine(String.valueOf(client) + ", " + clss + ", A-" + type + ", " + host + ", " + answer + ", /Length:" + length);
        } else {
            TRAFFIC_LOG.logLine(String.valueOf(client) + ", " + clss + ", Q-" + type + ", " + host + ", " + "<empty>");
        }
    }

    protected static void logNstats(boolean result, String host) {
        if (result) {
            Logger.getLogger().logLine("FILTERED:" + host);
        } else {
            Logger.getLogger().logLine("ALLOWED:" + host);
        }
        if (!result) {
            ++okCnt;
        } else {
            ++filterCnt;
        }
    }

    private static boolean filterIP(String ip) {
        boolean result = FILTER == null ? false : FILTER.contains("%IP%" + ip);
        if (result) {
            Logger.getLogger().logLine("FILTERED:" + ip);
        }
        if (!result) {
            ++okCnt;
        } else {
            ++filterCnt;
        }
        return result;
    }

    protected static String readDomainName(ByteBuffer buf, int offs) throws IOException {
        byte[] substr = new byte[64];
        int count = -1;
        String dot = "";
        String result = "";
        int ptrJumpPos = -1;
        while (count != 0) {
            count = buf.get();
            if (count != 0) {
                if ((count & 0xC0) == 0) {
                    buf.get(substr, 0, count);
                    result = String.valueOf(result) + dot + new String(substr, 0, count);
                    dot = ".";
                    continue;
                }
                buf.position(buf.position() - 1);
                int pointer = offs + (buf.getShort() & 0x3FFF);
                if (ptrJumpPos == -1) {
                    ptrJumpPos = buf.position();
                }
                buf.position(pointer);
                continue;
            }
            if (count != 0 || ptrJumpPos == -1) continue;
            buf.position(ptrJumpPos);
        }
        return result;
    }

    public static String getReadableStringFromBinary(byte[] b, int offs, int r) {
        StringBuilder result = new StringBuilder();
        int i = offs;
        while (i < r) {
            if (!(b[i] < 64 && b[i] > 32 || b[i] < 91 && b[i] > 64 || b[i] < 123 && b[i] > 96)) {
                result.append('.');
            } else if (b[i] != 44 && b[i] != 59) {
                result.append((char)b[i]);
            } else {
                result.append('.');
            }
            ++i;
        }
        return result.toString();
    }
}

