/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSCommunicator;
import dnsfilter.DNSResponsePatcher;
import dnsfilter.SimpleDNSMessage;
import ip.IPPacket;
import ip.UDPPacket;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import util.ExecutionEnvironment;
import util.Logger;
import util.PatternSequence;

public class DNSResolver
implements Runnable {
    private static int THR_COUNT = 0;
    private static Object CNT_SYNC = new Object();
    private static boolean IO_ERROR = false;
    private UDPPacket udpRequestPacket;
    private OutputStream responseOut;
    private DatagramPacket dataGramRequest;
    private DatagramSocket replySocket;
    private boolean datagramPacketMode = false;
    private static boolean enableLocalResolver = false;
    private static int localResolverTTL = 0;
    private static PatternSequence customIPMappings = null;

    public static void initLocalResolver(PatternSequence customMappings, boolean enabled, int ttl) {
        customIPMappings = customMappings;
        localResolverTTL = ttl;
        enableLocalResolver = enabled;
    }

    public DNSResolver(UDPPacket udpRequestPacket, OutputStream reponseOut) {
        this.udpRequestPacket = udpRequestPacket;
        this.responseOut = reponseOut;
    }

    public DNSResolver(DatagramPacket request, DatagramSocket replySocket) {
        this.datagramPacketMode = true;
        this.dataGramRequest = request;
        this.replySocket = replySocket;
    }

    public boolean resolveLocal(String client, DatagramPacket request, DatagramPacket response) throws IOException {
        if (!enableLocalResolver) {
            return false;
        }
        SimpleDNSMessage dnsQuery = null;
        try {
            dnsQuery = new SimpleDNSMessage(request.getData(), request.getOffset(), request.getLength());
        }
        catch (Exception e) {
            if (ExecutionEnvironment.getEnvironment().debug()) {
                File dump = new File(String.valueOf(ExecutionEnvironment.getEnvironment().getWorkDir()) + "/dnsdump_" + System.currentTimeMillis());
                FileOutputStream dumpout = new FileOutputStream(dump);
                dumpout.write(request.getData(), request.getOffset(), request.getLength());
                dumpout.flush();
                dumpout.close();
            }
            Logger.getLogger().logException(e);
            throw new IOException(e);
        }
        if (!dnsQuery.isStandardQuery()) {
            return false;
        }
        Object[] info = dnsQuery.getQueryData();
        short type = (Short)info[1];
        short clss = (Short)info[2];
        if (type != 1 && type != 28) {
            return this.handle_NonTyp_1_28(client, dnsQuery, response);
        }
        String host = (String)info[0];
        byte[] ip = null;
        String prfx = ">4";
        byte[] filterIP = DNSResponsePatcher.ipv4_blocked;
        if (type == 28) {
            prfx = ">6";
            filterIP = DNSResponsePatcher.ipv6_blocked;
        }
        if (customIPMappings != null) {
            ip = (byte[])customIPMappings.match(String.valueOf(prfx) + host.toLowerCase());
        }
        if (ip == null && DNSResponsePatcher.filter(host, false)) {
            DNSResponsePatcher.logNstats(true, host);
            ip = filterIP;
        }
        if (ip != null) {
            DNSResponsePatcher.trafficLog(client, clss, type, host, null, 0);
            int length = dnsQuery.produceResponse(response.getData(), response.getOffset(), ip, localResolverTTL);
            response.setLength(length);
            String addrStr = InetAddress.getByAddress(ip).getHostAddress().toString();
            DNSResponsePatcher.trafficLog(client, clss, type, host, addrStr, ip.length);
            if (ip != filterIP) {
                Logger.getLogger().logLine("MAPPED_CUSTOM_IP: " + host + "->" + addrStr);
            }
            return true;
        }
        return false;
    }

    private boolean handle_NonTyp_1_28(String client, SimpleDNSMessage dnsQuery, DatagramPacket response) {
        String host = dnsQuery.qHost;
        if (!DNSResponsePatcher.filter(host, false)) {
            return false;
        }
        DNSResponsePatcher.trafficLog(client, dnsQuery.qClass, dnsQuery.qType, host, null, 0);
        DNSResponsePatcher.logNstats(true, host);
        int length = dnsQuery.get_NonTyp_1_28_FilterResponse(response.getData(), response.getOffset());
        response.setLength(length);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIPPackageMode() throws Exception {
        DatagramPacket response;
        int len;
        int ipOffs;
        int offs;
        int ttl = this.udpRequestPacket.getTTL();
        int[] sourceIP = this.udpRequestPacket.getSourceIP();
        int[] destIP = this.udpRequestPacket.getDestIP();
        int sourcePort = this.udpRequestPacket.getSourcePort();
        int destPort = this.udpRequestPacket.getDestPort();
        int version = this.udpRequestPacket.getVersion();
        String clientID = String.valueOf(IPPacket.int2ip(sourceIP).getHostAddress()) + ":" + sourcePort;
        int hdrLen = this.udpRequestPacket.getHeaderLength();
        byte[] packetData = this.udpRequestPacket.getData();
        DatagramPacket request = new DatagramPacket(packetData, offs = (ipOffs = this.udpRequestPacket.getIPPacketOffset()) + hdrLen, len = this.udpRequestPacket.getIPPacketLength() - hdrLen);
        if (!this.resolveLocal(clientID, request, response = new DatagramPacket(packetData, offs, packetData.length - offs))) {
            DNSCommunicator.getInstance().requestDNS(request, response);
            byte[] byArray = DNSResponsePatcher.patchResponse(clientID, response.getData(), offs);
        }
        UDPPacket udp = UDPPacket.createUDPPacket(response.getData(), ipOffs, hdrLen + response.getLength(), version);
        udp.updateHeader(ttl, 17, destIP, sourceIP);
        udp.updateHeader(destPort, sourcePort);
        OutputStream outputStream = this.responseOut;
        synchronized (outputStream) {
            this.responseOut.write(udp.getData(), udp.getIPPacketOffset(), udp.getIPPacketLength());
            this.responseOut.flush();
        }
    }

    private void processDatagramPackageMode() throws Exception {
        byte[] data;
        DatagramPacket response;
        SocketAddress sourceAdr = this.dataGramRequest.getSocketAddress();
        String clientID = sourceAdr.toString();
        if (!this.resolveLocal(clientID, this.dataGramRequest, response = new DatagramPacket(data = this.dataGramRequest.getData(), this.dataGramRequest.getOffset(), data.length - this.dataGramRequest.getOffset()))) {
            DNSCommunicator.getInstance().requestDNS(this.dataGramRequest, response);
            DNSResponsePatcher.patchResponse(clientID, response.getData(), response.getOffset());
        }
        response.setSocketAddress(sourceAdr);
        this.replySocket.send(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            try {
                Object object = CNT_SYNC;
                synchronized (object) {
                    ++THR_COUNT;
                }
                if (this.datagramPacketMode) {
                    this.processDatagramPackageMode();
                } else {
                    this.processIPPackageMode();
                }
                IO_ERROR = false;
            }
            catch (IOException e) {
                boolean hasNetwork = ExecutionEnvironment.getEnvironment().hasNetwork();
                if (!hasNetwork) {
                    Logger.getLogger().message("No network!");
                }
                String msg = e.getMessage();
                if (e.getMessage() == null) {
                    msg = e.toString();
                }
                if (ExecutionEnvironment.getEnvironment().debug()) {
                    Logger.getLogger().logLine(msg);
                } else if (!IO_ERROR && hasNetwork) {
                    Logger.getLogger().logLine(String.valueOf(msg) + "\nIO Error occured! Check network or DNS config!");
                    IO_ERROR = true;
                }
                Object object = CNT_SYNC;
                synchronized (object) {
                    --THR_COUNT;
                    break block28;
                }
            }
            catch (Exception e) {
                Object object;
                try {
                    Logger.getLogger().logException(e);
                    object = CNT_SYNC;
                }
                catch (Throwable throwable) {
                    Object object2 = CNT_SYNC;
                    synchronized (object2) {
                        --THR_COUNT;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    --THR_COUNT;
                    break block28;
                }
            }
            Object object = CNT_SYNC;
            synchronized (object) {
                --THR_COUNT;
            }
        }
    }

    public static int getResolverCount() {
        return THR_COUNT;
    }
}

