/*
 * Decompiled with CFR 0.152.
 */
package util.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import util.ExecutionEnvironment;
import util.Logger;
import util.conpool.Connection;
import util.conpool.HttpProxy;

public class DOHHttp2Util {
    private static int MAX_RETRY = 4;

    static byte[] hpackIndexed(int index) {
        return new byte[]{(byte)(0x80 | index & 0x7F)};
    }

    static byte[] hpackLiteral(String name, String value) throws IOException {
        byte[] nameBytes = name.getBytes(StandardCharsets.US_ASCII);
        byte[] valueBytes = value.getBytes(StandardCharsets.US_ASCII);
        if (nameBytes.length > 127 || valueBytes.length > 127) {
            throw new IOException("Header too long for simplified HPACK literal");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(64);
        out.write(nameBytes.length & 0x7F);
        out.write(nameBytes);
        out.write(valueBytes.length & 0x7F);
        out.write(valueBytes);
        return out.toByteArray();
    }

    static Integer hpackIndexedStatus(int index) {
        switch (index) {
            case 8: {
                return 200;
            }
            case 9: {
                return 204;
            }
            case 10: {
                return 206;
            }
            case 11: {
                return 304;
            }
            case 12: {
                return 400;
            }
            case 13: {
                return 404;
            }
            case 14: {
                return 500;
            }
        }
        return null;
    }

    static int parseHeadersStatus(byte[] block) {
        int status = -1;
        if (block == null || block.length == 0) {
            return status;
        }
        int p = 0;
        while (p < block.length) {
            int b = block[p] & 0xFF;
            if ((b & 0x80) == 0) break;
            int index = b & 0x7F;
            Integer s = DOHHttp2Util.hpackIndexedStatus(index);
            if (s != null) {
                status = s;
            }
            ++p;
        }
        if (status != -1) {
            return status;
        }
        String ascii = new String(block, StandardCharsets.US_ASCII);
        int idx = ascii.indexOf(":status");
        if (idx >= 0) {
            int i = idx + 7;
            while (i < ascii.length() && ascii.charAt(i) <= ' ') {
                ++i;
            }
            int start = i;
            while (i < ascii.length() && ascii.charAt(i) >= '0' && ascii.charAt(i) <= '9') {
                ++i;
            }
            if (start < i) {
                try {
                    status = Integer.parseInt(ascii.substring(start, i));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return status;
    }

    static byte[] buildDnsQuery(String qname, int qtype) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DOHHttp2Util.writeU16(out, 4660);
        DOHHttp2Util.writeU16(out, 256);
        DOHHttp2Util.writeU16(out, 1);
        DOHHttp2Util.writeU16(out, 0);
        DOHHttp2Util.writeU16(out, 0);
        DOHHttp2Util.writeU16(out, 0);
        String[] stringArray = qname.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            byte[] lb = label.getBytes(StandardCharsets.US_ASCII);
            out.write(lb.length);
            out.write(lb);
            ++n2;
        }
        out.write(0);
        DOHHttp2Util.writeU16(out, qtype);
        DOHHttp2Util.writeU16(out, 1);
        return out.toByteArray();
    }

    static void writeU16(ByteArrayOutputStream out, int v) {
        out.write(v >> 8 & 0xFF);
        out.write(v & 0xFF);
    }

    static int readU16(byte[] b, int off) {
        return (b[off] & 0xFF) << 8 | b[off + 1] & 0xFF;
    }

    static String readName(byte[] msg, int[] offRef) {
        int off = offRef[0];
        StringBuilder sb = new StringBuilder();
        int jumpedOff = -1;
        boolean jumped = false;
        while (true) {
            int len;
            if (((len = msg[off] & 0xFF) & 0xC0) == 192) {
                int ptr = (len & 0x3F) << 8 | msg[off + 1] & 0xFF;
                if (!jumped) {
                    jumpedOff = off + 2;
                    jumped = true;
                }
                off = ptr;
                continue;
            }
            ++off;
            if (len == 0) break;
            if (sb.length() > 0) {
                sb.append('.');
            }
            int i = 0;
            while (i < len) {
                sb.append((char)(msg[off + i] & 0xFF));
                ++i;
            }
            off += len;
        }
        offRef[0] = jumped ? jumpedOff : off;
        return sb.toString();
    }

    static List<DnsAnswer> parseDnsResponse(byte[] msg) {
        int[] o;
        ArrayList<DnsAnswer> answers = new ArrayList<DnsAnswer>();
        if (msg == null || msg.length < 12) {
            Logger.getLogger().logLine("DNS: response too short: " + (msg == null ? "null" : String.valueOf(msg.length) + " bytes"));
            return answers;
        }
        int off = 0;
        int id = DOHHttp2Util.readU16(msg, off);
        int flags = DOHHttp2Util.readU16(msg, off += 2);
        int qd = DOHHttp2Util.readU16(msg, off += 2);
        int an = DOHHttp2Util.readU16(msg, off += 2);
        int ns = DOHHttp2Util.readU16(msg, off += 2);
        int ar = DOHHttp2Util.readU16(msg, off += 2);
        off += 2;
        int rcode = flags & 0xF;
        if (an == 0) {
            Logger.getLogger().logLine("DNS: no answers. ID=" + id + " QD=" + qd + " AN=" + an + " NS=" + ns + " AR=" + ar + " RCODE=" + rcode);
        }
        int i = 0;
        while (i < qd) {
            o = new int[]{off};
            String qname = DOHHttp2Util.readName(msg, o);
            off = o[0];
            if (off + 4 > msg.length) {
                Logger.getLogger().logLine("DNS: truncated question section");
                return answers;
            }
            int qtype = DOHHttp2Util.readU16(msg, off);
            int qclass = DOHHttp2Util.readU16(msg, off += 2);
            off += 2;
            ++i;
        }
        i = 0;
        while (i < an) {
            int rdlen;
            o = new int[]{off};
            String name = DOHHttp2Util.readName(msg, o);
            off = o[0];
            if (off + 10 > msg.length) {
                Logger.getLogger().logLine("DNS: truncated answer header");
                return answers;
            }
            int type = DOHHttp2Util.readU16(msg, off);
            int clazz = DOHHttp2Util.readU16(msg, off += 2);
            int ttl = (msg[off += 2] & 0xFF) << 24 | (msg[off + 1] & 0xFF) << 16 | (msg[off + 2] & 0xFF) << 8 | msg[off + 3] & 0xFF;
            off += 4;
            if ((off += 2) + (rdlen = DOHHttp2Util.readU16(msg, off)) > msg.length) {
                Logger.getLogger().logLine("DNS: truncated RDATA (expected " + rdlen + " bytes, have " + (msg.length - off) + ")");
                rdlen = Math.max(0, msg.length - off);
            }
            byte[] rdata = new byte[rdlen];
            System.arraycopy(msg, off, rdata, 0, rdlen);
            off += rdlen;
            DnsAnswer a = new DnsAnswer();
            a.name = name;
            a.type = type;
            a.clazz = clazz;
            a.ttl = ttl;
            a.rdata = rdata;
            answers.add(a);
            ++i;
        }
        return answers;
    }

    static void writeFrameHeader(ByteArrayOutputStream out, int length, int type, int flags, int streamId) {
        out.write(length >> 16 & 0xFF);
        out.write(length >> 8 & 0xFF);
        out.write(length & 0xFF);
        out.write(type & 0xFF);
        out.write(flags & 0xFF);
        out.write(streamId >> 24 & 0x7F);
        out.write(streamId >> 16 & 0xFF);
        out.write(streamId >> 8 & 0xFF);
        out.write(streamId & 0xFF);
    }

    static void readFully(InputStream in, byte[] buf, int len) throws IOException {
        int off = 0;
        while (off < len) {
            int r = in.read(buf, off, len - off);
            if (r == -1) {
                throw new IOException("Unexpected end of stream!");
            }
            off += r;
        }
    }

    public static SSLSocket openHttp2Socket(InetSocketAddress sadr, int timeout, Proxy proxy) throws IOException {
        Socket socket = null;
        try {
            SSLContext sslContext = SSLContext.getDefault();
            if (proxy == Proxy.NO_PROXY) {
                socket = SocketChannel.open().socket();
                ExecutionEnvironment.getEnvironment().protectSocket(socket, 0);
                socket.connect(sadr, timeout);
            } else {
                if (!(proxy instanceof HttpProxy)) {
                    throw new IOException("Only " + HttpProxy.class.getName() + " supported for creating connection over tunnel!");
                }
                socket = ((HttpProxy)proxy).openTunnel(sadr, timeout, true);
            }
            SSLSocket sslsocket = (SSLSocket)sslContext.getSocketFactory().createSocket(socket, sadr.getHostName(), sadr.getPort(), true);
            SSLParameters params = sslsocket.getSSLParameters();
            params.setApplicationProtocols(new String[]{"h2"});
            sslsocket.setSSLParameters(params);
            sslsocket.startHandshake();
            String negotiated = sslsocket.getApplicationProtocol();
            if (!"h2".equals(negotiated)) {
                throw new IOException("HTTP/2 not negotiated; got: " + negotiated);
            }
            OutputStream out = sslsocket.getOutputStream();
            InputStream in = sslsocket.getInputStream();
            out.write("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
            byte[] byArray = new byte[9];
            byArray[3] = 4;
            out.write(byArray);
            out.flush();
            boolean acked = false;
            int i = 0;
            while (i < 8 && !acked) {
                byte[] header = new byte[9];
                DOHHttp2Util.readFully(in, header, 9);
                int flen = (header[0] & 0xFF) << 16 | (header[1] & 0xFF) << 8 | header[2] & 0xFF;
                int ftype = header[3] & 0xFF;
                int fflags = header[4] & 0xFF;
                int streamId = (header[5] & 0x7F) << 24 | (header[6] & 0xFF) << 16 | (header[7] & 0xFF) << 8 | header[8] & 0xFF;
                if (flen > 0) {
                    byte[] payload = new byte[flen];
                    DOHHttp2Util.readFully(in, payload, flen);
                }
                if (streamId == 0 && ftype == 4 && (fflags & 1) == 0) {
                    ByteArrayOutputStream ack = new ByteArrayOutputStream();
                    DOHHttp2Util.writeFrameHeader(ack, 0, 4, 1, 0);
                    out.write(ack.toByteArray());
                    out.flush();
                    acked = true;
                }
                ++i;
            }
            return sslsocket;
        }
        catch (IOException eio) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw eio;
        }
        catch (Exception e) {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public static byte[] sendDnsQuery(InetSocketAddress sadr, String path, byte[] dnsQuery, int offs, int length, int timeout, Proxy proxy) throws IOException {
        return DOHHttp2Util.sendDnsQuery(sadr, path, dnsQuery, offs, length, timeout, 0, proxy);
    }

    static boolean isValidDnsResponse(byte[] resp) {
        boolean qr;
        if (resp == null || resp.length < 12) {
            return false;
        }
        int flags = (resp[2] & 0xFF) << 8 | resp[3] & 0xFF;
        int qdcount = (resp[4] & 0xFF) << 8 | resp[5] & 0xFF;
        int ancount = (resp[6] & 0xFF) << 8 | resp[7] & 0xFF;
        boolean bl = qr = (flags & 0x8000) != 0;
        if (!qr) {
            return false;
        }
        int opcode = flags >> 11 & 0xF;
        if (opcode != 0) {
            return false;
        }
        if (qdcount < 1 || qdcount > 5) {
            return false;
        }
        return ancount >= 0 && ancount <= 50;
    }

    private static byte[] sendDnsQuery(InetSocketAddress sadr, String path, byte[] dnsQuery, int offs, int length, int timeout, int retryCnt, Proxy proxy) throws IOException {
        Connection con = null;
        try {
            con = Connection.connect(sadr, timeout, true, null, proxy, true);
            if (retryCnt > 0 && !con.isFresh()) {
                con.refreshConnection();
            }
            con.setSoTimeout(timeout);
            OutputStream out = con.getOutputStream();
            InputStream in = con.getInputStream();
            int streamId = con.getHttp2StreamID();
            ByteArrayOutputStream hpack = new ByteArrayOutputStream();
            hpack.write(DOHHttp2Util.hpackIndexed(3));
            hpack.write(DOHHttp2Util.hpackIndexed(7));
            hpack.write(DOHHttp2Util.hpackLiteral(":authority", sadr.getHostName()));
            hpack.write(DOHHttp2Util.hpackLiteral(":path", path));
            hpack.write(DOHHttp2Util.hpackLiteral("content-type", "application/dns-message"));
            hpack.write(DOHHttp2Util.hpackLiteral("accept", "application/dns-message"));
            hpack.write(DOHHttp2Util.hpackLiteral("content-length", Integer.toString(length)));
            byte[] headerBlock = hpack.toByteArray();
            ByteArrayOutputStream headersFrame = new ByteArrayOutputStream();
            DOHHttp2Util.writeFrameHeader(headersFrame, headerBlock.length, 1, 4, streamId);
            headersFrame.write(headerBlock);
            out.write(headersFrame.toByteArray());
            out.flush();
            ByteArrayOutputStream dataFrame = new ByteArrayOutputStream();
            DOHHttp2Util.writeFrameHeader(dataFrame, length, 0, 1, streamId);
            dataFrame.write(dnsQuery, offs, length);
            out.write(dataFrame.toByteArray());
            out.flush();
            ByteArrayOutputStream responseBody = new ByteArrayOutputStream();
            boolean done = false;
            int httpStatus = -1;
            ByteArrayOutputStream headerBlockBuf = null;
            while (!done) {
                byte[] header = new byte[9];
                DOHHttp2Util.readFully(in, header, 9);
                int flen = (header[0] & 0xFF) << 16 | (header[1] & 0xFF) << 8 | header[2] & 0xFF;
                int ftype = header[3] & 0xFF;
                int fflags = header[4] & 0xFF;
                int sid = (header[5] & 0x7F) << 24 | (header[6] & 0xFF) << 16 | (header[7] & 0xFF) << 8 | header[8] & 0xFF;
                byte[] payload = new byte[flen];
                if (flen > 0) {
                    DOHHttp2Util.readFully(in, payload, flen);
                }
                if (sid == 0 && ftype == 4) {
                    if ((fflags & 1) != 0) continue;
                    ByteArrayOutputStream ack = new ByteArrayOutputStream();
                    DOHHttp2Util.writeFrameHeader(ack, 0, 4, 1, 0);
                    out.write(ack.toByteArray());
                    out.flush();
                    continue;
                }
                if (sid == 0 || sid != streamId) continue;
                if (ftype == 1 || ftype == 9) {
                    int payloadOffset = 0;
                    if (ftype == 1 && (fflags & 0x20) != 0) {
                        if (payload.length < 5) {
                            throw new IOException("Invalid PRIORITY field in HEADERS frame");
                        }
                        payloadOffset = 5;
                    }
                    if (headerBlockBuf == null) {
                        headerBlockBuf = new ByteArrayOutputStream();
                    }
                    if (payloadOffset < payload.length) {
                        headerBlockBuf.write(payload, payloadOffset, payload.length - payloadOffset);
                    }
                    if ((fflags & 4) == 0) continue;
                    byte[] headerBlockBytes = headerBlockBuf.toByteArray();
                    headerBlockBuf = null;
                    int st = DOHHttp2Util.parseHeadersStatus(headerBlockBytes);
                    if (st != -1) {
                        httpStatus = st;
                    }
                    if (httpStatus != -1 && httpStatus != 200) {
                        throw new IOException("DoH server returned HTTP status " + httpStatus + " on stream " + streamId);
                    }
                    if ((fflags & 1) == 0) continue;
                    done = true;
                    continue;
                }
                if (ftype == 0) {
                    responseBody.write(payload);
                    int consumed = payload.length;
                    if (consumed > 0) {
                        ByteArrayOutputStream wuStream = new ByteArrayOutputStream();
                        DOHHttp2Util.writeFrameHeader(wuStream, 4, 8, 0, streamId);
                        wuStream.write(consumed >> 24 & 0xFF);
                        wuStream.write(consumed >> 16 & 0xFF);
                        wuStream.write(consumed >> 8 & 0xFF);
                        wuStream.write(consumed & 0xFF);
                        out.write(wuStream.toByteArray());
                        ByteArrayOutputStream wuConn = new ByteArrayOutputStream();
                        DOHHttp2Util.writeFrameHeader(wuConn, 4, 8, 0, 0);
                        wuConn.write(consumed >> 24 & 0xFF);
                        wuConn.write(consumed >> 16 & 0xFF);
                        wuConn.write(consumed >> 8 & 0xFF);
                        wuConn.write(consumed & 0xFF);
                        out.write(wuConn.toByteArray());
                        out.flush();
                    }
                    if ((fflags & 1) == 0) continue;
                    done = true;
                    continue;
                }
                if (ftype == 3) {
                    throw new IOException("Stream " + streamId + " reset by server");
                }
                if (ftype != 7 || sid != 0) continue;
                done = true;
                throw new IOException("HTTP/2 GOAWAY from server");
            }
            byte[] resp = responseBody.toByteArray();
            if (resp.length == 0) {
                throw new IOException("DoH: empty body, HTTP status=" + httpStatus + " on stream " + streamId);
            }
            if (!DOHHttp2Util.isValidDnsResponse(resp)) {
                throw new IOException("Received invalid DNS response from server! '" + new String(resp, 0, Math.min(100, resp.length)) + "'");
            }
            con.release(true);
            return resp;
        }
        catch (IOException e) {
            if (con != null) {
                con.release(false);
            }
            if (retryCnt < MAX_RETRY) {
                return DOHHttp2Util.sendDnsQuery(sadr, path, dnsQuery, offs, length, timeout, ++retryCnt, proxy);
            }
            throw e;
        }
    }

    private static void dumpResponse(byte[] response) {
        List<DnsAnswer> answers1 = DOHHttp2Util.parseDnsResponse(response);
        if (answers1.isEmpty()) {
            Logger.getLogger().logLine("  No answers parsed.");
        } else {
            for (DnsAnswer a : answers1) {
                Logger.getLogger().logLine("  " + a);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 443;
        String host = "dns.quad9.net";
        InetAddress iadr = InetAddress.getByName(host);
        InetSocketAddress sadr = new InetSocketAddress(iadr, port);
        int i = 0;
        while (i < 300) {
            try {
                byte[] dnsQuery = DOHHttp2Util.buildDnsQuery("www.zenz-solutions.de", 1);
                System.out.println("Results for www.zenz-solutions.de:");
                DOHHttp2Util.dumpResponse(DOHHttp2Util.sendDnsQuery(sadr, "/dns-query", dnsQuery, 0, dnsQuery.length, 0, Proxy.NO_PROXY));
                dnsQuery = DOHHttp2Util.buildDnsQuery("www.example.com", 1);
                System.out.println("Results for www.example.com:");
                DOHHttp2Util.dumpResponse(DOHHttp2Util.sendDnsQuery(sadr, "/dns-query", dnsQuery, 0, dnsQuery.length, 0, Proxy.NO_PROXY));
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
    }

    static class DnsAnswer {
        String name;
        int type;
        int clazz;
        int ttl;
        byte[] rdata;

        DnsAnswer() {
        }

        public String toString() {
            if (this.type == 1 && this.rdata != null && this.rdata.length == 4) {
                return String.valueOf(this.name) + " A " + (this.rdata[0] & 0xFF) + "." + (this.rdata[1] & 0xFF) + "." + (this.rdata[2] & 0xFF) + "." + (this.rdata[3] & 0xFF) + " TTL=" + this.ttl;
            }
            if (this.type == 28 && this.rdata != null && this.rdata.length == 16) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < 16) {
                    int seg = (this.rdata[i] & 0xFF) << 8 | this.rdata[i + 1] & 0xFF;
                    sb.append(Integer.toHexString(seg));
                    if (i < 14) {
                        sb.append(':');
                    }
                    i += 2;
                }
                return String.valueOf(this.name) + " AAAA " + sb + " TTL=" + this.ttl;
            }
            return String.valueOf(this.name) + " TYPE=" + this.type + " RDLEN=" + (this.rdata == null ? 0 : this.rdata.length) + " TTL=" + this.ttl;
        }
    }
}

