/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import util.DateRetriever;
import util.LoggerInterface;

public class FileLogger
implements LoggerInterface,
Runnable {
    private String logFolderPath;
    private String name;
    private long slotSize;
    private int slotCount;
    private String header;
    private long curSlotSize = 0L;
    private int curSlot = 0;
    private OutputStream fout = null;
    private PipedOutputStream pout;
    private PrintStream psout;
    private PipedInputStream pin;
    private boolean closed = false;
    private boolean timeStampEnabled = false;

    public FileLogger(String logFolderPath, String name, long slotSize, int slotCount, String header) throws IOException {
        if (slotSize < 1L || slotCount < 1) {
            throw new IllegalArgumentException("slotSize and slotCount must not be less than 1");
        }
        this.logFolderPath = String.valueOf(logFolderPath) + "/" + name;
        this.name = name;
        this.slotSize = slotSize;
        this.slotCount = slotCount;
        this.header = header;
        this.logOpen();
    }

    private void logOpen() throws IOException {
        File dir = new File(this.logFolderPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        long ts = 0L;
        File f = null;
        int i = 0;
        while (i < this.slotCount) {
            f = new File(String.valueOf(this.logFolderPath) + "/" + this.name + "_" + i + ".log");
            if (f.exists() && f.lastModified() > ts) {
                ts = f.lastModified();
                this.curSlotSize = f.length();
                this.curSlot = i;
            }
            ++i;
        }
        this.fout = new FileOutputStream(new File(String.valueOf(this.logFolderPath) + "/" + this.name + "_" + this.curSlot + ".log"), true);
        if (this.curSlotSize == 0L && this.header != null) {
            this.fout.write((String.valueOf(this.header) + "\r\n").getBytes());
            this.fout.flush();
        }
        this.pin = new PipedInputStream(10240);
        this.pout = new PipedOutputStream(this.pin);
        this.psout = new PrintStream(this.pout, true);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeLogger() {
        PipedInputStream pipedInputStream = this.pin;
        synchronized (pipedInputStream) {
            try {
                this.closed = true;
                this.pout.close();
                this.fout.close();
                this.pin.notifyAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void enableTimestamp(boolean enable) {
        this.timeStampEnabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logLine(String txt) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                this.psout.println(txt);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(Exception e) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                e.printStackTrace(this.psout);
                this.pin.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String txt) {
        PrintStream printStream = this.psout;
        synchronized (printStream) {
            PipedInputStream pipedInputStream = this.pin;
            synchronized (pipedInputStream) {
                if (this.timeStampEnabled) {
                    this.psout.print(String.valueOf(DateRetriever.getDateString()) + " ");
                }
                this.psout.print(txt);
                this.pin.notifyAll();
            }
        }
    }

    @Override
    public void message(String txt) {
        this.log(txt);
    }

    private OutputStream getOutputStream() throws IOException {
        if (this.curSlotSize < this.slotSize) {
            return this.fout;
        }
        this.fout.flush();
        this.fout.close();
        this.curSlot = (this.curSlot + 1) % this.slotCount;
        File f = new File(String.valueOf(this.logFolderPath) + "/" + this.name + "_" + this.curSlot + ".log");
        this.fout = new FileOutputStream(f);
        this.curSlotSize = 0L;
        if (this.header != null) {
            this.fout.write((String.valueOf(this.header) + "\r\n").getBytes());
            this.fout.flush();
        }
        return this.fout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] buf = new byte[2048];
        int r = 0;
        int avail = 0;
        while (!this.closed) {
            try {
                block12: {
                    PipedInputStream pipedInputStream = this.pin;
                    synchronized (pipedInputStream) {
                        while (true) {
                            while (true) {
                                if ((avail = this.pin.available()) > 0 || this.closed) {
                                    if (!this.closed) {
                                        r = this.pin.read(buf);
                                    }
                                    break block12;
                                }
                                try {
                                    this.pin.wait();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (this.closed) continue;
                OutputStream out = this.getOutputStream();
                out.write(buf, 0, r);
                this.curSlotSize += (long)r;
                if (avail != r) continue;
                out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

