/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter.remote;

import dnsfilter.ConfigurationAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import util.Encryption;
import util.Logger;
import util.LoggerInterface;
import util.TimeoutListener;
import util.TimoutNotificator;
import util.Utils;

public class RemoteAccessClient
extends ConfigurationAccess
implements TimeoutListener {
    static int CON_TIMEOUT = 15000;
    static int READ_TIMEOUT = 15000;
    static final int LOG = 1;
    static final int LOG_LN = 2;
    static final int LOG_MSG = 3;
    static final int UPD_DNS = 4;
    static final int UPD_CON_CNT = 5;
    static final int HEART_BEAT = 6;
    public static final int INVALIDATE = 7;
    private String host;
    private int port;
    private Socket ctrlcon;
    private InputStream in;
    private OutputStream out;
    private int ctrlConId = -1;
    private RemoteStream remoteStream;
    private String remote_version;
    private String last_dns = "<unknown>";
    private int con_cnt = -1;
    private LoggerInterface connectedLogger;
    boolean valid = false;
    long timeout = Long.MAX_VALUE;
    int timeOutCounter = 0;

    public RemoteAccessClient(LoggerInterface logger, String host, int port, String keyphrase) throws IOException {
        if (logger == null) {
            logger = Logger.getLogger();
        }
        this.connectedLogger = logger;
        Encryption.init_AES(keyphrase);
        this.host = host;
        this.port = port;
        this.connect();
    }

    private void connect() throws IOException {
        Object[] conInfo = this.initConnection();
        this.ctrlcon = (Socket)conInfo[1];
        this.in = (InputStream)conInfo[2];
        this.out = (OutputStream)conInfo[3];
        this.ctrlcon.setSoTimeout(READ_TIMEOUT);
        this.ctrlConId = (Integer)conInfo[0];
        this.remoteStream = new RemoteStream(this.ctrlConId);
        this.valid = true;
    }

    @Override
    public String toString() {
        return "REMOTE -> " + this.host + ":" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionReconnect() {
        Object sync;
        TimoutNotificator.getInstance().unregister(this);
        if (!this.valid) {
            return;
        }
        this.releaseConfiguration();
        Object object = sync = new Object();
        synchronized (object) {
            try {
                sync.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            this.connect();
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Reconnect failed:" + e.toString());
            this.valid = false;
        }
    }

    private Object[] initConnection() throws IOException {
        Socket con = null;
        try {
            int id = -1;
            con = new Socket();
            con.connect(new InetSocketAddress(InetAddress.getByName(this.host), this.port), CON_TIMEOUT);
            con.setSoTimeout(READ_TIMEOUT);
            OutputStream out = Encryption.getEncryptedOutputStream(con.getOutputStream(), 1024);
            InputStream in = Encryption.getDecryptedStream(con.getInputStream());
            out.write("1505900\nnew_session\n".getBytes());
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new IOException(response);
            }
            try {
                id = Integer.parseInt(Utils.readLineFromStream(in));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            this.remote_version = Utils.readLineFromStream(in);
            this.last_dns = Utils.readLineFromStream(in);
            try {
                this.con_cnt = Integer.parseInt(Utils.readLineFromStream(in));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            con.setSoTimeout(0);
            return new Object[]{id, con, in, out};
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Exception during initConnection(): " + e.toString());
            if (con != null) {
                Utils.closeSocket(con);
            }
            throw e;
        }
    }

    private InputStream getInputStream() throws IOException {
        if (!this.valid) {
            throw new IOException("Not connected!");
        }
        return this.in;
    }

    private OutputStream getOutputStream() throws IOException {
        if (!this.valid) {
            throw new IOException("Not connected!");
        }
        return this.out;
    }

    private void triggerAction(String action, String paramStr) throws IOException {
        try {
            this.getOutputStream().write((String.valueOf(action) + "\n").getBytes());
            if (paramStr != null) {
                this.getOutputStream().write((String.valueOf(paramStr) + "\n").getBytes());
            }
            this.getOutputStream().flush();
            InputStream in = this.getInputStream();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action " + action + " failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public void releaseConfiguration() {
        TimoutNotificator.getInstance().unregister(this);
        this.valid = false;
        if (this.remoteStream != null) {
            this.remoteStream.close();
        }
        if (this.ctrlcon != null) {
            try {
                this.out.write("releaseConfiguration()".getBytes());
                this.out.flush();
            }
            catch (IOException e) {
                this.connectedLogger.logLine("Exception during remote configuration release: " + e.toString());
                Utils.closeSocket(this.ctrlcon);
            }
        }
        this.ctrlcon = null;
        this.remoteStream = null;
        REMOTE = null;
    }

    @Override
    public Properties getConfig() throws IOException {
        try {
            this.getOutputStream().write("getConfig()\n".getBytes());
            this.getOutputStream().flush();
            InputStream in = this.getInputStream();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
            try {
                return (Properties)new ObjectInputStream(in).readObject();
            }
            catch (ClassNotFoundException e) {
                this.connectedLogger.logException(e);
                throw new IOException(e);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action getConfig() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public Properties getDefaultConfig() throws IOException {
        try {
            this.getOutputStream().write("getDefaultConfig()\n".getBytes());
            this.getOutputStream().flush();
            InputStream in = this.getInputStream();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
            try {
                return (Properties)new ObjectInputStream(in).readObject();
            }
            catch (ClassNotFoundException e) {
                this.connectedLogger.logException(e);
                throw new IOException(e);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            this.connectedLogger.message("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action getConfig() failed! " + e.getMessage());
            this.connectedLogger.message("Remote action getConfig() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public byte[] readConfig() throws IOException {
        try {
            this.getOutputStream().write("readConfig()\n".getBytes());
            this.getOutputStream().flush();
            DataInputStream in = new DataInputStream(this.getInputStream());
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
            byte[] buf = new byte[in.readInt()];
            in.readFully(buf);
            return buf;
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action readConfig() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public void updateConfig(byte[] config) throws IOException {
        try {
            this.invalidate();
            InputStream in = this.getInputStream();
            DataOutputStream out = new DataOutputStream(this.getOutputStream());
            out.write("updateConfig()\n".getBytes());
            out.writeInt(config.length);
            out.write(config);
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action updateConfig() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public void updateConfigMergeDefaults(byte[] config) throws IOException {
        try {
            this.invalidate();
            InputStream in = this.getInputStream();
            DataOutputStream out = new DataOutputStream(this.getOutputStream());
            out.write("updateConfigMergeDefaults()\n".getBytes());
            out.writeInt(config.length);
            out.write(config);
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action updateConfig() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public byte[] getAdditionalHosts(int limit) throws IOException {
        try {
            DataOutputStream out = new DataOutputStream(this.getOutputStream());
            DataInputStream in = new DataInputStream(this.getInputStream());
            out.write("getAdditionalHosts()\n".getBytes());
            out.writeInt(limit);
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
            byte[] result = new byte[in.readInt()];
            in.readFully(result);
            return result;
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action getAdditionalHosts() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public void updateAdditionalHosts(byte[] bytes) throws IOException {
        try {
            DataOutputStream out = new DataOutputStream(this.getOutputStream());
            DataInputStream in = new DataInputStream(this.getInputStream());
            out.write("updateAdditionalHosts()\n".getBytes());
            out.writeInt(bytes.length);
            out.write(bytes);
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action updateAdditionalHosts() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public void updateFilter(String entries, boolean filter) throws IOException {
        try {
            OutputStream out = this.getOutputStream();
            InputStream in = this.getInputStream();
            out.write(("updateFilter()\n" + entries.replace("\n", ";") + "\n" + filter + "\n").getBytes());
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action  updateFilter() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public String getVersion() throws IOException {
        return this.remote_version;
    }

    @Override
    public int openConnectionsCount() {
        return this.con_cnt;
    }

    @Override
    public String getLastDNSAddress() {
        return this.last_dns;
    }

    @Override
    public void restart() throws IOException {
        this.triggerAction("restart()", null);
        this.invalidate();
    }

    @Override
    public void stop() throws IOException {
        this.triggerAction("stop()", null);
    }

    @Override
    public long[] getFilterStatistics() throws IOException {
        try {
            DataOutputStream out = new DataOutputStream(this.getOutputStream());
            DataInputStream in = new DataInputStream(this.getInputStream());
            out.write("getFilterStatistics()\n".getBytes());
            out.flush();
            String response = Utils.readLineFromStream(in);
            if (!response.equals("OK")) {
                throw new ConfigurationAccess.ConfigurationAccessException(response, null);
            }
            return new long[]{in.readLong(), in.readLong()};
        }
        catch (ConfigurationAccess.ConfigurationAccessException e) {
            this.connectedLogger.logLine("Remote action failed! " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            this.connectedLogger.logLine("Remote action  getFilterStatistics() failed! " + e.getMessage());
            this.closeConnectionReconnect();
            throw e;
        }
    }

    @Override
    public void triggerUpdateFilter() throws IOException {
        this.triggerAction("triggerUpdateFilter()", null);
    }

    @Override
    public void doBackup(OutputStream backupout) throws IOException {
        DataOutputStream out = new DataOutputStream(this.getOutputStream());
        DataInputStream in = new DataInputStream(this.getInputStream());
        out.write("doBackup()\n".getBytes());
        out.flush();
        String response = Utils.readLineFromStream(in);
        if (!response.equals("OK")) {
            throw new ConfigurationAccess.ConfigurationAccessException(response, null);
        }
        byte[] buf = new byte[in.readInt()];
        in.readFully(buf);
        backupout.write(buf);
        backupout.flush();
        backupout.close();
    }

    @Override
    public void doRestoreDefaults() throws IOException {
        this.invalidate();
        this.triggerAction("doRestoreDefaults()", null);
    }

    @Override
    public void doRestore(InputStream backup) throws IOException {
        this.invalidate();
        DataOutputStream out = new DataOutputStream(this.getOutputStream());
        DataInputStream in = new DataInputStream(this.getInputStream());
        out.write("doRestore()\n".getBytes());
        byte[] backupData = Utils.readFully(backup, 1024);
        out.writeInt(backupData.length);
        out.write(backupData);
        out.flush();
        String response = Utils.readLineFromStream(in);
        if (!response.equals("OK")) {
            throw new ConfigurationAccess.ConfigurationAccessException(response, null);
        }
    }

    @Override
    public void wakeLock() throws IOException {
        this.triggerAction("wakeLock()", null);
    }

    @Override
    public void releaseWakeLock() throws IOException {
        this.triggerAction("releaseWakeLock()", null);
    }

    private void processHeartBeat() {
        this.connectedLogger.message("Heart Beat!");
        this.timeOutCounter = 0;
        this.setTimeout(READ_TIMEOUT);
    }

    private void setTimeout(int timeout) {
        this.timeout = System.currentTimeMillis() + (long)timeout;
        TimoutNotificator.getInstance().register(this);
    }

    @Override
    public void timeoutNotification() {
        ++this.timeOutCounter;
        if (this.timeOutCounter == 2) {
            this.connectedLogger.message("Remote Session is Dead!");
            this.connectedLogger.logLine("Remote Session is Dead! - Closing...!");
            this.timeOutCounter = 0;
            this.closeConnectionReconnect();
        } else {
            this.setTimeout(READ_TIMEOUT);
        }
    }

    @Override
    public long getTimoutTime() {
        return this.timeout;
    }

    private class RemoteStream
    implements Runnable {
        Socket streamCon;
        int streamConId;
        boolean stopped = false;
        DataInputStream in;
        DataOutputStream out;

        public RemoteStream(int ctrlSession) throws IOException {
            Object[] conInfo = RemoteAccessClient.this.initConnection();
            this.streamCon = (Socket)conInfo[1];
            this.in = new DataInputStream((InputStream)conInfo[2]);
            this.out = new DataOutputStream((OutputStream)conInfo[3]);
            this.streamConId = (Integer)conInfo[0];
            try {
                this.out.write(("attach\n" + ctrlSession + "\n").getBytes());
                this.out.flush();
                String response = Utils.readLineFromStream(this.in);
                if (!response.equals("OK")) {
                    throw new IOException(response);
                }
            }
            catch (IOException e) {
                RemoteAccessClient.this.connectedLogger.logLine("Remote action attach Remote Stream failed! " + e.getMessage());
                RemoteAccessClient.this.closeConnectionReconnect();
                throw e;
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            block12: {
                byte[] msg = new byte[2048];
                try {
                    while (!this.stopped) {
                        short type = this.in.readShort();
                        short len = this.in.readShort();
                        msg = this.getBuffer(msg, len, 2048, 1024000);
                        this.in.readFully(msg, 0, len);
                        switch (type) {
                            case 2: {
                                RemoteAccessClient.this.connectedLogger.logLine(new String(msg, 0, (int)len));
                                break;
                            }
                            case 1: {
                                RemoteAccessClient.this.connectedLogger.log(new String(msg, 0, (int)len));
                                break;
                            }
                            case 3: {
                                RemoteAccessClient.this.connectedLogger.message(new String(msg, 0, (int)len));
                                break;
                            }
                            case 4: {
                                RemoteAccessClient.this.last_dns = new String(msg, 0, (int)len);
                                break;
                            }
                            case 5: {
                                RemoteAccessClient.this.con_cnt = Integer.parseInt(new String(msg, 0, (int)len));
                                break;
                            }
                            case 6: {
                                RemoteAccessClient.this.processHeartBeat();
                                this.confirmHeartBeat();
                                break;
                            }
                            case 7: {
                                RemoteAccessClient.this.invalidate();
                                break;
                            }
                            default: {
                                throw new IOException("Unknown message type: " + type);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    if (this.stopped) break block12;
                    RemoteAccessClient.this.connectedLogger.logLine("Exception during RemoteStream read! " + e.toString());
                    RemoteAccessClient.this.closeConnectionReconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void confirmHeartBeat() {
            try {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.write("confirmHeartBeat()\n".getBytes());
                    this.out.flush();
                }
            }
            catch (IOException e) {
                RemoteAccessClient.this.connectedLogger.logLine("Exception during confirmHeartBeat()! " + e.toString());
                RemoteAccessClient.this.closeConnectionReconnect();
            }
        }

        private byte[] getBuffer(byte[] msg, int len, int initLen, int maxLen) throws IOException {
            if (len < initLen && msg.length > initLen) {
                return new byte[initLen];
            }
            if (len < initLen) {
                return msg;
            }
            if (len > maxLen) {
                throw new IOException("Buffer Overflow: " + len + " bytes!");
            }
            return new byte[len];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.stopped = true;
            if (this.streamCon != null) {
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    try {
                        this.out.write("releaseConfiguration()".getBytes());
                        this.out.flush();
                    }
                    catch (IOException e) {
                        RemoteAccessClient.this.connectedLogger.logLine("Exception during remote configuration release: " + e.toString());
                    }
                    Utils.closeSocket(this.streamCon);
                }
            }
        }
    }
}

