/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSServer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import util.http.DOHHttp2Util;
import util.http.HttpHeader;

class DoH2
extends DNSServer {
    String url;
    String path;
    String urlHost;
    InetSocketAddress urlHostAddress;

    protected DoH2(InetAddress address, int port, int timeout, String url) throws IOException {
        super(address, port, timeout);
        if (url == null) {
            throw new IOException("Endpoint URL not defined for DNS over HTTPS (DoH)!");
        }
        this.url = url;
        this.parseURL();
        this.urlHostAddress = new InetSocketAddress(InetAddress.getByAddress(this.urlHost, address.getAddress()), port);
    }

    private void parseURL() throws IOException {
        HttpHeader helper = new HttpHeader(1);
        helper.setRequest("POST " + this.url + " " + "HTTP/1.1");
        this.path = helper.url;
        this.urlHost = helper.remote_host_name;
    }

    @Override
    public String getProtocolName() {
        return "DOH";
    }

    @Override
    public void resolve(DatagramPacket request, DatagramPacket response) throws IOException {
        try {
            byte[] dnsReply = new byte[]{};
            dnsReply = DOHHttp2Util.sendDnsQuery(this.urlHostAddress, this.path, request.getData(), request.getOffset(), request.getLength(), this.timeout, proxy);
            this.readResponseFromStream(new DataInputStream(new ByteArrayInputStream(dnsReply)), dnsReply.length, response);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

