/*
 * Decompiled with CFR 0.152.
 */
package dnsfilter;

import dnsfilter.DNSServer;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import util.conpool.Connection;
import util.http.HttpChunkedInputStream;
import util.http.HttpHeader;

class DoH
extends DNSServer {
    String url;
    String urlHost;
    String reqTemplate;
    InetSocketAddress urlHostAddress;

    protected DoH(InetAddress address, int port, int timeout, String url) throws IOException {
        super(address, port, timeout);
        if (url == null) {
            throw new IOException("Endpoint URL not defined for DNS over HTTPS (DoH)!");
        }
        this.url = url;
        this.buildTemplate();
        this.urlHostAddress = new InetSocketAddress(InetAddress.getByAddress(this.urlHost, address.getAddress()), port);
    }

    @Override
    public String getProtocolName() {
        return "DOH";
    }

    private void buildTemplate() throws IOException {
        String user_agent = "Mozilla/5.0 (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + ")";
        HttpHeader REQ_TEMPLATE = new HttpHeader(1);
        REQ_TEMPLATE.setValue("User-Agent", user_agent);
        REQ_TEMPLATE.setValue("Accept", "application/dns-message");
        REQ_TEMPLATE.setValue("content-type", "application/dns-message");
        REQ_TEMPLATE.setValue("Connection", "keep-alive");
        REQ_TEMPLATE.setRequest("POST " + this.url + " " + "HTTP/1.1");
        REQ_TEMPLATE.setValue("Content-Length", "999");
        this.reqTemplate = REQ_TEMPLATE.getServerRequestHeader(false);
        this.urlHost = REQ_TEMPLATE.remote_host_name;
    }

    private byte[] buildRequestHeader(int length) throws IOException {
        return this.reqTemplate.replace("\nContent-Length: 999", "\nContent-Length: " + length).getBytes();
    }

    @Override
    public void resolve(DatagramPacket request, DatagramPacket response) throws IOException {
        byte[] reqHeader = this.buildRequestHeader(request.getLength());
        Connection con = Connection.connect(this.urlHostAddress, this.timeout, true, null, proxy, false);
        con.setSoTimeout(this.timeout);
        int i = 0;
        while (i < 2) {
            try {
                OutputStream out = con.getOutputStream();
                InputStream in = con.getInputStream();
                out.write(reqHeader);
                out.write(request.getData(), request.getOffset(), request.getLength());
                out.flush();
                HttpHeader responseHeader = new HttpHeader(in, 2);
                if (responseHeader.getResponseCode() != 200) {
                    throw new IOException("DoH failed for " + this.url + "! " + responseHeader.getResponseCode() + " - " + responseHeader.getResponseMessage());
                }
                boolean reuse = true;
                int size = (int)responseHeader.getContentLength();
                if (size == -1) {
                    if (responseHeader.chunkedTransfer()) {
                        in = new HttpChunkedInputStream(in);
                    } else {
                        reuse = false;
                    }
                    int r = 0;
                    size = 0;
                    byte[] buf = new byte[maxBufSize];
                    while ((r = in.read(buf, size, buf.length - size)) != -1) {
                        if ((size += r) != maxBufSize) continue;
                        throw new IOException("Buffer to small!");
                    }
                    in = new ByteArrayInputStream(buf, 0, size);
                }
                this.readResponseFromStream(new DataInputStream(in), size, response);
                response.setSocketAddress(this.address);
                con.release(reuse && !responseHeader.getConnectionClose());
                return;
            }
            catch (EOFException eof) {
                if (i == 0) {
                    con.refreshConnection();
                }
                con.release(false);
                throw new IOException("EOF when reading from " + this.toString(), eof);
            }
            catch (IOException eio) {
                con.release(false);
                throw eio;
            }
            ++i;
        }
    }
}

