/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketTimeoutException;
import util.PipedSocketOutputStream;

public class PipedSocketInputStream
extends PipedInputStream {
    int timeout = 0;
    PipedSocketOutputStream pout;
    Object monitor = new Object();
    boolean open = true;

    public void setTimeout(int to) {
        this.timeout = to;
    }

    @Override
    public void connect(PipedOutputStream pout) throws IOException {
        this.pout = (PipedSocketOutputStream)pout;
        this.pout.pin = this;
        super.connect(pout);
    }

    private void waitForData() throws IOException, SocketTimeoutException {
        long millis = System.currentTimeMillis();
        while (super.available() == 0 && this.open && this.pout.open) {
            try {
                this.monitor.wait(this.timeout);
                if (this.available() != 0 || this.timeout <= 0 || System.currentTimeMillis() - millis < (long)this.timeout) continue;
                throw new SocketTimeoutException("PipedSocket timeout reached - " + this.timeout);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.waitForData();
            int r = super.read();
            if (r == -1) {
                this.open = false;
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf, int offs, int len) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.waitForData();
            int r = super.read(buf, offs, len);
            if (r == -1) {
                this.open = false;
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf) throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            this.waitForData();
            int r = super.read(buf);
            if (r == -1) {
                this.open = false;
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            super.close();
            this.open = false;
            this.monitor.notifyAll();
        }
    }
}

