/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Vector;
import udpproxy.UDPServerProxy;
import udpproxy.UDPSession;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;

public class UDPProxy
implements Runnable,
TimeoutListener {
    DatagramSocket listenerSocket = null;
    protected String remoteHost;
    protected int remotePort;
    protected boolean debug;
    private boolean ASYNC = false;
    private boolean stopped = false;
    protected int receivebuffer = 5096;
    protected int timeout = 60000;
    protected int pooltime = 0;
    private HashMap sessions = new HashMap();
    private Vector connectionPool = new Vector();
    private int idleProxyTimeOut = 0;
    private TimoutNotificator toNotify = TimoutNotificator.getInstance();
    private TimeoutTime timeoutObj = new TimeoutTime(this.toNotify);
    private UDPServerProxy udpSrvProxy = null;

    private UDPProxy() {
    }

    protected UDPProxy(DatagramSocket listener, String remoteHost, int remotePort, int receivebuffer, int timeout, boolean debug, boolean ASYNC, UDPServerProxy udpSrvProxy) {
        this.listenerSocket = listener;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.receivebuffer = receivebuffer;
        this.timeout = timeout;
        this.pooltime = 0;
        this.idleProxyTimeOut = timeout;
        this.debug = debug;
        this.ASYNC = ASYNC;
        this.udpSrvProxy = udpSrvProxy;
    }

    public static void main(String[] args) throws Exception {
        UDPProxy proxy = new UDPProxy();
        proxy.initMainLoop(args);
    }

    @Override
    public void run() {
        this.runListenerLoop();
    }

    private void runListenerLoop() {
        if (this.udpSrvProxy != null) {
            this.toNotify.register(this);
            this.timeoutObj.setTimeout(this.idleProxyTimeOut);
        }
        while (!this.stopped) {
            try {
                DatagramPacket receivePacket = new DatagramPacket(new byte[this.receivebuffer], this.receivebuffer);
                this.listenerSocket.receive(receivePacket);
                UDPSession session = this.getSession(receivePacket);
                session.dispatch(receivePacket);
            }
            catch (IOException ioe) {
                if (this.stopped) {
                    return;
                }
                Logger.getLogger().logException(ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDPSession getSession(DatagramPacket receivePacket) throws IOException {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            InetAddress adr = receivePacket.getAddress();
            int port = receivePacket.getPort();
            UDPSession session = (UDPSession)this.sessions.get(String.valueOf(adr.getHostAddress()) + ":" + port);
            if (session == null) {
                if (this.pooltime != 0 && this.connectionPool.size() > 0 && (session = (UDPSession)this.connectionPool.remove(this.connectionPool.size() - 1)) != null) {
                    session.setUnPooled(adr, port);
                }
                if (session == null) {
                    session = new UDPSession(adr, port, this);
                }
                this.sessions.put(String.valueOf(adr.getHostAddress()) + ":" + port, session);
                this.timeoutObj.setTimeout(0L);
                Logger.getLogger().logLine("New UDP Session:" + session);
            }
            return session;
        }
    }

    private void initMainLoop(String[] args) throws Exception {
        try {
            boolean localOnly = !args[0].equalsIgnoreCase("LocalOnly=false");
            Logger.getLogger().logLine("Setting: " + args[0]);
            if (localOnly) {
                Logger.getLogger().logLine("Only localhost Connections to Proxy will be accepted");
            } else {
                Logger.getLogger().logLine("Remote Connections to Proxy will be accepted");
            }
            this.listenerSocket = this.openListener(localOnly, Integer.parseInt(args[1]));
            Logger.getLogger().logLine("Proxy main: serverSocket created on port " + this.listenerSocket.getLocalPort());
            this.remoteHost = args[2];
            this.remotePort = Integer.parseInt(args[3]);
            this.timeout = Integer.parseInt(args[4]);
            this.pooltime = Integer.parseInt(args[5]);
            this.receivebuffer = Integer.parseInt(args[6]);
            this.debug = args.length >= 8 ? args[7].equals("debug") : false;
            if (!this.ASYNC) {
                this.runListenerLoop();
            } else {
                new Thread(this).start();
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Proxy main:" + e.toString());
            throw e;
        }
    }

    protected DatagramSocket openListener(boolean localOnly, int port) throws IOException {
        String host = "0.0.0.0";
        if (localOnly) {
            host = "127.0.0.1";
        }
        InetAddress adress = InetAddress.getByName(host);
        return new DatagramSocket(port, adress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(UDPSession udpSession) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(String.valueOf(udpSession.getClientAddress().getHostAddress()) + ":" + udpSession.getClientPort());
            if (this.sessions.size() == 0) {
                this.timeoutObj.setTimeout(this.idleProxyTimeOut);
            }
        }
        if (this.pooltime != 0) {
            udpSession.setPooled();
            hashMap = this.sessions;
            synchronized (hashMap) {
                this.connectionPool.add(udpSession);
            }
        } else {
            udpSession.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPooledSession(UDPSession udpSession) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.connectionPool.remove(udpSession);
        }
        udpSession.closeSession();
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.sessions.size() == 0) {
            this.timeoutObj.setTimeout(this.idleProxyTimeOut);
        }
        this.listenerSocket.send(p);
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.toNotify.unregister(this);
        this.stopped = true;
        if (this.listenerSocket != null) {
            this.listenerSocket.close();
        }
    }

    @Override
    public void timeoutNotification() {
        this.udpSrvProxy.closeSession(this);
    }

    @Override
    public long getTimoutTime() {
        return this.timeoutObj.getTimeout();
    }
}

