/*
 * Decompiled with CFR 0.152.
 */
package socks.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.DatagramPacket;
import java.net.Socket;
import socks.ProxyMessage;
import socks.UDPEncapsulation;
import socks.server.ServerAuthenticator;

public class ServerAuthenticatorNone
implements ServerAuthenticator {
    static final byte[] socks5response;
    InputStream in;
    OutputStream out;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 5;
        socks5response = byArray;
    }

    public ServerAuthenticatorNone() {
        this.in = null;
        this.out = null;
    }

    public ServerAuthenticatorNone(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    @Override
    public ServerAuthenticator startSession(Socket s) throws IOException {
        PushbackInputStream in = new PushbackInputStream(s.getInputStream());
        OutputStream out = s.getOutputStream();
        int version = in.read();
        if (version == 5) {
            if (!ServerAuthenticatorNone.selectSocks5Authentication(in, out, 0)) {
                return null;
            }
        } else if (version == 4) {
            in.unread(version);
        } else {
            return null;
        }
        return new ServerAuthenticatorNone(in, out);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public UDPEncapsulation getUdpEncapsulation() {
        return null;
    }

    @Override
    public boolean checkRequest(ProxyMessage msg) {
        return true;
    }

    @Override
    public boolean checkRequest(DatagramPacket dp, boolean out) {
        return true;
    }

    @Override
    public void endSession() {
    }

    public static boolean selectSocks5Authentication(InputStream in, OutputStream out, int methodId) throws IOException {
        int num_methods = in.read();
        if (num_methods <= 0) {
            return false;
        }
        byte[] method_ids = new byte[num_methods];
        byte[] response = new byte[2];
        boolean found = false;
        response[0] = 5;
        response[1] = -1;
        int bread = 0;
        while (bread < num_methods) {
            bread += in.read(method_ids, bread, num_methods - bread);
        }
        int i = 0;
        while (i < num_methods) {
            if (method_ids[i] == methodId) {
                found = true;
                response[1] = (byte)methodId;
                break;
            }
            ++i;
        }
        out.write(response);
        return found;
    }
}

