/*
 * Decompiled with CFR 0.152.
 */
package socks;

import java.io.IOException;

public class SocksException
extends IOException {
    static final String UNASSIGNED_ERROR_MESSAGE = "Unknown error message";
    static final String[] serverReplyMessage = new String[]{"Succeeded", "General SOCKS server failure", "Connection not allowed by ruleset", "Network unreachable", "Host unreachable", "Connection refused", "TTL expired", "Command not supported", "Address type not supported"};
    static final String[] localErrorMessage = new String[]{"SOCKS server not specified", "Unable to contact SOCKS server", "IO error", "None of Authentication methods are supported", "Authentication failed", "General SOCKS fault"};
    String errString;
    int errCode;

    public SocksException(int errCode) {
        this.errCode = errCode;
        this.errString = errCode >> 16 == 0 ? (errCode <= serverReplyMessage.length ? serverReplyMessage[errCode] : UNASSIGNED_ERROR_MESSAGE) : ((errCode = (errCode >> 16) - 1) <= localErrorMessage.length ? localErrorMessage[errCode] : UNASSIGNED_ERROR_MESSAGE);
    }

    public SocksException(int errCode, String errString) {
        this.errCode = errCode;
        this.errString = errString;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    @Override
    public String toString() {
        return this.errString;
    }
}

