/*
 * Decompiled with CFR 0.152.
 */
package socks;

import httptunnel.HttpTunnelConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import socks.CProxy;
import socks.ProxyMessage;
import socks.Socks4Message;
import socks.Socks5Message;
import socks.SocksException;
import socks.SocksServerSocket;
import socks.SocksSocket;
import socks.UDPRelayServer;
import socks.server.ServerAuthenticator;

public class ProxyServer
implements Runnable {
    ServerAuthenticator auth;
    ProxyMessage msg = null;
    Socket sock = null;
    Socket remote_sock = null;
    ServerSocket ss = null;
    UDPRelayServer relayServer = null;
    InputStream in;
    InputStream remote_in;
    OutputStream out;
    OutputStream remote_out;
    int mode;
    static final int START_MODE = 0;
    static final int ACCEPT_MODE = 1;
    static final int PIPE_MODE = 2;
    static final int ABORT_MODE = 3;
    static final int BUF_SIZE = 8192;
    Thread pipe_thread1;
    Thread pipe_thread2;
    long lastReadTime;
    static int iddleTimeout = 180000;
    static int acceptTimeout = 180000;
    static PrintStream log = null;
    static CProxy proxy;
    static final String[] command_names;

    static {
        command_names = new String[]{"CONNECT", "BIND", "UDP_ASSOCIATE"};
    }

    public ProxyServer(ServerAuthenticator auth) {
        this.auth = auth;
    }

    ProxyServer(ServerAuthenticator auth, Socket s) {
        this.auth = auth;
        this.sock = s;
        this.mode = 0;
    }

    public static void setLog(OutputStream out) {
        log = out == null ? null : new PrintStream(out, true);
        UDPRelayServer.log = log;
    }

    public static void setProxy(CProxy p) {
        UDPRelayServer.proxy = proxy = p;
    }

    public static CProxy getProxy() {
        return proxy;
    }

    public static void setIddleTimeout(int timeout) {
        iddleTimeout = timeout;
    }

    public static void setAcceptTimeout(int timeout) {
        acceptTimeout = timeout;
    }

    public static void setUDPTimeout(int timeout) {
        UDPRelayServer.setTimeout(timeout);
    }

    public static void setDatagramSize(int size) {
        UDPRelayServer.setDatagramSize(size);
    }

    public void start(int port) {
        this.start(port, 5, null);
    }

    public void start(int port, int backlog, InetAddress localIP) {
        try {
            this.ss = new ServerSocket(port, backlog, localIP);
            ProxyServer.log("Starting SOCKS Proxy on:" + this.ss.getInetAddress().getHostAddress() + ":" + this.ss.getLocalPort());
            while (true) {
                Socket s = this.ss.accept();
                ProxyServer.log("Accepted from:" + s.getInetAddress().getHostName() + ":" + s.getPort());
                ProxyServer ps = new ProxyServer(this.auth, s);
                new Thread(ps).start();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    public void stop() {
        try {
            if (this.ss != null) {
                this.ss.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        switch (this.mode) {
            case 0: {
                try {
                    try {
                        this.startSession();
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                        this.abort();
                        if (this.auth != null) {
                            this.auth.endSession();
                        }
                        ProxyServer.log("Main thread(client->remote)stopped.");
                    }
                    break;
                }
                finally {
                    this.abort();
                    if (this.auth != null) {
                        this.auth.endSession();
                    }
                    ProxyServer.log("Main thread(client->remote)stopped.");
                }
            }
            case 1: {
                try {
                    try {
                        this.doAccept();
                        this.mode = 2;
                        this.pipe_thread1.interrupt();
                        this.pipe(this.remote_in, this.out);
                    }
                    catch (IOException ioe) {
                        this.handleException(ioe);
                        this.abort();
                        ProxyServer.log("Accept thread(remote->client) stopped");
                    }
                    break;
                }
                finally {
                    this.abort();
                    ProxyServer.log("Accept thread(remote->client) stopped");
                }
            }
            case 2: {
                try {
                    try {
                        this.pipe(this.remote_in, this.out);
                    }
                    catch (IOException iOException) {
                        this.abort();
                        ProxyServer.log("Support thread(remote->client) stopped");
                    }
                    break;
                }
                finally {
                    this.abort();
                    ProxyServer.log("Support thread(remote->client) stopped");
                }
            }
            case 3: {
                break;
            }
            default: {
                ProxyServer.log("Unexpected MODE " + this.mode);
            }
        }
    }

    private void startSession() throws IOException {
        this.sock.setSoTimeout(iddleTimeout);
        try {
            this.auth = this.auth.startSession(this.sock);
        }
        catch (IOException ioe) {
            ProxyServer.log("Auth throwed exception:" + ioe);
            this.auth = null;
            return;
        }
        if (this.auth == null) {
            ProxyServer.log("Authentication failed");
            return;
        }
        this.in = this.auth.getInputStream();
        this.out = this.auth.getOutputStream();
        this.msg = this.readMsg(this.in);
        this.handleRequest(this.msg);
    }

    private void handleRequest(ProxyMessage msg) throws IOException {
        if (!this.auth.checkRequest(msg)) {
            throw new SocksException(1);
        }
        if (msg.ip == null) {
            if (msg instanceof Socks5Message) {
                if (msg.command != 1) {
                    msg.ip = InetAddress.getByName(msg.host);
                }
            } else {
                throw new SocksException(1);
            }
        }
        ProxyServer.log(msg);
        switch (msg.command) {
            case 1: {
                this.onConnect(msg);
                break;
            }
            case 2: {
                this.onBind(msg);
                break;
            }
            case 3: {
                this.onUDP(msg);
                break;
            }
            default: {
                throw new SocksException(7);
            }
        }
    }

    private void handleException(IOException ioe) {
        if (this.msg == null) {
            return;
        }
        if (this.mode == 3) {
            return;
        }
        if (this.mode == 2) {
            return;
        }
        int error_code = 1;
        if (ioe instanceof SocksException) {
            error_code = ((SocksException)ioe).errCode;
        } else if (ioe instanceof NoRouteToHostException) {
            error_code = 4;
        } else if (ioe instanceof ConnectException) {
            error_code = 5;
        } else if (ioe instanceof InterruptedIOException) {
            error_code = 6;
        }
        if (error_code > 8 || error_code < 0) {
            error_code = 1;
        }
        this.sendErrorMessage(error_code);
    }

    private void onConnect(ProxyMessage msg) throws IOException {
        Socket s = null;
        ProxyMessage response = null;
        int iSock5Cmd = 1;
        int iSock4Msg = 92;
        InetAddress sIp = null;
        int iPort = 0;
        try {
            if (proxy == null) {
                String host = msg.host;
                if (host == null) {
                    host = msg.ip.getHostAddress();
                }
                s = new HttpTunnelConnection(host, msg.port, true);
                msg.ip = s.getInetAddress();
            } else {
                s = new SocksSocket(proxy, msg.ip, msg.port);
            }
            ProxyServer.log("Connected to " + s.getInetAddress() + ":" + s.getPort());
            iSock5Cmd = 0;
            iSock4Msg = 90;
            sIp = s.getInetAddress();
            iPort = s.getPort();
        }
        catch (Exception sE) {
            ProxyServer.log("Failed connecting to remote socket. Exception: " + sE.getLocalizedMessage());
            iSock5Cmd = 5;
            iSock4Msg = 92;
        }
        response = msg instanceof Socks5Message ? new Socks5Message(iSock5Cmd, sIp, iPort) : new Socks4Message(iSock4Msg, sIp, iPort);
        response.write(this.out);
        if (s == null) {
            throw new RuntimeException("onConnect() Failed to create Socket()");
        }
        this.startPipe(s);
    }

    private void onBind(ProxyMessage msg) throws IOException {
        int eof;
        block6: {
            ProxyMessage response = null;
            this.ss = proxy == null ? new ServerSocket(0) : new SocksServerSocket(proxy, msg.ip, msg.port);
            this.ss.setSoTimeout(acceptTimeout);
            ProxyServer.log("Trying accept on " + this.ss.getInetAddress() + ":" + this.ss.getLocalPort());
            response = msg.version == 5 ? new Socks5Message(0, this.ss.getInetAddress(), this.ss.getLocalPort()) : new Socks4Message(90, this.ss.getInetAddress(), this.ss.getLocalPort());
            response.write(this.out);
            this.mode = 1;
            this.pipe_thread1 = Thread.currentThread();
            this.pipe_thread2 = new Thread(this);
            this.pipe_thread2.start();
            this.sock.setSoTimeout(0);
            eof = 0;
            try {
                while ((eof = this.in.read()) >= 0) {
                    if (this.mode == 1) continue;
                    if (this.mode != 2) {
                        return;
                    }
                    this.remote_out.write(eof);
                    break;
                }
            }
            catch (EOFException eofe) {
                return;
            }
            catch (InterruptedIOException iioe) {
                if (this.mode == 2) break block6;
                return;
            }
        }
        if (eof < 0) {
            return;
        }
        this.pipe(this.in, this.remote_out);
    }

    private void onUDP(ProxyMessage msg) throws IOException {
        if (msg.ip.getHostAddress().equals("0.0.0.0")) {
            msg.ip = this.sock.getInetAddress();
        }
        ProxyServer.log("Creating UDP relay server for " + msg.ip + ":" + msg.port);
        this.relayServer = new UDPRelayServer(msg.ip, msg.port, Thread.currentThread(), this.sock, this.auth);
        Socks5Message response = new Socks5Message(0, this.relayServer.relayIP, this.relayServer.relayPort);
        ((ProxyMessage)response).write(this.out);
        this.relayServer.start();
        this.sock.setSoTimeout(0);
        try {
            while (this.in.read() >= 0) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void doAccept() throws IOException {
        Socket s;
        long startTime = System.currentTimeMillis();
        while (true) {
            if ((s = this.ss.accept()).getInetAddress().equals(this.msg.ip)) break;
            if (this.ss instanceof SocksServerSocket) {
                s.close();
                this.ss.close();
                throw new SocksException(1);
            }
            if (acceptTimeout != 0) {
                int newTimeout = acceptTimeout - (int)(System.currentTimeMillis() - startTime);
                if (newTimeout <= 0) {
                    throw new InterruptedIOException("In doAccept()");
                }
                this.ss.setSoTimeout(newTimeout);
            }
            s.close();
        }
        this.ss.close();
        this.remote_sock = s;
        this.remote_in = s.getInputStream();
        this.remote_out = s.getOutputStream();
        this.remote_sock.setSoTimeout(iddleTimeout);
        ProxyServer.log("Accepted from " + s.getInetAddress() + ":" + s.getPort());
        ProxyMessage response = this.msg.version == 5 ? new Socks5Message(0, s.getInetAddress(), s.getPort()) : new Socks4Message(90, s.getInetAddress(), s.getPort());
        response.write(this.out);
    }

    private ProxyMessage readMsg(InputStream in) throws IOException {
        ProxyMessage msg;
        PushbackInputStream push_in = in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in);
        int version = push_in.read();
        push_in.unread(version);
        if (version == 5) {
            msg = new Socks5Message(push_in, false);
        } else if (version == 4) {
            msg = new Socks4Message(push_in, false);
        } else {
            throw new SocksException(1);
        }
        return msg;
    }

    private void startPipe(Socket s) {
        this.mode = 2;
        this.remote_sock = s;
        try {
            this.remote_in = s.getInputStream();
            this.remote_out = s.getOutputStream();
            this.pipe_thread1 = Thread.currentThread();
            this.pipe_thread2 = new Thread(this);
            this.pipe_thread2.start();
            this.pipe(this.in, this.remote_out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendErrorMessage(int error_code) {
        ProxyMessage err_msg = this.msg instanceof Socks4Message ? new Socks4Message(91) : new Socks5Message(error_code);
        try {
            err_msg.write(this.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void abort() {
        if (this.mode == 3) {
            return;
        }
        this.mode = 3;
        try {
            ProxyServer.log("Aborting operation");
            if (this.remote_sock != null) {
                this.remote_sock.close();
            }
            if (this.sock != null) {
                this.sock.close();
            }
            if (this.relayServer != null) {
                this.relayServer.stop();
            }
            if (this.ss != null) {
                this.ss.close();
            }
            if (this.pipe_thread1 != null) {
                this.pipe_thread1.interrupt();
            }
            if (this.pipe_thread2 != null) {
                this.pipe_thread2.interrupt();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static final void log(String s) {
        if (log != null) {
            log.println(s);
            log.flush();
        }
    }

    static final void log(ProxyMessage msg) {
        ProxyServer.log("Request version:" + msg.version + "\tCommand: " + ProxyServer.command2String(msg.command));
        ProxyServer.log("IP:" + msg.ip + "\tPort:" + msg.port + (msg.version == 4 ? "\tUser:" + msg.user : ""));
    }

    private void pipe(InputStream in, OutputStream out) throws IOException {
        this.lastReadTime = System.currentTimeMillis();
        byte[] buf = new byte[8192];
        int len = 0;
        while (len >= 0) {
            try {
                if (len != 0) {
                    out.write(buf, 0, len);
                    out.flush();
                }
                len = in.read(buf);
                this.lastReadTime = System.currentTimeMillis();
            }
            catch (InterruptedIOException iioe) {
                if (iddleTimeout == 0) {
                    return;
                }
                long timeSinceRead = System.currentTimeMillis() - this.lastReadTime;
                if (timeSinceRead >= (long)(iddleTimeout - 1000)) {
                    return;
                }
                len = 0;
            }
        }
    }

    static final String command2String(int cmd) {
        if (cmd > 0 && cmd < 4) {
            return command_names[cmd - 1];
        }
        return "Unknown Command " + cmd;
    }
}

