/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import httptunnel.HttpTunnelConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import proxy.Configuration;
import proxy.Subnet;
import util.Logger;

public class FtpProxy
extends Thread {
    private static final String defaultConfigFile = "ftpproxy.conf";
    static final int DEFAULT_BACKLOG = 50;
    static int DATABUFFERSIZE = 512;
    static boolean DIRECTCONNECT = false;
    static ServerSocket ssControlClient;
    Socket skControlClient;
    Socket skControlServer;
    BufferedReader brClient;
    BufferedReader brServer;
    PrintStream psClient;
    PrintStream osServer;
    ServerSocket ssDataClient;
    ServerSocket ssDataServer;
    Socket skDataClient;
    Socket skDataServer;
    String sLocalClientIP;
    String sLocalServerIP;
    private Configuration config;
    DataConnect dcData;
    boolean serverPassive = false;
    boolean userLoggedIn = false;
    boolean connectionClosed = false;
    static final Map lastPorts;
    static final String server2proxy = "S->P: ";
    static final String proxy2server = "S<-P: ";
    static final String proxy2client = "P->C: ";
    static final String client2proxy = "P<-C: ";
    static final String server2client = "S->C: ";
    static final String client2server = "S<-C: ";
    public static FtpProxy MAINLOOP;
    private boolean listenerStopped = false;
    private boolean stopped = false;
    public static String CRLF;
    boolean mainloop;

    static {
        lastPorts = new HashMap();
        CRLF = "\r\n";
    }

    public FtpProxy(Configuration config, Socket skControlClient) {
        this.config = config;
        this.skControlClient = skControlClient;
        this.mainloop = skControlClient == null;
    }

    public static void main(String[] args) throws Exception {
        Configuration config;
        HashMap<String, String> commandLineArguments = new HashMap<String, String>(args.length);
        int i = 0;
        while (i < args.length) {
            int j = args[i].indexOf("=");
            if (j == -1) {
                Logger.getLogger().logLine("Invalid argument: " + args[i]);
                throw new Exception("FTP Proxy start Failed!");
            }
            String name = args[i].substring(2, j);
            String value = args[i].substring(j + 1);
            if (commandLineArguments.containsKey(name)) {
                Logger.getLogger().logLine("Parameter error: --" + name + " may only be specified once.");
                throw new Exception("FTP Proxy start Failed!");
            }
            commandLineArguments.put(name, value);
            ++i;
        }
        String configFile = (String)commandLineArguments.get("config_file");
        if (configFile == null) {
            configFile = defaultConfigFile;
        }
        commandLineArguments.remove("config_file");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(configFile));
        }
        catch (IOException e) {
            Logger.getLogger().logLine("Configuration file error: " + e.getMessage());
            throw new Exception("FTP Proxy start Failed!");
        }
        properties.putAll((Map<?, ?>)commandLineArguments);
        DATABUFFERSIZE = Integer.parseInt(properties.getProperty("DATABUFFERSIZE", "512"));
        DIRECTCONNECT = Boolean.parseBoolean(properties.getProperty("DIRECTCONNECT", "false"));
        properties.remove("DATABUFFERSIZE");
        properties.remove("DIRECTCONNECT");
        if (!DIRECTCONNECT) {
            Logger.getLogger().logLine("Using Connections through HTTP Tunnel!");
        }
        try {
            config = new Configuration(properties);
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Invalid configuration: " + e.getMessage());
            throw new Exception("FTP Proxy start Failed!");
        }
        if (properties.size() > 0) {
            Logger.getLogger().logLine("Invalid configuration variable: " + properties.propertyNames().nextElement());
            throw new Exception("FTP Proxy start Failed!");
        }
        int port = config.bindPort;
        try {
            ssControlClient = config.bindAddress == null ? new ServerSocket(port) : new ServerSocket(port, 50, config.bindAddress);
            if (config.debug) {
                Logger.getLogger().logLine("Listening on port " + port);
            }
            MAINLOOP = new FtpProxy(config, null);
            MAINLOOP.start();
        }
        catch (IOException e) {
            if (config.debug) {
                Logger.getLogger().logException(e);
            } else {
                Logger.getLogger().logLine(e.toString());
            }
            throw new Exception("FTP Proxy start Failed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMainLoop() {
        while (!this.stopped) {
            try {
                Socket skControlClient = ssControlClient.accept();
                if (this.config.debug) {
                    Logger.getLogger().logLine("New connection");
                }
                new FtpProxy(this.config, skControlClient).start();
            }
            catch (IOException e) {
                FtpProxy ftpProxy = this;
                synchronized (ftpProxy) {
                    if (!this.stopped) {
                        if (this.config.debug) {
                            Logger.getLogger().logException(e);
                        } else {
                            Logger.getLogger().logLine(e.getMessage());
                        }
                    }
                    this.listenerStopped = true;
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized void kill() {
        Logger.getLogger().logLine("Stopping FTP Proxy...");
        if (this != MAINLOOP) {
            throw new IllegalStateException("Stop can only be called on MainLoop Instance!");
        }
        try {
            this.stopped = true;
            int port = ssControlClient.getLocalPort();
            ssControlClient.close();
            Logger.getLogger().logLine("Stopped FTP Proxy Listener on Port " + port + "!");
            while (!this.listenerStopped) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Logger.getLogger().logException(e);
                    return;
                }
            }
            MAINLOOP = null;
            Logger.getLogger().logLine("FTP Proxy stopped!");
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block153: {
            if (this.mainloop) {
                this.runMainLoop();
                return;
            }
            try {
                this.brClient = new BufferedReader(new InputStreamReader(this.skControlClient.getInputStream()));
                this.psClient = new PrintStream(this.skControlClient.getOutputStream());
                if (this.config.allowFrom != null && !FtpProxy.isInSubnetList(this.config.allowFrom, this.skControlClient.getInetAddress()) || FtpProxy.isInSubnetList(this.config.denyFrom, this.skControlClient.getInetAddress())) {
                    toClient = this.config.msgOriginAccessDenied;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    this.skControlClient.close();
                    return;
                }
                try {
                    this.sLocalClientIP = this.config.masqueradeHostname == null ? this.skControlClient.getLocalAddress().getHostAddress().replace('.', ',') : InetAddress.getByName(this.config.masqueradeHostname.trim()).getHostAddress().replace('.', ',');
                }
                catch (UnknownHostException e) {
                    toClient = this.config.msgMasqHostDNSError;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    this.skControlClient.close();
                    if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                        try {
                            this.ssDataClient.close();
                        }
                        catch (IOException var11_9) {
                            // empty catch block
                        }
                    }
                    if (this.ssDataServer != null && !this.config.serverOneBindPort) {
                        try {
                            this.ssDataServer.close();
                        }
                        catch (IOException var11_10) {
                            // empty catch block
                        }
                    }
                    if (this.skDataClient != null) {
                        try {
                            this.skDataClient.close();
                        }
                        catch (IOException var11_11) {
                            // empty catch block
                        }
                    }
                    if (this.skDataServer != null) {
                        try {
                            this.skDataServer.close();
                        }
                        catch (IOException var11_12) {
                            // empty catch block
                        }
                    }
                    if (this.psClient != null) {
                        this.psClient.close();
                    }
                    if (this.osServer != null) {
                        this.osServer.close();
                    }
                    if (this.dcData != null) {
                        this.dcData.close();
                    }
                    return;
                }
                username = null;
                hostname = null;
                serverport = 21;
                if (this.config.onlyAuto && this.config.autoHostname != null) {
                    username = null;
                    hostname = this.config.autoHostname;
                    serverport = this.config.autoPort;
                } else {
                    if (this.config.onlyAuto) {
                        throw new RuntimeException("only_auto is enabled, but no auto_host is set");
                    }
                    toClient = this.config.msgConnect;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.psClient.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    fromClient = this.brClient.readLine();
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P<-C: " + fromClient);
                    }
                    userString = fromClient.substring(5);
                    a = userString.lastIndexOf(64);
                    c = userString.lastIndexOf(58);
                    if (a == -1 && this.config.isUrlSyntaxEnabled && (a1 = userString.indexOf(42)) != -1) {
                        a = a1;
                        c = userString.lastIndexOf(42);
                        if (c == a) {
                            c = -1;
                        }
                    }
                    if (a == -1) {
                        username = userString;
                        hostname = this.config.autoHostname;
                        serverport = this.config.autoPort;
                    } else if (c == -1) {
                        username = userString.substring(0, a);
                        hostname = userString.substring(a + 1);
                    } else {
                        username = userString.substring(0, a);
                        hostname = userString.substring(a + 1, c);
                        serverport = Integer.parseInt(userString.substring(c + 1));
                    }
                }
                if (hostname == null) {
                    toClient = this.config.msgIncorrectSyntax;
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.skControlClient.close();
                    return;
                }
                serverAddress = null;
                try {
                    serverAddress = !FtpProxy.DIRECTCONNECT ? HttpTunnelConnection.getByName(hostname) : InetAddress.getByName(hostname);
                }
                catch (UnknownHostException e) {
                    toClient = this.config.msgConnectionRefused;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.psClient.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                        try {
                            this.ssDataClient.close();
                        }
                        catch (IOException var11_17) {
                            // empty catch block
                        }
                    }
                    if (this.ssDataServer != null && !this.config.serverOneBindPort) {
                        try {
                            this.ssDataServer.close();
                        }
                        catch (IOException var11_18) {
                            // empty catch block
                        }
                    }
                    if (this.skDataClient != null) {
                        try {
                            this.skDataClient.close();
                        }
                        catch (IOException var11_19) {
                            // empty catch block
                        }
                    }
                    if (this.skDataServer != null) {
                        try {
                            this.skDataServer.close();
                        }
                        catch (IOException var11_20) {
                            // empty catch block
                        }
                    }
                    if (this.psClient != null) {
                        this.psClient.close();
                    }
                    if (this.osServer != null) {
                        this.osServer.close();
                    }
                    if (this.dcData != null) {
                        this.dcData.close();
                    }
                    return;
                }
                if (this.config.allowTo != null && !FtpProxy.isInSubnetList(this.config.allowTo, serverAddress) || FtpProxy.isInSubnetList(this.config.denyTo, serverAddress)) {
                    toClient = this.config.msgDestinationAccessDenied;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.skControlClient.close();
                    return;
                }
                v0 = this.serverPassive = this.config.useActive != null && FtpProxy.isInSubnetList(this.config.useActive, serverAddress) == false || FtpProxy.isInSubnetList(this.config.usePassive, serverAddress) != false;
                if (this.config.debug) {
                    Logger.getLogger().logLine("Connecting to " + hostname + " on port " + serverport);
                }
                try {
                    this.skControlServer = !FtpProxy.DIRECTCONNECT ? new HttpTunnelConnection(serverAddress.getHostAddress(), serverport) : new Socket(serverAddress.getHostAddress(), serverport);
                }
                catch (ConnectException e) {
                    toClient = this.config.msgConnectionRefused;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.psClient.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient);
                    }
                    if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                        try {
                            this.ssDataClient.close();
                        }
                        catch (IOException var11_25) {
                            // empty catch block
                        }
                    }
                    if (this.ssDataServer != null && !this.config.serverOneBindPort) {
                        try {
                            this.ssDataServer.close();
                        }
                        catch (IOException var11_26) {
                            // empty catch block
                        }
                    }
                    if (this.skDataClient != null) {
                        try {
                            this.skDataClient.close();
                        }
                        catch (IOException var11_27) {
                            // empty catch block
                        }
                    }
                    if (this.skDataServer != null) {
                        try {
                            this.skDataServer.close();
                        }
                        catch (IOException var11_28) {
                            // empty catch block
                        }
                    }
                    if (this.psClient != null) {
                        this.psClient.close();
                    }
                    if (this.osServer != null) {
                        this.osServer.close();
                    }
                    if (this.dcData != null) {
                        this.dcData.close();
                    }
                    return;
                }
                this.brServer = new BufferedReader(new InputStreamReader(this.skControlServer.getInputStream()));
                this.osServer = new PrintStream(this.skControlServer.getOutputStream(), true);
                this.sLocalServerIP = this.skControlServer.getLocalAddress().getHostAddress().replace('.', ',');
                if (this.config.onlyAuto) ** GOTO lbl204
                fromServer = this.readResponseFromServer(false);
                if (fromServer.startsWith("421")) {
                    toClient = fromServer;
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.psClient.flush();
                    return;
                }
                try {
                    toServer = "USER " + username;
                    this.osServer.print(String.valueOf(toServer) + FtpProxy.CRLF);
                    this.osServer.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine("S<-P: " + toServer);
                    }
lbl204:
                    // 4 sources

                    this.readResponseFromServer(true);
                    do {
                        if ((s = this.brClient.readLine()) == null) {
                            if (this.config.debug) {
                                Logger.getLogger().logLine("End of Stream on Client Socket !");
                            }
                            this.osServer.print("QUIT" + FtpProxy.CRLF);
                            this.osServer.flush();
                            break block153;
                        }
                        this.readCommandFromClient(s);
                    } while (!this.connectionClosed);
                    Logger.getLogger().logLine("connection closed!");
                }
                catch (Exception e) {
                    toClient = this.config.msgInternalError;
                    if (this.config.debug) {
                        Logger.getLogger().logLine("P->C: " + toClient + e.toString());
                        Logger.getLogger().logException(e);
                    }
                    this.psClient.print(String.valueOf(toClient) + FtpProxy.CRLF);
                    this.psClient.flush();
                }
            }
            finally {
                if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                    try {
                        this.ssDataClient.close();
                    }
                    catch (IOException var11_5) {}
                }
                if (this.ssDataServer != null && !this.config.serverOneBindPort) {
                    try {
                        this.ssDataServer.close();
                    }
                    catch (IOException var11_6) {}
                }
                if (this.skDataClient != null) {
                    try {
                        this.skDataClient.close();
                    }
                    catch (IOException var11_7) {}
                }
                if (this.skDataServer != null) {
                    try {
                        this.skDataServer.close();
                    }
                    catch (IOException var11_8) {}
                }
                if (this.psClient != null) {
                    this.psClient.close();
                }
                if (this.osServer != null) {
                    this.osServer.close();
                }
                if (this.dcData != null) {
                    this.dcData.close();
                }
            }
        }
    }

    private void readCommandFromClient(String fromClient) throws IOException {
        String cmd = fromClient.toUpperCase();
        if (!this.userLoggedIn && (cmd.startsWith("PASV") || cmd.startsWith("PORT"))) {
            this.psClient.print("530 Not logged in." + CRLF);
            this.psClient.flush();
            return;
        }
        if (cmd.startsWith("PASV") || cmd.startsWith("EPSV")) {
            if (this.config.debug) {
                Logger.getLogger().logLine(client2proxy + fromClient);
            }
            if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                try {
                    this.ssDataClient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.skDataClient != null) {
                try {
                    this.skDataClient.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.dcData != null) {
                this.dcData.close();
            }
            if (this.ssDataClient == null || !this.config.clientOneBindPort) {
                this.ssDataClient = FtpProxy.getServerSocket(this.config.clientBindPorts, this.skControlClient.getLocalAddress());
            }
            if (this.ssDataClient != null) {
                int port = this.ssDataClient.getLocalPort();
                String toClient = cmd.startsWith("EPSV") ? "229 Entering Extended Passive Mode (|||" + port + "|)" : "227 Entering Passive Mode (" + this.sLocalClientIP + "," + port / 256 + "," + port % 256 + ")";
                this.psClient.print(String.valueOf(toClient) + CRLF);
                this.psClient.flush();
                if (this.config.debug) {
                    Logger.getLogger().logLine(proxy2client + toClient);
                }
                this.setupServerConnection(this.ssDataClient);
            } else {
                String toClient = "425 Cannot allocate local port..";
                this.psClient.print(String.valueOf(toClient) + CRLF);
                this.psClient.flush();
                if (this.config.debug) {
                    Logger.getLogger().logLine(proxy2client + toClient);
                }
            }
        } else {
            if (cmd.startsWith("PORT")) {
                int port = FtpProxy.parsePort(fromClient);
                if (this.ssDataClient != null && !this.config.clientOneBindPort) {
                    try {
                        this.ssDataClient.close();
                    }
                    catch (IOException toClient) {
                        // empty catch block
                    }
                    this.ssDataClient = null;
                }
                if (this.skDataClient != null) {
                    try {
                        this.skDataClient.close();
                    }
                    catch (IOException toClient) {
                        // empty catch block
                    }
                }
                if (this.dcData != null) {
                    this.dcData.close();
                }
                if (this.config.debug) {
                    Logger.getLogger().logLine(client2proxy + fromClient);
                }
                try {
                    this.skDataClient = !DIRECTCONNECT ? new HttpTunnelConnection(this.skControlClient.getInetAddress().getHostAddress(), port, true) : new Socket(this.skControlClient.getInetAddress().getHostAddress(), port);
                    String toClient = "200 PORT command successful.";
                    this.psClient.print(String.valueOf(toClient) + CRLF);
                    this.psClient.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine(proxy2client + toClient);
                    }
                    this.setupServerConnection(this.skDataClient);
                }
                catch (IOException e) {
                    String toClient = "425 PORT command failed - try using PASV instead.";
                    this.psClient.print(String.valueOf(toClient) + CRLF);
                    this.psClient.flush();
                    if (this.config.debug) {
                        Logger.getLogger().logLine(proxy2client + toClient);
                    }
                    return;
                }
            }
            this.osServer.print(String.valueOf(fromClient) + CRLF);
            this.osServer.flush();
            if (this.config.debug) {
                Logger.getLogger().log(client2server);
                if (cmd.startsWith("PASS")) {
                    Logger.getLogger().logLine("PASS *******");
                } else {
                    Logger.getLogger().logLine(fromClient);
                }
            }
            this.readResponseFromServer(true);
        }
    }

    private String readReader(BufferedReader r) throws IOException {
        String str = r.readLine();
        return str;
    }

    private String readResponseFromServer(boolean forwardToClient) throws IOException {
        String fromServer;
        String firstLine = fromServer = this.readReader(this.brServer);
        int response = Integer.parseInt(fromServer.substring(0, 3));
        if (fromServer.charAt(3) == '-') {
            String multiLine = String.valueOf(fromServer.substring(0, 3)) + ' ';
            while (!fromServer.startsWith(multiLine)) {
                if (forwardToClient) {
                    this.psClient.print(String.valueOf(fromServer) + CRLF);
                    this.psClient.flush();
                }
                if (this.config.debug) {
                    Logger.getLogger().logLine(String.valueOf(forwardToClient ? server2client : server2proxy) + fromServer);
                }
                fromServer = this.brServer.readLine();
            }
        }
        if (response == 230) {
            this.userLoggedIn = true;
        } else if (response == 221 || response == 421 || response == 530) {
            if (this.userLoggedIn) {
                this.connectionClosed = true;
            }
            this.userLoggedIn = false;
        }
        if (forwardToClient || response == 110) {
            this.psClient.print(String.valueOf(fromServer) + CRLF);
            this.psClient.flush();
        }
        if (this.config.debug) {
            Logger.getLogger().logLine(String.valueOf(forwardToClient ? server2client : server2proxy) + fromServer);
        }
        if (response >= 100 && response <= 199) {
            firstLine = this.readResponseFromServer(true);
        }
        return firstLine;
    }

    private void setupServerConnection(Object s) throws IOException {
        if (this.skDataServer != null) {
            try {
                this.skDataServer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serverPassive) {
            String toServer = "PASV";
            this.osServer.print(String.valueOf(toServer) + CRLF);
            this.osServer.flush();
            if (this.config.debug) {
                Logger.getLogger().logLine(proxy2server + toServer);
            }
            String fromServer = this.readResponseFromServer(false);
            int port = FtpProxy.parsePort(fromServer);
            if (this.config.debug) {
                Logger.getLogger().logLine("Server: " + this.skControlServer.getInetAddress() + ":" + port);
            }
            this.skDataServer = !DIRECTCONNECT ? new HttpTunnelConnection(this.skControlServer.getInetAddress().getHostAddress(), port, true) : new Socket(this.skControlServer.getInetAddress().getHostAddress(), port);
            this.dcData = new DataConnect(s, this.skDataServer);
            this.dcData.start();
        } else {
            if (this.ssDataServer != null && !this.config.serverOneBindPort) {
                try {
                    this.ssDataServer.close();
                }
                catch (IOException toServer) {
                    // empty catch block
                }
            }
            if (this.ssDataServer == null || !this.config.serverOneBindPort) {
                this.ssDataServer = FtpProxy.getServerSocket(this.config.serverBindPorts, this.skControlServer.getLocalAddress());
            }
            if (this.ssDataServer != null) {
                int port = this.ssDataServer.getLocalPort();
                String toServer = "PORT " + this.sLocalServerIP + ',' + port / 256 + ',' + port % 256;
                this.osServer.print(String.valueOf(toServer) + CRLF);
                this.osServer.flush();
                if (this.config.debug) {
                    Logger.getLogger().logLine(proxy2server + toServer);
                }
                this.readResponseFromServer(false);
                this.dcData = new DataConnect(s, this.ssDataServer);
                this.dcData.start();
            } else {
                String toClient = "425 Cannot allocate local port.";
                this.psClient.print(String.valueOf(toClient) + CRLF);
                this.psClient.flush();
                if (this.config.debug) {
                    Logger.getLogger().logLine(proxy2client + toClient);
                }
            }
        }
    }

    public static boolean isInSubnetList(List list, InetAddress ia) {
        if (list == null) {
            return false;
        }
        for (Subnet subnet : list) {
            if (!subnet.isInSubnet(ia)) continue;
            return true;
        }
        return false;
    }

    public static int parsePort(String s) throws IOException {
        int j;
        int i;
        try {
            i = s.lastIndexOf(40);
            j = s.lastIndexOf(41);
            if (i != -1 && j != -1 && i < j) {
                s = s.substring(i + 1, j);
            }
            i = s.lastIndexOf(44);
            j = s.lastIndexOf(44, i - 1);
            int port = Integer.parseInt(s.substring(i + 1));
        }
        catch (Exception e) {
            throw new IOException();
        }
        return port += 256 * Integer.parseInt(s.substring(j + 1, i));
    }

    public static synchronized ServerSocket getServerSocket(int[] portRanges, InetAddress ia) throws IOException {
        ServerSocket ss = null;
        if (portRanges != null) {
            int i;
            int port;
            Integer lastPort = (Integer)lastPorts.get(portRanges);
            if (lastPort != null) {
                port = lastPort;
                i = 0;
                while (i < portRanges.length && port > portRanges[i + 1]) {
                    i += 2;
                }
                ++port;
            } else {
                port = portRanges[0];
                i = 0;
            }
            int lastTry = -2;
            while (port != lastTry) {
                if (port > portRanges[i + 1]) {
                    i = (i + 2) % portRanges.length;
                    port = portRanges[i];
                }
                if (lastTry == -1) {
                    lastTry = port;
                }
                try {
                    ss = new ServerSocket(port, 1, ia);
                    lastPorts.put(portRanges, new Integer(port));
                    break;
                }
                catch (BindException bindException) {
                    ++port;
                }
            }
        } else {
            ss = new ServerSocket(0, 1, ia);
        }
        return ss;
    }

    static /* synthetic */ Configuration access$0(FtpProxy ftpProxy) {
        return ftpProxy.config;
    }

    public class DataConnect
    extends Thread {
        private byte[] buffer = new byte[DATABUFFERSIZE];
        private final Socket[] sockets = new Socket[2];
        private boolean isInitialized;
        private final Object[] o;
        private boolean validDataConnection;
        private Object mutex = new Object();

        public DataConnect(Object o1, Object o2) {
            this.o = new Object[]{o1, o2};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block19: {
                bis = null;
                bos = null;
                this.validDataConnection = false;
                try {
                    v0 = n = this.isInitialized != false ? 1 : 0;
                    if (!this.isInitialized) {
                        i = 0;
                        while (i < 2) {
                            if (this.o[i] instanceof ServerSocket) {
                                ss = (ServerSocket)this.o[i];
                                this.sockets[i] = ss.accept();
                                if (ss == FtpProxy.this.ssDataServer && !FtpProxy.access$0((FtpProxy)FtpProxy.this).serverOneBindPort || ss == FtpProxy.this.ssDataClient && !FtpProxy.access$0((FtpProxy)FtpProxy.this).clientOneBindPort) {
                                    ss.close();
                                }
                            } else {
                                this.sockets[i] = (Socket)this.o[i];
                            }
                            if (FtpProxy.this.skControlClient.getInetAddress().getHostAddress().compareTo(this.sockets[i].getInetAddress().getHostAddress()) == 0) {
                                this.validDataConnection = true;
                            }
                            ++i;
                        }
                        if (FtpProxy.access$0((FtpProxy)FtpProxy.this).validateDataConnection && !this.validDataConnection) {
                            Logger.getLogger().logLine("Invalid DataConnection - not from Control Client");
                            throw new SocketException("Invalid DataConnection - not from Control Client");
                        }
                        this.isInitialized = true;
                        i = this.mutex;
                        synchronized (i) {
                            new Thread(this).start();
                            try {
                                this.mutex.wait();
                            }
                            catch (InterruptedException var5_10) {
                                // empty catch block
                            }
                        }
                    }
                    bis = new BufferedInputStream(this.sockets[n].getInputStream());
                    bos = new BufferedOutputStream(this.sockets[1 - n].getOutputStream());
                    i = this.mutex;
                    synchronized (i) {
                        this.mutex.notify();
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl45 : MonitorExitStatement: MONITOREXIT : i
                        if (true) ** GOTO lbl48
                    }
                    do {
                        bos.write(this.buffer, 0, i);
lbl48:
                        // 2 sources

                    } while ((i = bis.read(this.buffer, 0, FtpProxy.DATABUFFERSIZE)) != -1);
                    bos.flush();
                }
                catch (SocketException n) {
                }
                catch (IOException e) {
                    if (!FtpProxy.access$0((FtpProxy)FtpProxy.this).debug) break block19;
                    Logger.getLogger().logException(e);
                }
            }
            this.close();
        }

        public void close() {
            try {
                this.sockets[0].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sockets[1].close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

