/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import proxy.Subnet;

class Configuration {
    Properties properties;
    int bindPort;
    InetAddress bindAddress;
    boolean onlyAuto;
    String autoHostname;
    int autoPort;
    String masqueradeHostname;
    boolean isUrlSyntaxEnabled;
    int[] serverBindPorts;
    int[] clientBindPorts;
    boolean serverOneBindPort;
    boolean clientOneBindPort;
    boolean validateDataConnection;
    boolean debug;
    List useActive;
    List usePassive;
    List allowFrom;
    List denyFrom;
    List allowTo;
    List denyTo;
    String msgConnect;
    String msgConnectionRefused;
    String msgOriginAccessDenied;
    String msgDestinationAccessDenied;
    String msgIncorrectSyntax;
    String msgInternalError;
    String msgMasqHostDNSError;

    public Configuration(Properties properties) throws UnknownHostException {
        this.properties = properties;
        this.bindPort = this.getInt("bind_port", 8089);
        String ba = this.getString("bind_address");
        this.bindAddress = ba == null ? null : InetAddress.getByName(ba.trim());
        this.serverBindPorts = this.getPortRanges("server_bind_ports");
        this.clientBindPorts = this.getPortRanges("client_bind_ports");
        this.serverOneBindPort = this.serverBindPorts != null && this.serverBindPorts.length == 2 && this.serverBindPorts[0] == this.serverBindPorts[1];
        this.clientOneBindPort = this.clientBindPorts != null && this.clientBindPorts.length == 2 && this.clientBindPorts[0] == this.clientBindPorts[1];
        this.masqueradeHostname = this.getString("masquerade_host");
        if (this.masqueradeHostname != null) {
            InetAddress.getByName(this.masqueradeHostname.trim());
        }
        this.useActive = this.getSubnets("use_active");
        this.usePassive = this.getSubnets("use_passive");
        this.allowFrom = this.getSubnets("allow_from");
        this.denyFrom = this.getSubnets("deny_from");
        this.allowTo = this.getSubnets("allow_to");
        this.denyTo = this.getSubnets("deny_to");
        this.onlyAuto = this.getBool("only_auto", false);
        this.autoHostname = this.getString("auto_host");
        if (this.autoHostname != null) {
            this.autoHostname = this.autoHostname.trim();
        }
        this.autoPort = this.getInt("auto_port", 21);
        this.isUrlSyntaxEnabled = this.getBool("enable_url_syntax", true);
        this.validateDataConnection = this.getBool("validate_data_connection", true);
        this.debug = this.getBool("output_debug_info", false);
        this.msgConnect = "220 " + this.getString("msg_connect", "Java FTP Proxy Server (usage: USERID=user@site) ready.");
        this.msgConnectionRefused = "421 " + this.getString("msg_connection_refused", "Connection refused, closing connection.");
        this.msgOriginAccessDenied = "531 " + this.getString("msg_origin_access_denied", "Access denied - closing connection.");
        this.msgDestinationAccessDenied = "531 " + this.getString("msg_destination_access_denied", "Access denied - closing connection.");
        this.msgIncorrectSyntax = "531 " + this.getString("msg_incorrect_syntax", "Incorrect usage - closing connection.");
        this.msgInternalError = "421 " + this.getString("msg_internal_error", "Internal error, closing connection.");
        this.msgMasqHostDNSError = "421 " + this.getString("msg_masqerade_hostname_dns_error", "Unable to resolve address for " + this.masqueradeHostname + " - closing connection.");
    }

    public boolean getBool(String name, boolean defaultValue) {
        String value = this.getString(name);
        return value == null ? defaultValue : value.trim().equals("1");
    }

    public int getInt(String name, int defaultValue) {
        String value = this.properties.getProperty(name);
        this.properties.remove(name);
        return value == null ? defaultValue : Integer.parseInt(value.trim());
    }

    public String getString(String name) {
        return this.getString(name, null);
    }

    public String getString(String name, String defaultValue) {
        String value = this.properties.getProperty(name, defaultValue);
        this.properties.remove(name);
        return value;
    }

    public List getSubnets(String name) {
        String s = this.getString(name);
        if (s == null) {
            return null;
        }
        LinkedList<Subnet> list = new LinkedList<Subnet>();
        StringTokenizer st = new StringTokenizer(s.trim(), ",");
        while (st.hasMoreTokens()) {
            list.add(new Subnet(st.nextToken().trim()));
        }
        return list;
    }

    public int[] getPortRanges(String name) {
        String s = this.getString(name);
        if (s == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(s.trim(), ",");
        int[] ports = new int[st.countTokens() * 2];
        if (ports.length == 0) {
            return null;
        }
        int lastPort = 0;
        int p = 0;
        while (st.hasMoreTokens()) {
            String range = st.nextToken().trim();
            int i = range.indexOf(45);
            if (i == -1) {
                int n = Integer.parseInt(range);
                ports[p + 1] = n;
                ports[p] = n;
            } else {
                ports[p] = Integer.parseInt(range.substring(0, i));
                ports[p + 1] = Integer.parseInt(range.substring(i + 1));
            }
            if (ports[p] < lastPort || ports[p] > ports[p + 1]) {
                throw new RuntimeException("Ports should be listed in increasing order.");
            }
            lastPort = ports[p + 1];
            p += 2;
        }
        return ports;
    }
}

