/*
 * Decompiled with CFR 0.152.
 */
package httptunnel;

import httptunnel.Configuration;
import httptunnel.ConnectionWatcherClient;
import httptunnel.HTTPTunnelChunkedOutputStream;
import httptunnel.HTTPTunnelInputStream;
import httptunnel.HTTPTunnelOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import util.Encryption;
import util.InputStreamReaderThread;
import util.Logger;
import util.Utils;
import util.conpool.Connection;
import util.http.HttpURLConnection;
import util.http.URL;

public class HttpTunnelConnection
extends Socket {
    private InputStream m_inStream;
    private OutputStream m_outStream;
    private String m_cookie;
    private String m_sessionId;
    private boolean m_open = false;
    private InetAddress remoteAdr = null;
    private boolean chunkedRequest = false;
    private InputStreamReaderThread pipe = null;
    private boolean directPassThrough = false;
    private Connection directConnection = null;
    protected String clientID;
    public boolean internalUsage = false;

    public HttpTunnelConnection(String host, int port, boolean internalUsage) throws IOException {
        boolean retry = true;
        boolean retried = false;
        while (retry) {
            try {
                Configuration.initConfiguration();
                this.internalUsage = internalUsage || (Configuration.CON_MODE & Utils.CON_MODE_WATCH_ENABLED) != 0;
                this.clientID = null;
                this.clientID = ConnectionWatcherClient.initConnectionWatcher(this);
                this.directPassThrough = Configuration.DIRECT_PASS_THROUGH;
                if (this.directPassThrough) {
                    this.connectDirect(host, port, null);
                    return;
                }
                this.chunkedRequest = (Configuration.CON_MODE & Utils.CON_MODE_CHUNKED_REQUEST) != 0;
                URL url = new URL(Configuration.TUNNELSERVER_URL);
                HttpURLConnection receiver = url.openConnection(Configuration.HTTPPROXY);
                receiver.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
                receiver.setConnectTimeout(Configuration.CON_TIMEOUT);
                receiver.setDoOutput(true);
                receiver.setRequestProperty("Connection", "Keep-Alive");
                receiver.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
                if (Configuration.PROXY_AUTH_REQUIRED) {
                    receiver.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
                }
                OutputStream outStream = Encryption.getEncryptedOutputStream(receiver.getOutputStream(), Configuration.SEND_BUFFER_BYTES);
                outStream.write(new String("RECEIVER\n").getBytes());
                outStream.write(new String(String.valueOf(this.clientID) + "\n").getBytes());
                outStream.write(new String(String.valueOf(host) + "\n").getBytes());
                outStream.write(new String(String.valueOf(new Integer(port).toString()) + "\n").getBytes());
                outStream.write(new String(String.valueOf(new Integer(Configuration.CON_REFRESH_INTERVAL).toString()) + "\n").getBytes());
                outStream.write((String.valueOf(Configuration.REMOTE_PERM) + "\n").getBytes());
                outStream.write(Configuration.CON_MODE);
                outStream.flush();
                outStream.close();
                String msg = receiver.getResponseMessage();
                InputStream inStream = Encryption.getDecryptedStream(new BufferedInputStream(receiver.getInputStream()));
                String response = Utils.readLineFromStream(inStream);
                int code = receiver.getResponseCode();
                retry = false;
                if (code == 200) {
                    this.m_sessionId = response;
                    try {
                        long session = Long.parseLong(this.m_sessionId);
                        this.m_sessionId = Long.valueOf(session ^= Long.MAX_VALUE).toString();
                    }
                    catch (NumberFormatException e) {
                        Utils.readFully(inStream, 50);
                        inStream.close();
                        throw new ConnectException(response);
                    }
                    ObjectInputStream objIn = new ObjectInputStream(inStream);
                    try {
                        this.remoteAdr = (InetAddress)objIn.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e.getMessage());
                    }
                    this.m_inStream = new HTTPTunnelInputStream(this, inStream);
                    this.m_open = true;
                    continue;
                }
                Utils.readFully(inStream, 50);
                inStream.close();
                throw new ConnectException(response);
            }
            catch (IOException ioe) {
                if (this.clientID != null) {
                    ConnectionWatcherClient.closedConnection(this);
                }
                if (retry && !retried) {
                    Logger.getLogger().logLine(String.valueOf(ioe.toString()) + "\r\n-->Retry ...");
                    Configuration.reset();
                    retried = true;
                    continue;
                }
                throw ioe;
            }
        }
    }

    private void connectDirect(String host, int port, String sessionID) throws IOException {
        this.directConnection = Connection.connect(Configuration.TUNNELSERVER_HOST, Configuration.TUNNELSERVER_PORT, Configuration.CON_TIMEOUT, Configuration.SSL, Configuration.SSL_SOCKET_FACTORY, Configuration.HTTPPROXY);
        try {
            this.m_inStream = Encryption.getDecryptedStream(this.directConnection.getInputStream());
            OutputStream out = this.directConnection.getOutputStream();
            out.write((String.valueOf(Configuration.ENCRAUTHSTRING) + "\n").getBytes());
            out.flush();
            this.m_outStream = Encryption.getEncryptedOutputStream(out, Configuration.SEND_BUFFER_BYTES);
            try {
                long handshake = Long.parseLong(Utils.readLineFromStream(this.m_inStream));
                this.m_outStream.write((String.valueOf(handshake ^ Long.MAX_VALUE) + "\n").getBytes());
            }
            catch (NumberFormatException hsf) {
                throw new IOException(hsf.toString());
            }
            if (sessionID == null) {
                this.m_outStream.write(("CONNECT\n" + this.clientID + "\n" + host + "\n" + port + "\n" + Configuration.REMOTE_PERM + "\n").getBytes());
            } else {
                this.m_outStream.write(("ATTACH\n" + sessionID + "\n").getBytes());
            }
            this.m_outStream.flush();
            String response = Utils.readLineFromStream(this.m_inStream);
            if (!response.equals("OK")) {
                if (response.startsWith("Invalid Client")) {
                    ConnectionWatcherClient.invalidate(true);
                }
                throw new ConnectException(String.valueOf(response) + "\n" + new String(Utils.readFully(this.m_inStream, 1024)));
            }
            if (sessionID == null) {
                ObjectInputStream objIn = new ObjectInputStream(this.m_inStream);
                try {
                    this.remoteAdr = (InetAddress)objIn.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e.getMessage());
                }
            }
            this.m_open = true;
        }
        catch (IOException e) {
            try {
                this.directConnection.release(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public HttpTunnelConnection(String host, int port) throws IOException {
        this(host, port, false);
    }

    public HttpTunnelConnection(String sessionId, InetAddress remoteAdr) throws IOException {
        this.clientID = ConnectionWatcherClient.initConnectionWatcher(this);
        try {
            this.directPassThrough = Configuration.DIRECT_PASS_THROUGH;
            this.m_sessionId = sessionId;
            this.remoteAdr = remoteAdr;
            if (!this.directPassThrough) {
                this.m_inStream = new HTTPTunnelInputStream(this, null);
            } else {
                this.connectDirect(null, -1, sessionId);
            }
            this.m_open = true;
        }
        catch (IOException eio) {
            ConnectionWatcherClient.closedConnection(this);
            throw eio;
        }
    }

    public String getSessionCookie() {
        return this.m_cookie;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.directPassThrough) {
            return this.m_inStream;
        }
        if (this.internalUsage) {
            return this.m_inStream;
        }
        if (this.pipe == null) {
            this.pipe = new InputStreamReaderThread(this.m_inStream);
        }
        return this.pipe.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.directPassThrough) {
            return this.m_outStream;
        }
        if (this.m_outStream == null) {
            this.m_outStream = !this.chunkedRequest ? new HTTPTunnelOutputStream(this) : new HTTPTunnelChunkedOutputStream(this);
            this.m_outStream = new BufferedOutputStream(this.m_outStream, Configuration.SEND_BUFFER_BYTES);
        }
        return this.m_outStream;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.m_open) {
            return;
        }
        this.m_open = false;
        ConnectionWatcherClient.closedConnection(this);
        if (this.directPassThrough) {
            try {
                this.directConnection.release(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        if (this.m_outStream != null) {
            this.m_outStream.close();
        }
        URL url = new URL(Configuration.TUNNELSERVER_URL);
        HttpURLConnection connection = url.openConnection(Configuration.HTTPPROXY);
        connection.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
        connection.setConnectTimeout(Configuration.CON_TIMEOUT);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        if (this.m_cookie != null) {
            connection.setRequestProperty("Cookie", this.m_cookie);
        }
        connection.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
        if (Configuration.PROXY_AUTH_REQUIRED) {
            connection.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
        }
        OutputStream outStream = Encryption.getEncryptedOutputStream(connection.getOutputStream(), 1024);
        outStream.write(new String("CLOSE_SESSION\n").getBytes());
        outStream.write(new String(String.valueOf(this.m_sessionId) + "\n").getBytes());
        outStream.flush();
        outStream.close();
        String msg = connection.getResponseMessage();
        int code = connection.getResponseCode();
        InputStream inStream = Encryption.getDecryptedStream(connection.getInputStream());
        try {
            if (code != 200) {
                byte[] response = Utils.readFully(inStream, 50);
                String responseStr = new String(response);
                throw new IOException(responseStr);
            }
        }
        finally {
            inStream.close();
            this.m_inStream.close();
        }
    }

    @Override
    public InetAddress getInetAddress() {
        return this.remoteAdr;
    }

    public static InetAddress getByName(String host) throws UnknownHostException {
        InputStream inStream = null;
        try {
            Configuration.initConfiguration();
            if (Configuration.DIRECT_PASS_THROUGH) {
                InetAddress inetAddress = InetAddress.getByName(host);
                return inetAddress;
            }
            URL url = new URL(Configuration.TUNNELSERVER_URL);
            HttpURLConnection receiver = url.openConnection(Configuration.HTTPPROXY);
            receiver.setSSLSocketFactory(Configuration.SSL_SOCKET_FACTORY);
            receiver.setConnectTimeout(Configuration.CON_TIMEOUT);
            receiver.setDoOutput(true);
            receiver.setRequestProperty("Connection", "Keep-Alive");
            receiver.setRequestProperty("Authorization", Configuration.ENCRAUTHSTRING);
            if (Configuration.PROXY_AUTH_REQUIRED) {
                receiver.setRequestProperty("Proxy-Authorization", Configuration.PROXY_AUTH_STRING);
            }
            OutputStream outStream = Encryption.getEncryptedOutputStream(receiver.getOutputStream(), 1024);
            outStream.write(new String("RESOLVE\n").getBytes());
            outStream.write(new String(String.valueOf(host) + "\n").getBytes());
            outStream.flush();
            outStream.close();
            String msg = receiver.getResponseMessage();
            int code = receiver.getResponseCode();
            inStream = Encryption.getDecryptedStream(receiver.getInputStream());
            if (code != 200) {
                String response = Utils.readLineFromStream(inStream);
                Utils.readFully(inStream, 50);
                throw new UnknownHostException(response);
            }
            ObjectInputStream objIn = new ObjectInputStream(inStream);
            InetAddress inetAddress = (InetAddress)objIn.readObject();
            return inetAddress;
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownHostException(e.getMessage());
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isOpen() {
        return this.m_open;
    }

    public void setClosed() {
        if (this.m_open) {
            this.m_open = false;
            ConnectionWatcherClient.closedConnection(this);
        }
        if (this.chunkedRequest) {
            try {
                this.m_outStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

