/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;

public class Utils {
    public static byte CON_MODE_CHUNKED_RESPONSE = 1;
    public static byte CON_MODE_CHUNKED_REQUEST = (byte)2;

    public static boolean isLongValue(String id) {
        try {
            Long.parseLong(id);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String readLineFromStream(InputStream in) throws IOException {
        byte[] str = new byte[100];
        int i = 0;
        boolean exit = false;
        while (!exit) {
            int r = in.read();
            byte b = (byte)(r & 0xFF);
            boolean bl = exit = r == -1 || b == 10 || i == 100;
            if (exit) continue;
            str[i] = b;
            ++i;
        }
        if (i > 0 && str[i - 1] == 13) {
            --i;
        }
        return new String(str, 0, i);
    }

    public static String readLineFromStreamRN(InputStream in) throws IOException {
        byte[] str = new byte[100];
        int i = 0;
        boolean exit = false;
        while (!exit) {
            int r = in.read();
            if (r == -1 && i == 0) {
                return null;
            }
            byte b = (byte)(r & 0xFF);
            boolean lineEnd = b == 10 && i > 0 && str[i - 1] == 13;
            boolean bl = exit = r == -1 || lineEnd || i == 100;
            if (!exit) {
                str[i] = b;
                ++i;
            }
            if (!lineEnd) continue;
            --i;
        }
        return new String(str, 0, i);
    }

    public static byte[] readFully(InputStream in, int bufSize) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        int r = 0;
        byte[] buf = new byte[bufSize];
        while ((r = in.read(buf, 0, bufSize)) != -1) {
            bytesOut.write(buf, 0, r);
        }
        return bytesOut.toByteArray();
    }

    public static byte[] serializeObject(Object obj) throws IOException {
        ByteArrayOutputStream objOut = new ByteArrayOutputStream();
        ObjectOutputStream dataOut = new ObjectOutputStream(objOut);
        dataOut.writeObject(obj);
        dataOut.flush();
        dataOut.close();
        return objOut.toByteArray();
    }
}

