/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public abstract class CharacterEncoder {
    protected PrintStream pStream;

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected int readFully(InputStream inputstream, byte[] abyte0) throws IOException {
        int i = 0;
        while (i < abyte0.length) {
            int j = inputstream.read();
            if (j == -1) {
                return i;
            }
            abyte0[i] = (byte)j;
            ++i;
        }
        return abyte0.length;
    }

    protected void encodeBufferPrefix(OutputStream outputstream) throws IOException {
        this.pStream = new PrintStream(outputstream);
    }

    protected void encodeBufferSuffix(OutputStream outputstream) throws IOException {
    }

    protected void encodeLineSuffix(OutputStream outputstream) throws IOException {
        this.pStream.println();
    }

    protected void encodeLinePrefix(OutputStream outputstream, int i) throws IOException {
    }

    protected abstract void encodeAtom(OutputStream var1, byte[] var2, int var3, int var4) throws IOException;

    public void encode(byte[] abyte0, OutputStream outputstream) throws IOException {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        this.encode(bytearrayinputstream, outputstream);
    }

    public void encodeBuffer(byte[] abyte0, OutputStream outputstream) throws IOException {
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        this.encodeBuffer(bytearrayinputstream, outputstream);
    }

    public String encode(byte[] abyte0) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        String s = null;
        try {
            this.encode(bytearrayinputstream, (OutputStream)bytearrayoutputstream);
            s = bytearrayoutputstream.toString("8859_1");
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return s;
    }

    public String encodeBuffer(byte[] abyte0) {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(abyte0);
        try {
            this.encodeBuffer(bytearrayinputstream, (OutputStream)bytearrayoutputstream);
        }
        catch (Exception exception) {
            throw new Error("ChracterEncoder::encodeBuffer internal error");
        }
        return bytearrayoutputstream.toString();
    }

    public void encode(InputStream inputstream, OutputStream outputstream) throws IOException {
        int j;
        byte[] abyte0 = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputstream);
        while ((j = this.readFully(inputstream, abyte0)) != 0) {
            this.encodeLinePrefix(outputstream, j);
            int i = 0;
            while (i < j) {
                if (i + this.bytesPerAtom() <= j) {
                    this.encodeAtom(outputstream, abyte0, i, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputstream, abyte0, i, j - i);
                }
                i += this.bytesPerAtom();
            }
            if (j < this.bytesPerLine()) break;
            this.encodeLineSuffix(outputstream);
        }
        this.encodeBufferSuffix(outputstream);
    }

    public void encodeBuffer(InputStream inputstream, OutputStream outputstream) throws IOException {
        int j;
        byte[] abyte0 = new byte[this.bytesPerLine()];
        this.encodeBufferPrefix(outputstream);
        while ((j = this.readFully(inputstream, abyte0)) != 0) {
            this.encodeLinePrefix(outputstream, j);
            int i = 0;
            while (i < j) {
                if (i + this.bytesPerAtom() <= j) {
                    this.encodeAtom(outputstream, abyte0, i, this.bytesPerAtom());
                } else {
                    this.encodeAtom(outputstream, abyte0, i, j - i);
                }
                i += this.bytesPerAtom();
            }
            this.encodeLineSuffix(outputstream);
            if (j >= this.bytesPerLine()) continue;
        }
        this.encodeBufferSuffix(outputstream);
    }
}

