/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import util.XORKey;

public class XORInputStream
extends InputStream {
    InputStream m_inStream;
    long keyPos = -2L;

    public XORInputStream(InputStream in) throws IOException {
        this.m_inStream = in;
        if (XORKey.keyBytes == null) {
            throw new IOException("XOR Key not initialized!");
        }
    }

    @Override
    public int read() throws IOException {
        int val = this.m_inStream.read();
        if (val == -1) {
            return -1;
        }
        if (this.keyPos == -2L) {
            this.keyPos = val;
            val = this.m_inStream.read();
        }
        if (val == -1) {
            return -1;
        }
        return this.xor(val);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r;
        if (this.keyPos == -2L) {
            int val = this.m_inStream.read();
            if (val == -1) {
                return -1;
            }
            this.keyPos = val;
        }
        if ((r = this.m_inStream.read(b, off, len)) == -1) {
            return -1;
        }
        int i = off;
        while (i < r + off) {
            b[i] = (byte)this.xor(b[i] & 0xFF);
            ++i;
        }
        return r;
    }

    private int xor(int b) {
        int keyOffs = (int)(this.keyPos % (long)XORKey.keyBytes.length);
        ++this.keyPos;
        return b ^ XORKey.keyBytes[keyOffs] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.m_inStream.close();
    }
}

