/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import util.Encryption;

public class PaddingCipherOutputStream
extends OutputStream {
    private ByteArrayOutputStream bytesBuffer;
    private DataOutputStream lowerOut;
    private OutputStream underlying;
    private int bufSize;
    private Cipher ecipher;

    public PaddingCipherOutputStream(OutputStream underlying, Cipher ecipher, int bufSize) throws IOException {
        this.bufSize = bufSize;
        this.underlying = underlying;
        this.bytesBuffer = new ByteArrayOutputStream(1024);
        this.ecipher = ecipher;
    }

    private void init() throws IOException {
        if (this.lowerOut != null) {
            return;
        }
        this.lowerOut = new DataOutputStream(this.underlying);
        this.lowerOut.writeInt(Encryption.INIT_BYTES.length);
        this.lowerOut.write(Encryption.INIT_BYTES);
    }

    @Override
    public void write(int oneByte) throws IOException {
        this.init();
        this.bytesBuffer.write(oneByte);
        this.bytesBuffer.flush();
        if (this.bytesBuffer.size() >= this.bufSize) {
            this.writeNext();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.init();
        this.bytesBuffer.write(b, off, len);
        this.bytesBuffer.flush();
        if (this.bytesBuffer.size() >= this.bufSize) {
            this.writeNext();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        this.init();
        this.writeNext();
        this.lowerOut.flush();
    }

    public void writeNext() throws IOException {
        this.bytesBuffer.flush();
        if (this.bytesBuffer.size() == 0) {
            return;
        }
        byte[] buf = this.bytesBuffer.toByteArray();
        this.bytesBuffer.reset();
        try {
            byte[] encrypted = this.ecipher.doFinal(buf);
            this.lowerOut.writeInt(encrypted.length);
            this.lowerOut.write(encrypted);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.init();
        this.writeNext();
        this.lowerOut.flush();
        this.lowerOut.close();
    }
}

