/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Cipher;
import util.Encryption;

public class PaddingCipherInputStream
extends InputStream {
    private DataInputStream lowerIn;
    private ByteArrayInputStream byteBuf;
    private boolean eof = false;
    private boolean init = false;
    private Cipher dcipher;

    public PaddingCipherInputStream(InputStream underlying, Cipher dcipher) throws IOException {
        this.lowerIn = new DataInputStream(underlying);
        this.dcipher = dcipher;
    }

    private void initRead() throws IOException {
        if (this.init) {
            return;
        }
        int size = -1;
        this.init = true;
        try {
            size = this.lowerIn.readInt();
        }
        catch (EOFException eofEx) {
            this.eof = true;
        }
        if (!this.eof) {
            if (size != Encryption.INIT_BYTES.length) {
                throw new IOException("Encryption / Decryption Error - most likely key not matching!");
            }
            byte[] next = new byte[size];
            this.lowerIn.readFully(next);
            if (!new String(next).equals(Encryption.INIT_STRING)) {
                throw new IOException("Encryption / Decryption Error - most likely key not matching!");
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.init) {
            this.initRead();
        }
        if (this.eof) {
            return -1;
        }
        if (this.byteBuf == null || this.byteBuf.available() == 0) {
            this.byteBuf = this.getNewBytes();
            if (this.byteBuf == null) {
                return -1;
            }
        }
        return this.byteBuf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.init) {
            this.initRead();
        }
        if (this.available() != 0) {
            return this.byteBuf.read(b, off, len);
        }
        if (this.eof) {
            return -1;
        }
        this.byteBuf = this.getNewBytes();
        if (this.eof) {
            return -1;
        }
        return this.byteBuf.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        if (this.byteBuf != null) {
            return this.byteBuf.available();
        }
        return 0;
    }

    private ByteArrayInputStream getNewBytes() throws IOException {
        byte[] next = null;
        try {
            int size = this.lowerIn.readInt();
            next = new byte[size];
            this.lowerIn.readFully(next);
        }
        catch (EOFException e) {
            this.eof = true;
            this.byteBuf = null;
            return null;
        }
        if (next.length == 0) {
            this.byteBuf = null;
            this.eof = true;
            return null;
        }
        try {
            byte[] decrypted = this.dcipher.doFinal(next);
            this.byteBuf = new ByteArrayInputStream(decrypted);
            return this.byteBuf;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.lowerIn.close();
    }
}

