/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class InputStreamReaderThread
implements Runnable {
    private InputStream source;
    private PipedInputStream pipeIn;
    private PipedOutputStream pipeOut;
    private boolean started = false;

    public InputStreamReaderThread(InputStream in) throws IOException {
        this.source = in;
        this.pipeIn = new PipedInputStream();
        this.pipeOut = new PipedOutputStream(this.pipeIn);
    }

    @Override
    public void run() {
        try {
            int r;
            byte[] buf = new byte[2048];
            while ((r = this.source.read(buf)) != -1) {
                this.pipeOut.write(buf, 0, r);
                this.pipeOut.flush();
            }
            this.pipeOut.close();
            this.source.close();
        }
        catch (IOException ioe) {
            try {
                this.pipeOut.close();
                this.source.close();
            }
            catch (IOException e) {
                System.out.println(e.toString());
            }
        }
    }

    public synchronized InputStream getInputStream() {
        if (!this.started) {
            new Thread(this).start();
            this.started = true;
        }
        return this.pipeIn;
    }
}

