/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import util.ObjectPackagingManager;
import util.PackedSortedList;

public class HugePackedSet
implements Set {
    private static final String IDX_VERSION = "1.0";
    private ObjectPackagingManager objMgr;
    private int slotCount;
    private int count = 0;
    private int[] slotSizes = null;
    private PackedSortedList[] subsets = null;

    public HugePackedSet(int slots, ObjectPackagingManager objMgr) {
        this.objMgr = objMgr;
        this.slotCount = slots;
        this.slotSizes = new int[this.slotCount];
        this.subsets = new PackedSortedList[this.slotCount];
        int i = 0;
        while (i < this.slotCount) {
            this.slotSizes[i] = 0;
            ++i;
        }
    }

    private HugePackedSet(PackedSortedList[] subsets, int slots, int count, ObjectPackagingManager objMgr) {
        this.objMgr = objMgr;
        this.slotCount = slots;
        this.subsets = subsets;
        this.count = count;
    }

    public void prepareInsert(Object obj) {
        int n = Math.abs(obj.hashCode()) % this.slotCount;
        this.slotSizes[n] = this.slotSizes[n] + 1;
    }

    public void finalPrepare() {
        int i = 0;
        while (i < this.slotCount) {
            this.subsets[i] = new PackedSortedList(this.slotSizes[i], this.objMgr);
            ++i;
        }
        this.slotSizes = null;
    }

    @Override
    public boolean add(Object obj) {
        boolean added = this.subsets[Math.abs(obj.hashCode()) % this.slotCount].add(obj);
        if (added) {
            ++this.count;
        }
        return added;
    }

    @Override
    public boolean addAll(Collection arg0) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public void clear() {
        this.slotSizes = new int[this.slotCount];
        int i = 0;
        while (i < this.slotCount) {
            this.subsets[i].clearAndReleaseAllMemory();
            this.slotSizes[i] = 0;
            ++i;
        }
    }

    @Override
    public boolean contains(Object obj) {
        return this.subsets[Math.abs(obj.hashCode()) % this.slotCount].contains(obj);
    }

    @Override
    public boolean containsAll(Collection arg0) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator iterator() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean removeAll(Collection arg0) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean retainAll(Collection arg0) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Not supported!");
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        throw new UnsupportedOperationException("Not supported!");
    }

    public void migrateTo(HugePackedSet pack) {
        this.slotCount = pack.slotCount;
        this.count = pack.count;
        this.slotSizes = pack.slotSizes;
        this.subsets = pack.subsets;
    }

    public void persist(String path) throws IOException {
        File dir = new File(String.valueOf(path) + ".tmp");
        int ii = 0;
        while (ii < 2) {
            if (dir.exists()) {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
                dir.delete();
            }
            dir = new File(path);
            ++ii;
        }
        dir = new File(String.valueOf(path) + ".tmp");
        dir.mkdir();
        FileOutputStream out = new FileOutputStream(String.valueOf(dir.getAbsolutePath()) + "/IDX_VERSION");
        out.write(IDX_VERSION.getBytes());
        out.flush();
        out.close();
        int i = 0;
        while (i < this.slotCount) {
            this.subsets[i].persist(String.valueOf(dir.getAbsolutePath()) + "/idx" + i);
            ++i;
        }
        File renameDir = new File(path);
        dir.renameTo(renameDir);
    }

    public static boolean checkIndexVersion(String path) throws IOException {
        File idxVersionFile = new File(String.valueOf(path) + "/IDX_VERSION");
        if (idxVersionFile.exists()) {
            FileInputStream in = new FileInputStream(String.valueOf(path) + "/IDX_VERSION");
            byte[] buf = new byte[10];
            int r = in.read(buf);
            in.close();
            return new String(buf, 0, r).equals(IDX_VERSION);
        }
        return false;
    }

    public static HugePackedSet load(String path, boolean inMemory, ObjectPackagingManager objMgr) throws IOException {
        if (!HugePackedSet.checkIndexVersion(path)) {
            throw new IOException("Incompatible Index Version - Rebuild Index!");
        }
        int slotCount = 0;
        int count = 0;
        while (new File(String.valueOf(path) + "/idx" + slotCount).exists()) {
            ++slotCount;
        }
        PackedSortedList[] subsets = new PackedSortedList[slotCount];
        int i = 0;
        while (i < subsets.length) {
            subsets[i] = PackedSortedList.load(String.valueOf(path) + "/idx" + i, inMemory, objMgr);
            count += subsets[i].size();
            ++i;
        }
        return new HugePackedSet(subsets, slotCount, count, objMgr);
    }
}

