/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import util.BASE64Decoder;
import util.Logger;
import util.PaddingCipherInputStream;
import util.PaddingCipherOutputStream;
import util.Utils;
import util.XORInputStream;
import util.XORKey;
import util.XOROutputStream;

public class Encryption {
    private static byte[] iv = new byte[]{12, -2, 30, 41, 101, -65, 17, -8, -91, 120, -11, 122, 13, -44, 45, 16};
    private static boolean INITIALZED = false;
    private static final int AES = 1;
    private static final int XOR = 2;
    private static final int PLAIN = 0;
    private static int ENCR_METHOD = 1;
    private static AlgorithmParameterSpec paramSpec;
    private static SecretKey key;
    private static Cipher dcipher;
    private static Cipher ecipher;
    public static String INIT_STRING;
    public static byte[] INIT_BYTES;

    static {
        dcipher = null;
        ecipher = null;
        INIT_STRING = "HbCt830lPn";
        INIT_BYTES = INIT_STRING.getBytes();
    }

    public static boolean isInitialized() {
        return INITIALZED;
    }

    private static void init_AES(InputStream keyStream) throws IOException {
        try {
            byte[] keyBytes = new BASE64Decoder().decodeBuffer(keyStream);
            keyStream.close();
            ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(keyBytes));
            key = (SecretKey)objIn.readObject();
            paramSpec = new IvParameterSpec(iv);
            ecipher = Encryption.getCipher(1);
            dcipher = Encryption.getCipher(2);
            INIT_BYTES = ecipher.doFinal(INIT_BYTES);
            INIT_STRING = new String(INIT_BYTES);
        }
        catch (Exception e) {
            throw new IOException("Encryption can not be initialized:" + e.getMessage());
        }
    }

    private static Cipher getCipher(int mode) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(mode, (Key)key, paramSpec);
            return cipher;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void init(InputStream keyStream, String method) throws IOException {
        if (method.equals("AES")) {
            Encryption.init_AES(keyStream);
            ENCR_METHOD = 1;
        } else if (method.equals("XOR")) {
            Logger.getLogger().logLine("ENCR Method: XOR");
            XORKey.setKey(Utils.readFully(keyStream, 4096));
            ENCR_METHOD = 2;
        } else if (method.equals("NONE")) {
            Logger.getLogger().logLine("WARNING: ENCR Method: NONE!");
            ENCR_METHOD = 0;
        } else {
            throw new IOException("Initialization of Encryption failed! Unknown method: " + method);
        }
        INITIALZED = true;
    }

    public static InputStream getDecryptedStream(InputStream encrypted) throws IOException {
        if (!INITIALZED) {
            throw new IOException("Encryption not initialized!");
        }
        if (ENCR_METHOD == 1) {
            return new PaddingCipherInputStream(encrypted, Encryption.getCipher(2));
        }
        if (ENCR_METHOD == 2) {
            return new XORInputStream(encrypted);
        }
        return encrypted;
    }

    public static OutputStream getEncryptedOutputStream(OutputStream out, int bufSize) throws IOException {
        if (!INITIALZED) {
            throw new IOException("Encryption not initialized!");
        }
        if (ENCR_METHOD == 1) {
            return new PaddingCipherOutputStream(out, Encryption.getCipher(1), bufSize);
        }
        if (ENCR_METHOD == 2) {
            return new XOROutputStream(out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decrypt(byte[] msg) throws IOException {
        if (!INITIALZED) {
            throw new IOException("Encryption not initialized!");
        }
        try {
            if (ENCR_METHOD == 1) {
                Cipher cipher = dcipher;
                synchronized (cipher) {
                    return dcipher.doFinal(msg);
                }
            }
            if (ENCR_METHOD == 2) {
                XORInputStream in = new XORInputStream(new ByteArrayInputStream(msg));
                return Utils.readFully(in, 1024);
            }
            return msg;
        }
        catch (Exception e) {
            throw new IOException("Decryption failed:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encrypt(byte[] msg) throws IOException {
        if (!INITIALZED) {
            throw new IOException("Encryption not initialized!");
        }
        try {
            if (ENCR_METHOD == 1) {
                Cipher cipher = ecipher;
                synchronized (cipher) {
                    return ecipher.doFinal(msg);
                }
            }
            if (ENCR_METHOD == 2) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                XOROutputStream xorOut = new XOROutputStream(bout, 0L);
                xorOut.write(msg);
                xorOut.flush();
                return bout.toByteArray();
            }
            return msg;
        }
        catch (Exception e) {
            throw new IOException("Encryption failed:" + e);
        }
    }
}

