/*
 * Decompiled with CFR 0.152.
 */
package upnp;

import httpproxy.HttpProxyServer;
import httptunnel.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import upnp.UpnpProxy;
import util.FileLogger;
import util.Logger;
import util.LoggerInterface;
import util.Utils;
import util.http.HttpChunkedInputStream;
import util.http.HttpHeader;

public class UpnpSessionProcessor
implements Runnable {
    private static Integer CNT = 0;
    private int cnt;
    HttpProxyServer dest = null;
    UpnpProxy proxy = null;
    Socket source = null;
    OutputStream serverOut;
    OutputStream clientOut;
    InputStream serverIn;
    InputStream clientIn;
    String reqHostEntry = null;
    byte[] buffer;
    LoggerInterface myLogger = Logger.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpnpSessionProcessor(Socket source, HttpProxyServer dest, UpnpProxy proxy) throws IOException {
        Integer n = CNT;
        synchronized (n) {
            CNT = CNT + 1;
            this.cnt = CNT;
        }
        Configuration.initConfiguration();
        this.proxy = proxy;
        this.dest = dest;
        this.source = source;
        this.serverOut = dest.getOutputStream();
        this.serverIn = dest.getInputStream();
        this.clientOut = source.getOutputStream();
        this.clientIn = source.getInputStream();
    }

    public void start() {
        new Thread(this).start();
    }

    @Override
    public void run() {
        if (this.proxy.debug) {
            try {
                this.myLogger = new FileLogger(String.valueOf(UpnpProxy.WORKDIR) + "log/upnpdebug", "debug_THR-" + this.cnt, 0xA00000L, 2, null);
            }
            catch (IOException e) {
                Logger.getLogger().logException(e);
            }
        }
        boolean sessionEnd = false;
        this.buffer = new byte[Configuration.SEND_BUFFER_BYTES];
        while (!sessionEnd) {
            sessionEnd = this.processRequest();
            if (sessionEnd) continue;
            sessionEnd = this.processResponse();
        }
        if (this.proxy.debug) {
            this.myLogger.closeLogger();
        }
    }

    private String adoptResponse(String content) throws IOException {
        StringBuffer newContent = new StringBuffer();
        int idx = 0;
        while (idx != -1) {
            int idx0 = idx;
            if ((idx = content.indexOf("http://", idx)) == -1) {
                newContent.append(content.substring(idx0));
                continue;
            }
            newContent.append(content.substring(idx0, idx + 7));
            int idx2 = content.indexOf(47, idx + 7);
            String hostEntry = content.substring(idx + 7, idx2);
            newContent.append(String.valueOf(this.proxy.localIP) + ":" + this.proxy.localPort + "/" + Utils.base64EncodeURL(hostEntry));
            idx = idx2;
        }
        String resp = newContent.toString().replace("URL>/", "URL>/" + this.reqHostEntry + "/").replace("url>/", "url>/" + this.reqHostEntry + "/");
        return resp;
    }

    private boolean processResponse() {
        int r = 0;
        if (this.proxy.debug) {
            this.myLogger.logLine("UPnP Proxy: Receiving Response...");
        }
        try {
            String contentType;
            HttpHeader resHeader = new HttpHeader(this.serverIn, 2);
            if (this.proxy.debug) {
                this.myLogger.log(resHeader.getHeaderString());
                this.myLogger.logLine("UPnP Proxy: Receiving Response... Body");
            }
            if ((contentType = resHeader.getValue("Content-Type")) != null && contentType.indexOf("text/xml") != -1) {
                String content;
                if (resHeader.chunkedTransfer()) {
                    resHeader.setValue("Transfer-Encoding", "");
                    HttpChunkedInputStream cin = new HttpChunkedInputStream(this.serverIn);
                    ByteArrayOutputStream contentBytesOS = new ByteArrayOutputStream();
                    int c = 0;
                    while ((c = cin.read(this.buffer)) != -1) {
                        contentBytesOS.write(this.buffer, 0, c);
                    }
                    contentBytesOS.flush();
                    content = new String(contentBytesOS.toByteArray(), "UTF-8");
                    contentBytesOS = null;
                } else {
                    long llen = resHeader.getContentLength();
                    if (llen > Integer.MAX_VALUE) {
                        throw new IOException("Content-Length overflow:" + llen);
                    }
                    int len = (int)llen;
                    byte[] contentBytes = new byte[len];
                    int c = 0;
                    while (c != len) {
                        r = this.serverIn.read(contentBytes, c, len - c);
                        if (r == -1) {
                            throw new IOException("Invalid End of Stream");
                        }
                        c += r;
                    }
                    content = new String(contentBytes, "UTF-8");
                    contentBytes = null;
                }
                byte[] newContent = this.adoptResponse(content).getBytes("UTF-8");
                resHeader.setValue("Content-Length", "" + newContent.length);
                this.clientOut.write(resHeader.getHeaderString().getBytes());
                this.clientOut.write(newContent);
                this.clientOut.flush();
                if (this.proxy.debug) {
                    this.myLogger.log(new String(newContent));
                }
                resHeader = null;
            } else {
                this.clientOut.write(resHeader.getHeaderString().getBytes());
                this.clientOut.flush();
                resHeader = null;
                while (r != -1 && this.dest.current_status == 7) {
                    r = this.serverIn.read(this.buffer, 0, this.buffer.length);
                    if (r == -1) continue;
                    this.clientOut.write(this.buffer, 0, r);
                    this.clientOut.flush();
                    if (!this.proxy.debug) continue;
                    int i = 0;
                    while (i < r) {
                        if (!(this.buffer[i] < 64 && this.buffer[i] > 32 || this.buffer[i] < 91 && this.buffer[i] > 64 || this.buffer[i] < 123 && this.buffer[i] > 96 || this.buffer[i] == 10 || this.buffer[i] == 13)) {
                            this.buffer[i] = 46;
                        }
                        ++i;
                    }
                    this.myLogger.log(new String(this.buffer, 0, r));
                }
                if (this.proxy.debug) {
                    this.myLogger.logLine("UPnP Proxy: Receiving Response... Completed");
                }
            }
            if (r == -1) {
                this.proxy.cleanUp(0, "Server->Client");
                return true;
            }
            return false;
        }
        catch (IOException e) {
            if (this.proxy.debug) {
                this.myLogger.logLine(e.toString());
            }
            this.proxy.cleanUp(-1, "Server->Client");
            return true;
        }
        catch (Exception e) {
            Logger.getLogger().logException(e);
            this.proxy.cleanUp(-1, "Server->Client");
            return true;
        }
    }

    private boolean processRequest() {
        if (this.proxy.debug) {
            this.myLogger.logLine("UPnP Proxy: Receiving Request...");
        }
        int r = 0;
        try {
            int idx;
            HttpHeader reqHeader = new HttpHeader(this.clientIn, 1);
            if (this.proxy.debug) {
                this.myLogger.logLine("UPnP Proxy: received Request\r\n" + reqHeader.getHeaderString());
                this.myLogger.logLine("URL:" + reqHeader.url);
            }
            String url = reqHeader.url;
            try {
                idx = url.indexOf(47, 1);
                this.reqHostEntry = url.substring(1, idx);
            }
            catch (Exception e) {
                String msg = "Not a valid UpnpProxy request url: " + url;
                Logger.getLogger().logLine(msg);
                throw new IOException(msg);
            }
            String hostEntry = Utils.base64DecodeURL(this.reqHostEntry);
            reqHeader.setHostEntry(hostEntry);
            reqHeader.url = "/" + url.substring(idx + 1);
            String req = reqHeader.getServerRequestHeader();
            this.serverOut.write(req.getBytes());
            this.serverOut.flush();
            if (this.proxy.debug) {
                this.myLogger.logLine("UPnP Proxy: Adopted Request:\r\n" + req);
            }
            reqHeader = null;
            req = null;
            if (this.proxy.debug) {
                this.myLogger.logLine("UPnP Proxy: Receiving Request... Body");
            }
            while (r != -1 && this.dest.current_status == 4) {
                r = this.clientIn.read(this.buffer, 0, this.buffer.length);
                if (r == -1) continue;
                this.serverOut.write(this.buffer, 0, r);
                this.serverOut.flush();
                if (!this.proxy.debug) continue;
                int i = 0;
                while (i < r) {
                    if (!(this.buffer[i] < 64 && this.buffer[i] > 32 || this.buffer[i] < 91 && this.buffer[i] > 64 || this.buffer[i] < 123 && this.buffer[i] > 96 || this.buffer[i] == 10 || this.buffer[i] == 13)) {
                        this.buffer[i] = 46;
                    }
                    ++i;
                }
                this.myLogger.log(new String(this.buffer, 0, r));
            }
            if (this.proxy.debug) {
                this.myLogger.logLine("UPnP Proxy: Receiving Request... Completed!");
            }
            return false;
        }
        catch (IOException e) {
            if (this.proxy.debug) {
                this.myLogger.logLine(e.toString());
            }
            this.proxy.cleanUp(-1, "Client->Server");
            return true;
        }
        catch (Exception e) {
            Logger.getLogger().logException(e);
            this.proxy.cleanUp(-1, "Client->Server");
            return true;
        }
    }
}

