/*
 * Decompiled with CFR 0.152.
 */
package upnp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import udpproxy.DirectUDPSession;
import upnp.UpnpProxy;
import upnp.UpnpSearchRequestProcessor;
import util.Logger;
import util.Utils;
import util.http.HttpHeader;

public class UpnpProxyManager {
    UpnpProxy DLNA_TUNNEL = null;
    String proxyID;
    Set localIPs;
    boolean localOnly = true;
    boolean debug = false;
    UpnpSearchRequestProcessor SEARCH_PROC;
    private byte[] discover_msg_all;
    private static final String NOTIFY_MESSAGE = "NOTIFY * HTTP/1.1\r\nCache-control: \r\nHost: 239.255.255.250:1900\r\n\r\n";
    private static String[] NOTIFY_KEYS = new String[]{"Cache-control", "Usn", "Location", "Nt", "Nts", "Server"};
    private final HttpHeader NOTIFY_HEADER = new HttpHeader(new ByteArrayInputStream("NOTIFY * HTTP/1.1\r\nCache-control: \r\nHost: 239.255.255.250:1900\r\n\r\n".getBytes()), 1);

    public UpnpProxyManager(int port, boolean localOnly, boolean debug) throws IOException {
        this.localOnly = localOnly;
        if (this.localOnly) {
            Logger.getLogger().logLine("UPnP Proxy: localhost access only");
        }
        this.debug = debug;
        this.proxyID = "" + (long)(Math.random() * 9.223372036854776E18);
        this.DLNA_TUNNEL = new UpnpProxy(this, port, localOnly, debug);
        Logger.getLogger().logLine("UPnP Proxy on port " + port + " started!");
        this.SEARCH_PROC = new UpnpSearchRequestProcessor(this);
        this.localIPs = this.detectNetwork();
        String[] iPs = this.localIPs.toArray(new String[this.localIPs.size()]);
        int i = 0;
        while (i < iPs.length) {
            Logger.getLogger().logLine("Detected LOCAL IP:" + iPs[i]);
            ++i;
        }
        this.discover_msg_all = ("M-SEARCH * HTTP/1.1\r\nST: ssdp:all\r\nMX: 3\r\nMAN: \"ssdp:discover\"\r\nHOST: 239.255.255.250:1900\r\nDLNAProxyID: " + this.proxyID + "\r\n\r\n").getBytes("UTF-8");
        this.asyncUpnpNotify();
    }

    public void asyncUpnpNotify() {
        new Thread(new AsyncUpnpNotify()).start();
    }

    private Set detectNetwork() throws IOException {
        NetworkInterface nif = null;
        HashSet<String> allIPs = new HashSet<String>();
        Enumeration<NetworkInterface> allNifs = NetworkInterface.getNetworkInterfaces();
        while (allNifs.hasMoreElements()) {
            nif = allNifs.nextElement();
            Enumeration<InetAddress> ips = nif.getInetAddresses();
            while (ips.hasMoreElements()) {
                InetAddress adr = ips.nextElement();
                if (adr.isLoopbackAddress() || !(adr instanceof Inet4Address)) continue;
                String ipStr = adr.getHostAddress();
                allIPs.add(ipStr);
            }
        }
        if (allIPs.size() == 0) {
            allIPs.add("127.0.0.1");
        }
        return allIPs;
    }

    public boolean isLocalIP(String ip) {
        return ip.equals("127.0.0.1") || this.localIPs.contains(ip);
    }

    public void upnpNotify() {
        try {
            InetAddress multicastAddress = InetAddress.getByName("239.255.255.250");
            DirectUDPSession session = new DirectUDPSession(InetAddress.getByName("239.255.255.250"), 1900, 8152, 2000);
            byte[] response = new byte[]{};
            MulticastSocket socket = null;
            session.requestPackage(this.discover_msg_all);
            Logger.getLogger().logLine("processing UPnP Notifiy...");
            while ((response = session.readResponsePackage()) != null) {
                try {
                    HttpHeader resheader;
                    String origURL;
                    if (socket == null) {
                        socket = this.localOnly ? new MulticastSocket(new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 0)) : new MulticastSocket(0);
                        socket.setReuseAddress(true);
                        socket.joinGroup(multicastAddress);
                    }
                    if ((origURL = (resheader = new HttpHeader(new ByteArrayInputStream(response), 2)).getValue("Location")) != null) {
                        HttpHeader notifyMsgHeader = this.NOTIFY_HEADER.clone();
                        String[] iPs = this.localIPs.toArray(new String[this.localIPs.size()]);
                        int i = 0;
                        while (i < NOTIFY_KEYS.length) {
                            String val = NOTIFY_KEYS[i].equals("Nt") ? resheader.getValue("St") : (NOTIFY_KEYS[i].equals("Nts") ? "ssdp:alive" : resheader.getValue(NOTIFY_KEYS[i]));
                            if (val != null) {
                                notifyMsgHeader.setValue(NOTIFY_KEYS[i], val);
                            }
                            ++i;
                        }
                        i = 0;
                        while (i < iPs.length) {
                            notifyMsgHeader.setValue("Location", this.adoptOrigLocationURL(iPs[i], origURL));
                            byte[] txbuf = notifyMsgHeader.getHeaderString().getBytes("UTF-8");
                            DatagramPacket hi = new DatagramPacket(txbuf, txbuf.length, multicastAddress, 1900);
                            socket.send(hi);
                            Logger.getLogger().log(new String(txbuf));
                            ++i;
                        }
                        continue;
                    }
                    Logger.getLogger().logLine("Location not found in UPNP Response Header\r\n" + resheader.getHeaderString());
                }
                catch (IOException e) {
                    Logger.getLogger().logLine("Error when runnign Notifications: " + e.toString());
                }
            }
            Logger.getLogger().logLine("processing UPnP Notifiy... completed!");
        }
        catch (IOException ioe) {
            Logger.getLogger().logLine("UPnP Notify failed:" + ioe.toString());
        }
    }

    public void sendDLNAResponse(DatagramSocket socket, DatagramPacket[] req) throws IOException {
        DirectUDPSession session = null;
        int i = 0;
        while (i < req.length) {
            ByteArrayInputStream in = new ByteArrayInputStream(req[i].getData(), req[i].getOffset(), req[i].getLength());
            HttpHeader header = new HttpHeader(in, 1);
            if (header.method.toUpperCase().equals("M-SEARCH") && header.hostEntry.equals("239.255.255.250:1900") && (header.getValue("DLNAProxyID") == null || !header.getValue("DLNAProxyID").equals(this.proxyID))) {
                Logger.getLogger().logLine("Received M-SEARCH Request:\r\n" + header.getHeaderString());
                header.setValue("DLNAProxyID", this.proxyID);
                if (session == null) {
                    session = new DirectUDPSession(InetAddress.getByName("239.255.255.250"), 1900, 8152, 1000);
                }
                session.requestPackage(header.getHeaderString().getBytes("UTF-8"));
            }
            ++i;
        }
        if (session != null) {
            byte[] response = new byte[]{};
            String[] iPs = this.localIPs.toArray(new String[this.localIPs.size()]);
            while ((response = session.readResponsePackage()) != null) {
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(response);
                    HttpHeader resheader = new HttpHeader(in, 2);
                    String origURL = resheader.getValue("Location");
                    if (origURL != null) {
                        int i2 = 0;
                        while (i2 < iPs.length) {
                            resheader.setValue("Location", this.adoptOrigLocationURL(iPs[i2], origURL));
                            byte[] txbuf = resheader.getHeaderString().getBytes("UTF-8");
                            DatagramPacket hi = new DatagramPacket(txbuf, txbuf.length, req[0].getAddress(), req[0].getPort());
                            socket.send(hi);
                            Logger.getLogger().log("RESPONSE\r\n" + new String(txbuf));
                            ++i2;
                        }
                        continue;
                    }
                    Logger.getLogger().logLine("Location not found in UPNP Response Header\r\n" + resheader.getHeaderString());
                }
                catch (IOException e) {
                    Logger.getLogger().logLine("Error when responding to search request:" + e.toString());
                }
            }
        }
    }

    private String adoptOrigLocationURL(String localIP, String origURL) throws IOException {
        int localPort = this.DLNA_TUNNEL.localPort;
        String[] parsedURI = Utils.parseURI(origURL);
        String locURL = "http://" + localIP + ":" + localPort + "/" + Utils.base64EncodeURL(parsedURI[0]) + parsedURI[1];
        return locURL;
    }

    public void kill() {
        this.SEARCH_PROC.stop();
        this.DLNA_TUNNEL.stop();
    }

    public void networkStateChanged() {
        try {
            Set newIPs = this.detectNetwork();
            if (!newIPs.equals(this.localIPs)) {
                this.localIPs = newIPs;
                Logger.getLogger().logLine("local IP Change");
                String[] iPs = this.localIPs.toArray(new String[this.localIPs.size()]);
                int i = 0;
                while (i < iPs.length) {
                    Logger.getLogger().logLine("Detected LOCAL IP:" + iPs[i]);
                    ++i;
                }
                this.DLNA_TUNNEL.killSessions();
                this.SEARCH_PROC.networkStateChanged();
            }
        }
        catch (IOException e) {
            Logger.getLogger().logException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        new UpnpProxyManager(Integer.parseInt(args[1]), !args[0].equals("localOnly=false"), Boolean.parseBoolean(args[2]));
    }

    private class AsyncUpnpNotify
    implements Runnable {
        private AsyncUpnpNotify() {
        }

        @Override
        public void run() {
            UpnpProxyManager.this.upnpNotify();
        }
    }
}

