/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import httptunnel.HttpTunnelConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import udpproxy.UDPProxy;
import util.Logger;
import util.TimeoutListener;
import util.TimeoutTime;
import util.TimoutNotificator;
import util.Utils;

public class UDPSession
implements Runnable,
TimeoutListener {
    private UDPProxy proxy;
    private InetAddress clientAdr;
    private int clientPort;
    private HttpTunnelConnection con;
    private DataInputStream conIn;
    private OutputStream conOut;
    boolean closed = false;
    private TimoutNotificator toNotify = TimoutNotificator.getInstance();
    private TimeoutTime timeout = new TimeoutTime(this.toNotify);
    private boolean status_pooled = false;

    public UDPSession(InetAddress adr, int port, UDPProxy proxy) throws IOException {
        this.proxy = proxy;
        this.clientAdr = adr;
        this.clientPort = port;
        try {
            this.con = new HttpTunnelConnection("$UDPBRIDGE$", 0, true);
            this.conIn = new DataInputStream(this.con.getInputStream());
            this.conOut = this.con.getOutputStream();
            byte[] initPackage = ("client " + proxy.remoteHost + " " + proxy.remotePort + " " + proxy.receivebuffer).getBytes();
            byte[] packetSize = Utils.intToByteArray(initPackage.length);
            this.conOut.write(packetSize);
            this.conOut.write(initPackage);
            this.conOut.flush();
            byte[] response = new byte[this.conIn.readInt()];
            this.conIn.readFully(response);
            String responseStr = new String(response);
            if (!responseStr.equals("OK")) {
                try {
                    this.con.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger().logLine(ioe.getMessage());
                }
                throw new IOException(responseStr);
            }
            this.timeout.setTimeout(proxy.timeout);
            this.toNotify.register(this);
            new Thread(this).start();
        }
        catch (IOException ioe) {
            if (this.con != null) {
                this.con.close();
            }
            throw ioe;
        }
    }

    public void dispatch(DatagramPacket receivePacket) {
        block3: {
            try {
                this.timeout.setTimeout(this.proxy.timeout);
                this.conOut.write(Utils.intToByteArray(receivePacket.getLength()));
                this.conOut.write(receivePacket.getData(), receivePacket.getOffset(), receivePacket.getLength());
                this.conOut.flush();
                if (this.proxy.debug) {
                    Logger.getLogger().logLine(this.clientAdr + ":" + this.clientPort + "->Tunnel::" + new String(receivePacket.getData(), receivePacket.getOffset(), receivePacket.getLength()));
                }
            }
            catch (IOException e) {
                Logger.getLogger().log("Exception during dispatch:" + e.getMessage());
                this.proxy.closeSession(this);
                if (!this.status_pooled) break block3;
                this.proxy.destroyPooledSession(this);
            }
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                byte[] packetSize = new byte[4];
                this.conIn.readFully(packetSize);
                int size = Utils.byteArrayToInt(packetSize);
                this.timeout.setTimeout(this.proxy.timeout);
                if (size == -1) {
                    this.proxy.closeSession(this);
                    continue;
                }
                byte[] packet = new byte[size];
                this.conIn.readFully(packet);
                DatagramPacket sendPack = new DatagramPacket(packet, size, this.clientAdr, this.clientPort);
                if (this.proxy.debug) {
                    Logger.getLogger().logLine("Tunnel->" + this.clientAdr + ":" + this.clientPort + "::" + new String(packet));
                }
                this.proxy.send(sendPack);
            }
            catch (IOException ioe) {
                if (this.closed) continue;
                Logger.getLogger().log(ioe.getMessage());
                if (this.status_pooled) {
                    this.proxy.destroyPooledSession(this);
                    continue;
                }
                this.proxy.closeSession(this);
                if (!this.status_pooled) continue;
                this.proxy.destroyPooledSession(this);
            }
        }
    }

    public InetAddress getClientAddress() {
        return this.clientAdr;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void closeSession() {
        this.toNotify.unregister(this);
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.con.close();
            Logger.getLogger().logLine("Closed UDP Session:" + this);
        }
        catch (IOException e) {
            Logger.getLogger().logLine("Close failed:" + e.toString());
        }
    }

    public String toString() {
        return "UDPSession@" + this.clientAdr + ":" + this.clientPort;
    }

    @Override
    public void timeoutNotification() {
        if (!this.status_pooled) {
            this.proxy.closeSession(this);
        } else {
            this.proxy.destroyPooledSession(this);
        }
    }

    public void setPooled() {
        this.status_pooled = true;
        this.timeout.setTimeout(this.proxy.pooltime);
        this.toNotify.register(this);
        Logger.getLogger().logLine("Pooled:" + this);
    }

    public void setUnPooled(InetAddress adr, int port) {
        this.status_pooled = false;
        this.timeout.setTimeout(this.proxy.timeout);
        this.toNotify.register(this);
        this.clientAdr = adr;
        this.clientPort = port;
        Logger.getLogger().logLine("Unpooled:" + this);
    }

    @Override
    public long getTimoutTime() {
        return this.timeout.getTimeout();
    }
}

