/*
 * Decompiled with CFR 0.152.
 */
package udpproxy;

import httptunnel.HttpTunnelConnection;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import udpproxy.UDPProxy;
import util.Logger;
import util.Utils;

public class UDPServerProxy
implements Runnable {
    DataInputStream listenerIN = null;
    protected InetAddress remoteHost;
    protected int remotePort;
    private boolean debug;
    private boolean ASYNC = false;
    private boolean stopped = false;
    protected int receivebuffer = 5096;
    protected int timeout = 60000;
    private HashMap sessions = new HashMap();

    public static void main(String[] args) throws Exception {
        UDPServerProxy proxy = new UDPServerProxy();
        proxy.initMainLoop(args);
    }

    @Override
    public void run() {
        this.runListenerLoop();
    }

    private void runListenerLoop() {
        while (!this.stopped) {
            try {
                int clientInfoSize = this.listenerIN.readInt();
                int packetDataSize = this.listenerIN.readInt();
                byte[] clientInfo = new byte[clientInfoSize];
                byte[] packetData = new byte[packetDataSize];
                this.listenerIN.readFully(clientInfo);
                this.listenerIN.readFully(packetData);
                UDPProxy clientProxy = this.getClientProxy(new String(clientInfo));
                DatagramPacket sendPack = new DatagramPacket(packetData, packetDataSize, this.remoteHost, this.remotePort);
                clientProxy.send(sendPack);
            }
            catch (IOException ioe) {
                if (this.stopped) {
                    return;
                }
                Logger.getLogger().logException(ioe);
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UDPProxy getClientProxy(String clientInfo) throws IOException {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            UDPProxy session = (UDPProxy)this.sessions.get(clientInfo);
            if (session == null) {
                int clientPort;
                int index = clientInfo.indexOf(":");
                if (index == -1) {
                    throw new IOException("Cannot parse client info:" + clientInfo);
                }
                String clientHost = clientInfo.substring(0, index);
                try {
                    clientPort = Integer.parseInt(clientInfo.substring(index + 1));
                }
                catch (Exception e) {
                    throw new IOException("Cannot parse client port to int:" + clientInfo.substring(index + 1));
                }
                session = new UDPProxy(new DatagramSocket(), clientHost, clientPort, this.receivebuffer, this.timeout, this.debug, this.ASYNC, this);
                this.sessions.put(clientInfo, session);
                new Thread(session).start();
                Logger.getLogger().logLine("New UDP Session:" + session);
            }
            return session;
        }
    }

    private void initMainLoop(String[] args) throws Exception {
        try {
            boolean localOnly = !args[0].equalsIgnoreCase("LocalOnly=false");
            Logger.getLogger().logLine("Setting: " + args[0]);
            if (localOnly) {
                Logger.getLogger().logLine("Only localhost Connections to Proxy will be accepted");
            } else {
                Logger.getLogger().logLine("Remote Connections to Proxy will be accepted");
            }
            this.remoteHost = InetAddress.getByName(args[2]);
            this.remotePort = Integer.parseInt(args[3]);
            if (args.length >= 5) {
                this.timeout = Integer.parseInt(args[4]);
            }
            if (args.length >= 6) {
                this.receivebuffer = Integer.parseInt(args[5]);
            }
            this.debug = args.length >= 7 ? args[6].equals("debug") : false;
            int localPort = Integer.parseInt(args[1]);
            this.listenerIN = this.openListener(localOnly, localPort);
            Logger.getLogger().logLine("Proxy main: serverSocket created on port " + localPort);
            if (!this.ASYNC) {
                this.runListenerLoop();
            } else {
                new Thread(this).start();
            }
        }
        catch (Exception e) {
            Logger.getLogger().logLine("Proxy main:" + e.toString());
            throw e;
        }
    }

    protected DataInputStream openListener(boolean localOnly, int port) throws IOException {
        String host = "0.0.0.0";
        if (localOnly) {
            host = "127.0.0.1";
        }
        HttpTunnelConnection con = new HttpTunnelConnection("$UDPBRIDGE$", 0, true);
        DataInputStream listenerIN = new DataInputStream(con.getInputStream());
        OutputStream conOut = con.getOutputStream();
        byte[] initPackage = ("server " + host + " " + port + " " + this.receivebuffer).getBytes();
        byte[] packetSize = Utils.intToByteArray(initPackage.length);
        conOut.write(packetSize);
        conOut.write(initPackage);
        conOut.flush();
        byte[] response = new byte[listenerIN.readInt()];
        listenerIN.readFully(response);
        String responseStr = new String(response);
        if (!responseStr.equals("OK")) {
            try {
                con.close();
            }
            catch (IOException ioe) {
                Logger.getLogger().logLine(ioe.getMessage());
            }
            throw new IOException(responseStr);
        }
        return listenerIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(UDPProxy udpProxy) {
        udpProxy.stop();
        Logger.getLogger().logLine("Closed UDP Proxy:" + udpProxy);
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Object obj = this.sessions.remove(String.valueOf(udpProxy.remoteHost) + ":" + udpProxy.remotePort);
            Logger.getLogger().log("Removed:" + obj);
        }
    }
}

